package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.GeoJSONFeature;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("_dataset_vector_getTile_200_response")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class DatasetVectorGetTile200Response   {
  public enum TypeEnum {

    FEATURECOLLECTION(String.valueOf("FeatureCollection"));


    private String value;

    TypeEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static TypeEnum fromString(String s) {
        for (TypeEnum b : TypeEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
	}
	
    @JsonCreator
    public static TypeEnum fromValue(String value) {
        for (TypeEnum b : TypeEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid TypeEnum type;
  private @Valid List<GeoJSONFeature> features = new ArrayList<>();
  private @Valid List<BigDecimal> bbox = null;

  /**
   **/
  public DatasetVectorGetTile200Response type(TypeEnum type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public TypeEnum getType() {
    return type;
  }

  @JsonProperty("type")
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   **/
  public DatasetVectorGetTile200Response features(List<GeoJSONFeature> features) {
    this.features = features;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("features")
  @NotNull
  public List<GeoJSONFeature> getFeatures() {
    return features;
  }

  @JsonProperty("features")
  public void setFeatures(List<GeoJSONFeature> features) {
    this.features = features;
  }

  public DatasetVectorGetTile200Response addFeaturesItem(GeoJSONFeature featuresItem) {
    if (this.features == null) {
      this.features = new ArrayList<>();
    }

    this.features.add(featuresItem);
    return this;
  }

  public DatasetVectorGetTile200Response removeFeaturesItem(GeoJSONFeature featuresItem) {
    if (featuresItem != null && this.features != null) {
      this.features.remove(featuresItem);
    }

    return this;
  }
  /**
   **/
  public DatasetVectorGetTile200Response bbox(List<BigDecimal> bbox) {
    this.bbox = bbox;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("bbox")
 @Size(min=4)  public List<BigDecimal> getBbox() {
    return bbox;
  }

  @JsonProperty("bbox")
  public void setBbox(List<BigDecimal> bbox) {
    this.bbox = bbox;
  }

  public DatasetVectorGetTile200Response addBboxItem(BigDecimal bboxItem) {
    if (this.bbox == null) {
      this.bbox = new ArrayList<>();
    }

    this.bbox.add(bboxItem);
    return this;
  }

  public DatasetVectorGetTile200Response removeBboxItem(BigDecimal bboxItem) {
    if (bboxItem != null && this.bbox != null) {
      this.bbox.remove(bboxItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DatasetVectorGetTile200Response datasetVectorGetTile200Response = (DatasetVectorGetTile200Response) o;
    return Objects.equals(this.type, datasetVectorGetTile200Response.type) &&
        Objects.equals(this.features, datasetVectorGetTile200Response.features) &&
        Objects.equals(this.bbox, datasetVectorGetTile200Response.bbox);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, features, bbox);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DatasetVectorGetTile200Response {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("    bbox: ").append(toIndentedString(bbox)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

