/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.time;

import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.time.AbstractTimeValue;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.ITimeFrameSource;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.time.TimeOfDay;

@Deprecated
public final class TimeFrame
implements ITimeFrameSource {
    private static final long serialVersionUID = 1L;
    private final Time end;
    private final Time start;

    public static ITimeFrameSource eachDay(final TimeOfDay startTimeOfDay, final TimeOfDay endTimeOfDay) {
        TimeFrame.check(startTimeOfDay, endTimeOfDay);
        return new ITimeFrameSource(){
            private static final long serialVersionUID = 1L;

            @Override
            public TimeFrame getTimeFrame() {
                return new TimeFrame(Time.valueOf(startTimeOfDay), Time.valueOf(endTimeOfDay));
            }
        };
    }

    public static TimeFrame valueOf(Time start, Duration duration) {
        return new TimeFrame(start, start.add(duration));
    }

    public static TimeFrame valueOf(Time start, Time end) {
        return new TimeFrame(start, end);
    }

    private static void check(AbstractTimeValue start, AbstractTimeValue end) {
        if (end.lessThan(start)) {
            throw new IllegalArgumentException("Start time of time frame " + String.valueOf(start) + " was after end time " + String.valueOf(end));
        }
    }

    private TimeFrame(Time start, Time end) {
        TimeFrame.check(start, end);
        this.start = start;
        this.end = end;
    }

    public boolean contains(Time time) {
        return (this.start.equals(time) || this.start.before(time)) && this.end.after(time);
    }

    public Duration getDuration() {
        return this.end.subtract(this.start);
    }

    public Time getEnd() {
        return this.end;
    }

    public Time getStart() {
        return this.start;
    }

    @Override
    public TimeFrame getTimeFrame() {
        return this;
    }

    public boolean overlaps(TimeFrame timeframe) {
        return this.contains(timeframe.start) || this.contains(timeframe.end) || timeframe.contains(this.start) || timeframe.contains(this.end);
    }

    public int hashCode() {
        return Objects.hashCode(this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeFrame other = (TimeFrame)obj;
        return Objects.equal(this.start, other.start) && Objects.equal(this.end, other.end);
    }

    public String toString() {
        return "[start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + "]";
    }
}

