/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.basic;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.extensions.markup.html.basic.ILinkParser;
import org.apache.wicket.extensions.markup.html.basic.ILinkRenderStrategy;
import org.apache.wicket.util.string.Strings;

public class LinkParser
implements ILinkParser {
    private final Map<Pattern, ILinkRenderStrategy> renderStrategies = new HashMap<Pattern, ILinkRenderStrategy>();

    public ILinkParser addLinkRenderStrategy(String pattern, ILinkRenderStrategy renderStrategy) {
        Pattern compiledPattern = Pattern.compile(pattern, 32);
        this.renderStrategies.put(compiledPattern, renderStrategy);
        return this;
    }

    @Override
    public String parse(String text) {
        if (Strings.isEmpty((String)text)) {
            return text;
        }
        String work = text;
        if (work.indexOf(60) == -1) {
            for (Map.Entry<Pattern, ILinkRenderStrategy> entry : this.renderStrategies.entrySet()) {
                Pattern pattern = entry.getKey();
                ILinkRenderStrategy strategy = entry.getValue();
                Matcher matcher = pattern.matcher(work);
                StringBuffer buffer = new StringBuffer();
                while (matcher.find()) {
                    String str = matcher.group();
                    matcher.appendReplacement(buffer, strategy.buildLink(str));
                }
                matcher.appendTail(buffer);
                work = buffer.toString();
            }
        }
        return work;
    }
}

