/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import java.util.List;
import java.util.Set;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.StringValue;

public interface INamedParameters {
    public Set<String> getNamedKeys();

    public StringValue get(String var1);

    public List<StringValue> getValues(String var1);

    public List<NamedPair> getAllNamed();

    public List<NamedPair> getAllNamedByType(Type var1);

    public int getPosition(String var1);

    public INamedParameters remove(String var1, String ... var2);

    public INamedParameters add(String var1, Object var2, Type var3);

    public INamedParameters add(String var1, Object var2, int var3, Type var4);

    public INamedParameters set(String var1, Object var2, int var3, Type var4);

    public INamedParameters set(String var1, Object var2, Type var3);

    public INamedParameters clearNamed();

    public static class NamedPair
    implements IClusterable {
        private final String key;
        private final String value;
        private final Type type;

        public NamedPair(String key, String value) {
            this(key, value, Type.MANUAL);
        }

        public NamedPair(String key, String value, Type type) {
            this.key = Args.notEmpty(key, "key");
            this.value = Args.notNull(value, "value");
            this.type = Args.notNull(type, "type");
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedPair namedPair = (NamedPair)o;
            if (this.key != null ? !this.key.equals(namedPair.key) : namedPair.key != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(namedPair.value) : namedPair.value != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    public static enum Type {
        MANUAL,
        QUERY_STRING,
        PATH;

    }
}

