/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.lang.reflect.InvocationTargetException;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;

public class ContextParamWebApplicationFactory
implements IWebApplicationFactory {
    public static final String APP_CLASS_PARAM = "applicationClassName";

    @Override
    public WebApplication createApplication(WicketFilter filter) {
        String applicationClassName = filter.getFilterConfig().getInitParameter(APP_CLASS_PARAM);
        if (applicationClassName == null) {
            throw new WicketRuntimeException("servlet init param [applicationClassName] is missing. If you are trying to use your own implementation of IWebApplicationFactory and get this message then the servlet init param [applicationFactoryClassName] is missing");
        }
        return this.createApplication(applicationClassName);
    }

    protected WebApplication createApplication(String applicationClassName) {
        try {
            Class<?> applicationClass;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            if (WebApplication.class.isAssignableFrom(applicationClass = Class.forName(applicationClassName, false, loader))) {
                return (WebApplication)applicationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            throw new WicketRuntimeException("Application class " + applicationClassName + " must be a subclass of WebApplication");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new WicketRuntimeException("Unable to create application of class " + applicationClassName, e);
        }
    }

    @Override
    public void destroy(WicketFilter filter) {
    }
}

