<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

## Change Log

### 3.1.0 (Tue Jan 9 15:05:00 2023 -0800)

**Database Migrations**

- [#26160](https://github.com/apache/superset/pull/26160) fix: Migration order due to cherry which went astray (@john-bodley)
- [#24776](https://github.com/apache/superset/pull/24776) chore(sqlalchemy): Remove erroneous SQLAlchemy ORM session.merge operations (@john-bodley)
- [#25819](https://github.com/apache/superset/pull/25819) chore: Singularize tag models (@john-bodley)
- [#25911](https://github.com/apache/superset/pull/25911) chore: remove deprecated functions in SQLAlchemy (@gnought)
- [#25304](https://github.com/apache/superset/pull/25304) feat: Adds CLI commands to execute viz migrations (@michael-s-molina)
- [#25204](https://github.com/apache/superset/pull/25204) feat(datasource): Checkbox for always filtering main dttm in datasource (@Always-prog)
- [#24832](https://github.com/apache/superset/pull/24832) fix: Alembic migration head (@john-bodley)
- [#24701](https://github.com/apache/superset/pull/24701) feat(Tags): Allow users to favorite Tags on CRUD Listview page (@hughhhh)
- [#24755](https://github.com/apache/superset/pull/24755) feat: Add line width unit control in deckgl Polygon and Path (@kgabryje)
- [#24700](https://github.com/apache/superset/pull/24700) chore: Update pylint to 2.17.4 (@EugeneTorap)

**Features**

- [#26031](https://github.com/apache/superset/pull/26031) feat(deckgl-map): use an arbitraty Mabpox style URL (#26027) (@francois-travais)
- [#26136](https://github.com/apache/superset/pull/26136) feat: Adds legacy time support for Waterfall chart (@michael-s-molina)
- [#26123](https://github.com/apache/superset/pull/26123) feat(helm): Add option to deploy extra containers to remaining deployments (@bluemalkin)
- [#24714](https://github.com/apache/superset/pull/24714) feat: Add Apache Doris support (@liujiwen-up)
- [#26033](https://github.com/apache/superset/pull/26033) feat: Add Bubble chart migration logic (@michael-s-molina)
- [#25921](https://github.com/apache/superset/pull/25921) feat(metadb): handle decimals (@betodealmeida)
- [#24539](https://github.com/apache/superset/pull/24539) feat(sqllab): non-blocking persistence mode (@justinpark)
- [#25861](https://github.com/apache/superset/pull/25861) feat(sqllab): Show duration as separate column in Query History view (@sebastianliebscher)
- [#25809](https://github.com/apache/superset/pull/25809) feat(sqllab): TRINO_EXPAND_ROWS: expand columns from ROWs (@giftig)
- [#25952](https://github.com/apache/superset/pull/25952) feat: Add Area chart migration and tweaks the Timeseries chart migration (@michael-s-molina)
- [#25950](https://github.com/apache/superset/pull/25950) feat(explore): dataset macro: dttm filter context (@giftig)
- [#23973](https://github.com/apache/superset/pull/23973) feat: Adds Line chart migration logic (@michael-s-molina)
- [#20323](https://github.com/apache/superset/pull/20323) feat: safer insert RLS (@betodealmeida)
- [#25882](https://github.com/apache/superset/pull/25882) feat: method for dynamic `allows_alias_in_select` (@betodealmeida)
- [#25855](https://github.com/apache/superset/pull/25855) feat(sqllab): Dynamic query limit dropdown (@giftig)
- [#25344](https://github.com/apache/superset/pull/25344) feat(sqllab): Format sql (@justinpark)
- [#25557](https://github.com/apache/superset/pull/25557) feat: Improves the Waterfall chart (@michael-s-molina)
- [#23308](https://github.com/apache/superset/pull/23308) feat: support databend for superset (@hantmac)
- [#25795](https://github.com/apache/superset/pull/25795) feat: support server-side sessions (@dpgaspar)
- [#25783](https://github.com/apache/superset/pull/25783) feat(helm): Add option to deploy extra containers to init job (@bluemalkin)
- [#25696](https://github.com/apache/superset/pull/25696) feat(Export as PDF - rasterized): Adding rasterized pdf functionality to dashboard (@fisjac)
- [#25676](https://github.com/apache/superset/pull/25676) feat: add France's regions to country map visualization (@dmeaux)
- [#25569](https://github.com/apache/superset/pull/25569) feat: add database and schema names to dataset option (@soniagtm)
- [#25666](https://github.com/apache/superset/pull/25666) feat: Funnel/tooltip-customization (@CorbinBullard)
- [#25683](https://github.com/apache/superset/pull/25683) feat: Add week time grain for Elasticsearch datasets (@mikelv92)
- [#25423](https://github.com/apache/superset/pull/25423) feat(sqllab): ResultTable extension (@justinpark)
- [#25542](https://github.com/apache/superset/pull/25542) feat(sqllab): Add keyboard shortcut helper (@justinpark)
- [#25565](https://github.com/apache/superset/pull/25565) feat: migrate to docker compose v2 (@mdeshmu)
- [#24154](https://github.com/apache/superset/pull/24154) feat: Add Deck.gl Contour Layer (@Mattc1221)
- [#17906](https://github.com/apache/superset/pull/17906) feat(plugin-chart-echarts): Echarts Waterfall (@stephenLYZ)
- [#22107](https://github.com/apache/superset/pull/22107) feat: Adds the ECharts Bubble chart (@mayurnewase)
- [#25151](https://github.com/apache/superset/pull/25151) feat(sqllab): SPA migration (@justinpark)
- [#25247](https://github.com/apache/superset/pull/25247) feat: Implement using Playwright for taking screenshots in reports (@kgabryje)
- [#25303](https://github.com/apache/superset/pull/25303) feat: generic marshmallow error component (@betodealmeida)
- [#25377](https://github.com/apache/superset/pull/25377) feat(docker): Use docker buildx and Add ARM builds for dockerize and websocket (@alekseyolg)
- [#25343](https://github.com/apache/superset/pull/25343) feat: Adds Sunburst chart migration logic (@michael-s-molina)
- [#25345](https://github.com/apache/superset/pull/25345) feat(sqllab): extra logging when chart is downloaded (@zephyring)
- [#25280](https://github.com/apache/superset/pull/25280) feat(helm): Support HPA for supersetNode and supersetWorker (@tenkian4)
- [#25309](https://github.com/apache/superset/pull/25309) feat(tag): fast follow for Tags flatten api + update client with generator + some bug fixes (@hughhhh)
- [#24964](https://github.com/apache/superset/pull/24964) feat: Tags ListView Page (@hughhhh)
- [#24787](https://github.com/apache/superset/pull/24787) feat(sqllab): Show sql in the current result (@justinpark)
- [#25105](https://github.com/apache/superset/pull/25105) feat: removing renderCard from Tags/index.tsc to remove cardview from Tags ListView (@fisjac)
- [#25089](https://github.com/apache/superset/pull/25089) feat(docker): refactor docker images (@alekseyolg)
- [#24839](https://github.com/apache/superset/pull/24839) feat: Update Tags CRUD API (@hughhhh)
- [#25065](https://github.com/apache/superset/pull/25065) feat: adding Scarf pixels to gather telemetry on readme and website (@rusackas)
- [#14225](https://github.com/apache/superset/pull/14225) feat: a native SQLAlchemy dialect for Superset (@betodealmeida)
- [#25001](https://github.com/apache/superset/pull/25001) feat: Moves Profile to Single Page App (SPA) (@michael-s-molina)
- [#24983](https://github.com/apache/superset/pull/24983) feat(sqllab): Add /sqllab endpoint to the v1 api (@justinpark)
- [#24918](https://github.com/apache/superset/pull/24918) feat: command to test DB engine specs (@betodealmeida)
- [#24921](https://github.com/apache/superset/pull/24921) feat(gsheets): file upload (@betodealmeida)
- [#24934](https://github.com/apache/superset/pull/24934) feat: add MotherDuck DB engine spec (@betodealmeida)
- [#24909](https://github.com/apache/superset/pull/24909) feat: improve SQLite DB engine spec (@betodealmeida)
- [#24870](https://github.com/apache/superset/pull/24870) feat(chart): Added Central Asia countries to countries map (@Zoynels)
- [#24702](https://github.com/apache/superset/pull/24702) feat: add empty state for Tags (@hughhhh)
- [#24768](https://github.com/apache/superset/pull/24768) feat: add pandas performance dependencies (@sebastianliebscher)
- [#24618](https://github.com/apache/superset/pull/24618) feat(csv-upload): Configurable max filesize (@giftig)
- [#24580](https://github.com/apache/superset/pull/24580) feat(database): Database Filtering via custom configuration (@Antonio-RiveroMartnez)

**Fixes**

- [#26429](https://github.com/apache/superset/pull/26429) fix(post-processing): handle missing values in cumulative operator (@villebro)
- [#26424](https://github.com/apache/superset/pull/26424) fix(translations): Clear all (@capping)
- [#26404](https://github.com/apache/superset/pull/26404) fix(plugin-chart-echarts): support forced categorical x-axis (@villebro)
- [#26415](https://github.com/apache/superset/pull/26415) fix: In chart gallery thumbnail is rendered in case of no example in #16707 (@sivasathyaseeelan)
- [#26393](https://github.com/apache/superset/pull/26393) fix(chart): Resolve incorrect column customization when switching metrics in table chart (@soniagtm)
- [#26405](https://github.com/apache/superset/pull/26405) fix(sqllab): Bump duckdb-engine version to 0.9.5 (@guenp)
- [#26313](https://github.com/apache/superset/pull/26313) fix(dashboard): narrow empty drop area (@justinpark)
- [#26410](https://github.com/apache/superset/pull/26410) fix(dashboard): Chart menu disable is fixed on chart-fullscreen in issue #25992 (@sivasathyaseeelan)
- [#26362](https://github.com/apache/superset/pull/26362) fix: Reactivates native filters E2E tests (@michael-s-molina)
- [#26398](https://github.com/apache/superset/pull/26398) fix(embed): an error occurred while rendering the visualization: error: Item with key ... is not registered. (@rowdyroad)
- [#26353](https://github.com/apache/superset/pull/26353) fix(SelectControl): select zero value (@rekilina)
- [#26380](https://github.com/apache/superset/pull/26380) fix: Removes non-existent columns in the 2018 FCC Survey dataset (@michael-s-molina)
- [#26302](https://github.com/apache/superset/pull/26302) fix: Invalid references in the basic template (@michael-s-molina)
- [#26379](https://github.com/apache/superset/pull/26379) fix: Duplicated plugin registration (@michael-s-molina)
- [#26378](https://github.com/apache/superset/pull/26378) fix(databend): databend time grain expression (@hantmac)
- [#26151](https://github.com/apache/superset/pull/26151) fix(chart): Set max row limit + removed the option to use an empty row limit value (@CorbinBullard)
- [#26312](https://github.com/apache/superset/pull/26312) fix(Embedded): Avoid creating a filter key for guest users (@Vitor-Avila)
- [#26333](https://github.com/apache/superset/pull/26333) fix(logging): Add logging of change_dashboard_filter event for native dashboard filters (@john-bodley)
- [#26326](https://github.com/apache/superset/pull/26326) fix(accessibility): Enable tabbing on sort header of table chart (@arunthirumani)
- [#26324](https://github.com/apache/superset/pull/26324) fix(tagging): adding tags containing a “:” to dashboards (@lilykuang)
- [#26340](https://github.com/apache/superset/pull/26340) fix(dashboard): Don't switch to first tab when directPathToChild changes (@kgabryje)
- [#26283](https://github.com/apache/superset/pull/26283) fix(redshift): convert_dttm method for redshift dataset and tests (@gaurav7261)
- [#26281](https://github.com/apache/superset/pull/26281) fix(sql lab): Use quote_schema instead of quote method to format schema name (@guenp)
- [#25967](https://github.com/apache/superset/pull/25967) fix(typings): model_id is a multiple option (@gnought)
- [#26284](https://github.com/apache/superset/pull/26284) fix: Revert "fix(sqllab): flaky json explore modal due to over-rendering (#26156)" (@justinpark)
- [#26279](https://github.com/apache/superset/pull/26279) fix: Cannot expand initially hidden SQL Lab tab (@michael-s-molina)
- [#26269](https://github.com/apache/superset/pull/26269) fix(plugin-chart-echarts): use scale for truncating x-axis (@villebro)
- [#26264](https://github.com/apache/superset/pull/26264) fix: Stacked charts with numerical columns (@michael-s-molina)
- [#26243](https://github.com/apache/superset/pull/26243) fix(plugin-chart-echarts): undefined bounds for bubble chart (@villebro)
- [#26224](https://github.com/apache/superset/pull/26224) fix: Use page.locator in Playwright reports (@kgabryje)
- [#26156](https://github.com/apache/superset/pull/26156) fix(sqllab): flaky json explore modal due to over-rendering (@justinpark)
- [#25533](https://github.com/apache/superset/pull/25533) fix(menu): Styling active menu in SPA navigation (@justinpark)
- [#25977](https://github.com/apache/superset/pull/25977) fix(sqllab): table preview has gone (@justinpark)
- [#26066](https://github.com/apache/superset/pull/26066) fix: move driver import to method (@giftig)
- [#25934](https://github.com/apache/superset/pull/25934) fix(tag): update state to clear form on success (@hughhhh)
- [#25941](https://github.com/apache/superset/pull/25941) fix(sqllab): Allow router navigation to explore (@justinpark)
- [#25875](https://github.com/apache/superset/pull/25875) fix(typo): replace 'datasouce_id' with 'datasource_id' in openapi.json (@nero5700)
- [#25856](https://github.com/apache/superset/pull/25856) fix(tagging): change key from name to id for tagToSelectOption (@lilykuang)
- [#25831](https://github.com/apache/superset/pull/25831) fix: add validation on tag name to have name + onDelete refresh list view (@hughhhh)
- [#25851](https://github.com/apache/superset/pull/25851) fix: databend png pic (@hantmac)
- [#25803](https://github.com/apache/superset/pull/25803) fix(helm): Fix init extra containers (@bluemalkin)
- [#25739](https://github.com/apache/superset/pull/25739) fix(README): mismatched picture tags (@andy-clapson)
- [#25727](https://github.com/apache/superset/pull/25727) fix(metadb): handle durations (@betodealmeida)
- [#25718](https://github.com/apache/superset/pull/25718) fix(driver): bumping DuckDB to 0.9.2 (@rusackas)
- [#25603](https://github.com/apache/superset/pull/25603) fix(tags): +n tags for listview (@hughhhh)
- [#25578](https://github.com/apache/superset/pull/25578) fix(tags): Polish + Better messaging for skipped tags with bad permissions (@hughhhh)
- [#25582](https://github.com/apache/superset/pull/25582) fix(sqllab): Allow opening of SQL Lab in new browser tab (@justinpark)
- [#25615](https://github.com/apache/superset/pull/25615) fix(test-db): engine params (@betodealmeida)
- [#25532](https://github.com/apache/superset/pull/25532) fix: Breaking change in MachineAuthProvider constructor (@kgabryje)
- [#25547](https://github.com/apache/superset/pull/25547) fix: Make `host.docker.internal` available on linux (@sebastianliebscher)
- [#25536](https://github.com/apache/superset/pull/25536) fix: Tags Page ListView size to 10 (@hughhhh)
- [#25525](https://github.com/apache/superset/pull/25525) fix(test-db): removed attribute (@betodealmeida)
- [#25473](https://github.com/apache/superset/pull/25473) fix(tags): Update loading + pagination for Tags Page (@hughhhh)
- [#25470](https://github.com/apache/superset/pull/25470) fix(tags): fix clears delete on Tags Modal (@hughhhh)
- [#25496](https://github.com/apache/superset/pull/25496) fix: Tags Polish II (@hughhhh)
- [#24927](https://github.com/apache/superset/pull/24927) fix(Indian Map Changes): fixed-Indian-map-border (@Yaswanth-Perumalla)
- [#25403](https://github.com/apache/superset/pull/25403) fix: Tags Page Polish (@hughhhh)
- [#25306](https://github.com/apache/superset/pull/25306) fix(sqllab): misplaced limit warning alert (@justinpark)
- [#25361](https://github.com/apache/superset/pull/25361) fix: update helm chart app version (@hugosjoberg)
- [#25308](https://github.com/apache/superset/pull/25308) fix(sqllab): invalid persisted tab state (@justinpark)
- [#25216](https://github.com/apache/superset/pull/25216) fix(docs): Fixing a typo in README.md (@yousoph)
- [#25152](https://github.com/apache/superset/pull/25152) fix(sqllab): invalid reducer key name (@justinpark)
- [#25124](https://github.com/apache/superset/pull/25124) fix: Partially reverts #25007 (@michael-s-molina)
- [#25067](https://github.com/apache/superset/pull/25067) fix: small fixes for the meta DB (@betodealmeida)
- [#24963](https://github.com/apache/superset/pull/24963) fix(gsheets): add column names on file upload (@betodealmeida)
- [#24955](https://github.com/apache/superset/pull/24955) fix: timezone issue in Pandas 2 (@betodealmeida)
- [#24952](https://github.com/apache/superset/pull/24952) fix: `to_datetime` in Pandas 2 (@betodealmeida)
- [#24871](https://github.com/apache/superset/pull/24871) fix: Ignores hot update files when generating the manifest (@michael-s-molina)
- [#24868](https://github.com/apache/superset/pull/24868) fix: Ignores ResizeObserver errors in development mode (@michael-s-molina)

**Others**

- [#25770](https://github.com/apache/superset/pull/25770) chore: Add example charts for deck.gl (@willie-hung)
- [#26317](https://github.com/apache/superset/pull/26317) chore: Adds a tooltip for the alert's SQL input (@michael-s-molina)
- [#26297](https://github.com/apache/superset/pull/26297) chore: Add downloadAsImage types, change filter selector (@kgabryje)
- [#26315](https://github.com/apache/superset/pull/26315) chore: Use WEBDRIVER_OPTION_ARGS with Playwright (@kgabryje)
- [#26310](https://github.com/apache/superset/pull/26310) chore: Disables minor ticks by default (@michael-s-molina)
- [#26287](https://github.com/apache/superset/pull/26287) chore: update changelog for 2.1.3 (@eschutho)
- [#26251](https://github.com/apache/superset/pull/26251) chore: improve CSP add base uri restriction (@dpgaspar)
- [#26082](https://github.com/apache/superset/pull/26082) chore: lock the databend-sqlalchemy version (@hantmac)
- [#26212](https://github.com/apache/superset/pull/26212) chore: Moves xAxisLabelRotation to shared controls (@michael-s-molina)
- [#26188](https://github.com/apache/superset/pull/26188) chore: Lower giveup log level for retried functions to warning (@jfrag1)
- [#25961](https://github.com/apache/superset/pull/25961) chore: harmonize and clean up list views (@villebro)
- [#26147](https://github.com/apache/superset/pull/26147) chore: Rename SET_ACTIVE_TABS action, add a new action (@kgabryje)
- [#25996](https://github.com/apache/superset/pull/25996) chore(tags): Allow for lookup via ids vs. name in the API (@hughhhh)
- [#26058](https://github.com/apache/superset/pull/26058) chore: Adds the 3.1.0 Release Notes (@michael-s-molina)
- [#26000](https://github.com/apache/superset/pull/26000) docs(databases): Update pinot.mdx to incorporate username and password based connection. (@raamri)
- [#26075](https://github.com/apache/superset/pull/26075) chore: Adds 3.0.2 data to CHANGELOG.md (@michael-s-molina)
- [#25850](https://github.com/apache/superset/pull/25850) chore(command): Organize Commands according to SIP-92 (@john-bodley)
- [#26073](https://github.com/apache/superset/pull/26073) chore: Updates Announce template to include CHANGELOG.md and UPDATING.md files (@michael-s-molina)
- [#26064](https://github.com/apache/superset/pull/26064) build(deps-dev): bump @types/node from 20.9.3 to 20.9.4 in /superset-websocket (@dependabot[bot])
- [#26063](https://github.com/apache/superset/pull/26063) build(deps): bump @types/lodash from 4.14.201 to 4.14.202 in /superset-websocket (@dependabot[bot])
- [#25844](https://github.com/apache/superset/pull/25844) chore: Allow only iterables for BaseDAO.delete() (@john-bodley)
- [#25917](https://github.com/apache/superset/pull/25917) docs: update security policy and contributing (@dpgaspar)
- [#24773](https://github.com/apache/superset/pull/24773) chore(connector): Cleanup base models and views according to SIP-92 (@john-bodley)
- [#26039](https://github.com/apache/superset/pull/26039) docs(intro): fix a single broken link (BugHerd #97) (@sfirke)
- [#26049](https://github.com/apache/superset/pull/26049) build(deps-dev): bump @types/node from 20.9.1 to 20.9.3 in /superset-websocket (@dependabot[bot])
- [#26048](https://github.com/apache/superset/pull/26048) build(deps-dev): bump @types/ws from 8.5.9 to 8.5.10 in /superset-websocket (@dependabot[bot])
- [#26043](https://github.com/apache/superset/pull/26043) chore: bump shillelagh (@betodealmeida)
- [#26004](https://github.com/apache/superset/pull/26004) chore: Allow external extensions to include their own package.json files (@kgabryje)
- [#26044](https://github.com/apache/superset/pull/26044) docs(BH#109): Athena URI spec fix (@rusackas)
- [#26025](https://github.com/apache/superset/pull/26025) build(deps-dev): bump eslint from 8.53.0 to 8.54.0 in /superset-websocket (@dependabot[bot])
- [#26013](https://github.com/apache/superset/pull/26013) chore: cleanup unused code in pandas 2.0+ (@gnought)
- [#26012](https://github.com/apache/superset/pull/26012) build(deps-dev): bump @types/node from 20.9.0 to 20.9.1 in /superset-websocket (@dependabot[bot])
- [#26009](https://github.com/apache/superset/pull/26009) chore: Remove unnecessary autoflush from tagging and key/value workflows (@john-bodley)
- [#25551](https://github.com/apache/superset/pull/25551) docs: handling "System limit for number of file watchers reached" error (@nitish-samsung-jha)
- [#25986](https://github.com/apache/superset/pull/25986) chore: Remove more redundant code in utils/core (@sebastianliebscher)
- [#24485](https://github.com/apache/superset/pull/24485) style: Transition of Navbar from dark to light and vice-versa is now smooth (@git-init-priyanshu)
- [#25059](https://github.com/apache/superset/pull/25059) docs: add Tentacle to users list (@jdclarke5)
- [#25968](https://github.com/apache/superset/pull/25968) chore: Add entry point for SliceHeader frontend extension (@kgabryje)
- [#25891](https://github.com/apache/superset/pull/25891) chore: support different JWT CSRF cookie names (@dpgaspar)
- [#25953](https://github.com/apache/superset/pull/25953) build(deps-dev): bump axios from 0.25.0 to 1.6.0 in /superset-embedded-sdk (@dependabot[bot])
- [#25927](https://github.com/apache/superset/pull/25927) build(deps-dev): bump @types/jsonwebtoken from 9.0.4 to 9.0.5 in /superset-websocket (@dependabot[bot])
- [#25929](https://github.com/apache/superset/pull/25929) build(deps-dev): bump @types/uuid from 9.0.6 to 9.0.7 in /superset-websocket (@dependabot[bot])
- [#25958](https://github.com/apache/superset/pull/25958) test: Reduce flaky integration tests triggered by `test_get_tag` (@sebastianliebscher)
- [#25948](https://github.com/apache/superset/pull/25948) chore: Simplify views/base (@sebastianliebscher)
- [#25951](https://github.com/apache/superset/pull/25951) build(deps): bump axios from 1.4.0 to 1.6.1 in /superset-frontend (@dependabot[bot])
- [#25881](https://github.com/apache/superset/pull/25881) chore(issue template): attempting to fix two entries/links (@rusackas)
- [#25926](https://github.com/apache/superset/pull/25926) chore: removing unused chartMetadata field (@rusackas)
- [#25928](https://github.com/apache/superset/pull/25928) build(deps-dev): bump @types/node from 20.8.10 to 20.9.0 in /superset-websocket (@dependabot[bot])
- [#25885](https://github.com/apache/superset/pull/25885) docs: Remove Python 3.8 from CONTRIBUTING.md (@koushik-rout-samsung)
- [#25900](https://github.com/apache/superset/pull/25900) chore: Simplify utils/cache by using default argument values (@sebastianliebscher)
- [#25912](https://github.com/apache/superset/pull/25912) chore: remove unused functions in utils/core (@sebastianliebscher)
- [#25907](https://github.com/apache/superset/pull/25907) build(deps): bump @types/lodash from 4.14.200 to 4.14.201 in /superset-websocket (@dependabot[bot])
- [#25906](https://github.com/apache/superset/pull/25906) build(deps-dev): bump @types/ws from 8.5.7 to 8.5.9 in /superset-websocket (@dependabot[bot])
- [#25905](https://github.com/apache/superset/pull/25905) build(deps-dev): bump @types/cookie from 0.5.3 to 0.5.4 in /superset-websocket (@dependabot[bot])
- [#25262](https://github.com/apache/superset/pull/25262) chore: add more migration tests (@eschutho)
- [#25886](https://github.com/apache/superset/pull/25886) build(deps): bump cookie from 0.5.0 to 0.6.0 in /superset-websocket (@dependabot[bot])
- [#25714](https://github.com/apache/superset/pull/25714) chore: Update INTHEWILD.md (@codek)
- [#25867](https://github.com/apache/superset/pull/25867) build(deps-dev): bump eslint from 8.52.0 to 8.53.0 in /superset-websocket (@dependabot[bot])
- [#25852](https://github.com/apache/superset/pull/25852) chore: Updates Databend image extension reference in README.md (@michael-s-molina)
- [#25531](https://github.com/apache/superset/pull/25531) docs: Update location of `async_query_manager.py` (@emmanuel-ferdman)
- [#25817](https://github.com/apache/superset/pull/25817) chore(docker-compose): more host network specifiers (@giftig)
- [#25812](https://github.com/apache/superset/pull/25812) chore: Removes border of the color picker control (@michael-s-molina)
- [#25826](https://github.com/apache/superset/pull/25826) chore(websocket): Adding support for redis username in websocket server (@craig-rueda)
- [#25822](https://github.com/apache/superset/pull/25822) chore: Update sip.md to have a better call to action (@rusackas)
- [#25823](https://github.com/apache/superset/pull/25823) chore(issues): config.yaml added with feature request link to open a discussion (@rusackas)
- [#25816](https://github.com/apache/superset/pull/25816) build(deps-dev): bump @types/node from 20.8.7 to 20.8.10 in /superset-websocket (@dependabot[bot])
- [#25530](https://github.com/apache/superset/pull/25530) docs: Add Cyberhaven to Users list (@ghost)
- [#25314](https://github.com/apache/superset/pull/25314) chore(celery): Cleanup config and async query specifications (@john-bodley)
- [#25778](https://github.com/apache/superset/pull/25778) build(deps): bump browserify-sign from 4.2.1 to 4.2.2 in /superset-frontend (@dependabot[bot])
- [#24046](https://github.com/apache/superset/pull/24046) chore(security): Make get_database_perm/get_dataset_perm return optional (@john-bodley)
- [#25765](https://github.com/apache/superset/pull/25765) chore: Add config options for Playwright wait_until and default timeout (@kgabryje)
- [#25721](https://github.com/apache/superset/pull/25721) style(readme): reformatted (@bipinct)
- [#25737](https://github.com/apache/superset/pull/25737) chore: bump pymssql version (@gnought)
- [#25521](https://github.com/apache/superset/pull/25521) chore(websocket): [WIP] Making JWT algos configurable (@craig-rueda)
- [#25735](https://github.com/apache/superset/pull/25735) build(deps-dev): bump eslint from 8.51.0 to 8.52.0 in /superset-websocket (@dependabot[bot])
- [#25726](https://github.com/apache/superset/pull/25726) chore: updated base DAO find_by_id to return generic type (@zephyring)
- [#25717](https://github.com/apache/superset/pull/25717) refactor: use DATE_TRUNC for Elasticsearch time grain (@mikelv92)
- [#25709](https://github.com/apache/superset/pull/25709) chore: helm chart: bump appVersion to 3.0.1 (@mdavidsen)
- [#25577](https://github.com/apache/superset/pull/25577) chore: Change the format for sha512 sum for releases (@sebastianliebscher)
- [#25689](https://github.com/apache/superset/pull/25689) build(deps-dev): bump @types/cookie from 0.5.1 to 0.5.3 in /superset-websocket (@dependabot[bot])
- [#25701](https://github.com/apache/superset/pull/25701) build(deps-dev): bump @types/uuid from 9.0.4 to 9.0.6 in /superset-websocket (@dependabot[bot])
- [#25710](https://github.com/apache/superset/pull/25710) docs(README): Fix typo (@RahulK4102)
- [#25700](https://github.com/apache/superset/pull/25700) build(deps-dev): bump @types/node from 20.8.6 to 20.8.7 in /superset-websocket (@dependabot[bot])
- [#25322](https://github.com/apache/superset/pull/25322) chore: add latest docker tag (@eschutho)
- [#25691](https://github.com/apache/superset/pull/25691) chore: Adds 3.0.1 data to CHANGELOG.md (@michael-s-molina)
- [#25688](https://github.com/apache/superset/pull/25688) build(deps-dev): bump @types/jsonwebtoken from 9.0.3 to 9.0.4 in /superset-websocket (@dependabot[bot])
- [#25543](https://github.com/apache/superset/pull/25543) chore: Cleanup hostNamesConfig.js (@john-bodley)
- [#25654](https://github.com/apache/superset/pull/25654) docs: make project-specific security page more prominent (@raboof)
- [#25667](https://github.com/apache/superset/pull/25667) chore: sync lock files (@villebro)
- [#25661](https://github.com/apache/superset/pull/25661) build(deps-dev): bump @babel/traverse from 7.16.0 to 7.23.2 in /superset-websocket (@dependabot[bot])
- [#25653](https://github.com/apache/superset/pull/25653) build(deps-dev): bump @types/node from 20.8.5 to 20.8.6 in /superset-websocket (@dependabot[bot])
- [#25645](https://github.com/apache/superset/pull/25645) chore: bump pip-tools (@villebro)
- [#25537](https://github.com/apache/superset/pull/25537) docs: invert logo color for dark theme in README (@Sea-n)
- [#25629](https://github.com/apache/superset/pull/25629) chore: adding resource links to readme (@rusackas)
- [#25638](https://github.com/apache/superset/pull/25638) build(ci): Provide diff for pre-commit failures (@jsoref)
- [#25632](https://github.com/apache/superset/pull/25632) build(deps-dev): bump @types/node from 20.8.4 to 20.8.5 in /superset-websocket (@dependabot[bot])
- [#25455](https://github.com/apache/superset/pull/25455) chore(helm): spelling: initialize (@jsoref)
- [#25567](https://github.com/apache/superset/pull/25567) docs: BugHerd Tasks 88, 89, 90, 91 (@mdeshmu)
- [#25602](https://github.com/apache/superset/pull/25602) chore(feature?): Bump `scarf-js` to 1.3.0 to get more telemetry data (@rusackas)
- [#25502](https://github.com/apache/superset/pull/25502) build(deps): bump postcss from 8.3.11 to 8.4.31 in /docs (@dependabot[bot])
- [#19056](https://github.com/apache/superset/pull/19056) docs: Add timezone information (@john-bodley)
- [#25340](https://github.com/apache/superset/pull/25340) refactor: Issue #25040; Refactored sync_role_definition function in order to reduce number of query. (@suicide11)
- [#25606](https://github.com/apache/superset/pull/25606) build(deps-dev): bump @types/ws from 8.5.6 to 8.5.7 in /superset-websocket (@dependabot[bot])
- [#25585](https://github.com/apache/superset/pull/25585) build(deps): bump winston from 3.10.0 to 3.11.0 in /superset-websocket (@dependabot[bot])
- [#25584](https://github.com/apache/superset/pull/25584) build(deps-dev): bump @types/node from 20.8.2 to 20.8.4 in /superset-websocket (@dependabot[bot])
- [#25566](https://github.com/apache/superset/pull/25566) chore: Update pylint to 2.17.7 (@EugeneTorap)
- [#25574](https://github.com/apache/superset/pull/25574) build(deps-dev): bump eslint from 8.49.0 to 8.51.0 in /superset-websocket (@dependabot[bot])
- [#25228](https://github.com/apache/superset/pull/25228) chore(sqllab): Typescript for SqlEditor component (@justinpark)
- [#25507](https://github.com/apache/superset/pull/25507) chore(tags): don't allow users to create new tags from property dropdowns (@hughhhh)
- [#25504](https://github.com/apache/superset/pull/25504) chore(tags): move tags column in dashboard and chart list (@lilykuang)
- [#24481](https://github.com/apache/superset/pull/24481) docs: fix for domain sharding results in failed requests with "Missing Authorization Header" (@ved-kashyap-samsung)
- [#25508](https://github.com/apache/superset/pull/25508) build(deps): bump ws and @types/ws in /superset-websocket (@dependabot[bot])
- [#25498](https://github.com/apache/superset/pull/25498) build(deps-dev): bump @types/node from 20.6.0 to 20.8.2 in /superset-websocket (@dependabot[bot])
- [#25480](https://github.com/apache/superset/pull/25480) docs: define localhost for docker (@mdeshmu)
- [#25479](https://github.com/apache/superset/pull/25479) docs: update docker compose instructions (@mdeshmu)
- [#25482](https://github.com/apache/superset/pull/25482) docs: add a FAQ about asset recovery from UI (@mdeshmu)
- [#25477](https://github.com/apache/superset/pull/25477) docs: add https & ldap instructions (@mdeshmu)
- [#25466](https://github.com/apache/superset/pull/25466) chore(async): Initial Refactoring of Global Async Queries (@craig-rueda)
- [#25120](https://github.com/apache/superset/pull/25120) build(deps-dev): bump prettier from 3.0.2 to 3.0.3 in /superset-websocket (@dependabot[bot])
- [#25325](https://github.com/apache/superset/pull/25325) build(deps-dev): bump @types/jsonwebtoken from 9.0.2 to 9.0.3 in /superset-websocket (@dependabot[bot])
- [#25435](https://github.com/apache/superset/pull/25435) docs(FAQ): remove reference to filter box, add Q&A re: usage analytics (@sfirke)
- [#25438](https://github.com/apache/superset/pull/25438) chore: Update Explore tooltip copy (@yousoph)
- [#25465](https://github.com/apache/superset/pull/25465) chore(misc): Typos in config.py (@JZ6)
- [#25457](https://github.com/apache/superset/pull/25457) chore(backend): Spelling (@jsoref)
- [#25456](https://github.com/apache/superset/pull/25456) chore(misc): Spelling (@jsoref)
- [#25453](https://github.com/apache/superset/pull/25453) chore(docs): Spelling (@jsoref)
- [#25441](https://github.com/apache/superset/pull/25441) build(deps): bump get-func-name from 2.0.0 to 2.0.2 in /superset-frontend/cypress-base (@dependabot[bot])
- [#25276](https://github.com/apache/superset/pull/25276) chore: cryptography version bump (@lilykuang)
- [#25332](https://github.com/apache/superset/pull/25332) docs: update docker-compose (@nytai)
- [#25362](https://github.com/apache/superset/pull/25362) chore: upgrade node to most recent 16.x (@villebro)
- [#25360](https://github.com/apache/superset/pull/25360) chore: Adds 3.0 data to CHANGELOG and UPDATING (@michael-s-molina)
- [#25346](https://github.com/apache/superset/pull/25346) chore(async): Making create app configurable (@craig-rueda)
- [#24928](https://github.com/apache/superset/pull/24928) docs: jwks_uri addition to OAUTH provider (@kravi21)
- [#25312](https://github.com/apache/superset/pull/25312) docs: add snowflake-sqlalchemy in ./docker/requirements-local.txt (@janhavitripurwar)
- [#25324](https://github.com/apache/superset/pull/25324) docs: add ReadyTech to INTHEWILD.md (@jbat)
- [#25313](https://github.com/apache/superset/pull/25313) chore: bump gunicorn to v21 (@villebro)
- [#25311](https://github.com/apache/superset/pull/25311) build(deps-dev): bump @types/uuid from 9.0.3 to 9.0.4 in /superset-websocket (@dependabot[bot])
- [#25274](https://github.com/apache/superset/pull/25274) chore(sqllab): Migrate tests to typescript (@justinpark)
- [#25291](https://github.com/apache/superset/pull/25291) chore: changing one word (disablement -> disabling) (@rusackas)
- [#25287](https://github.com/apache/superset/pull/25287) build(docker): bump geckodriver and firefox to latest (@alekseyolg)
- [#25293](https://github.com/apache/superset/pull/25293) build(deps): bump ws from 8.13.0 to 8.14.1 in /superset-websocket (@dependabot[bot])
- [#25296](https://github.com/apache/superset/pull/25296) docs: rewrite superset docker localhost prose (@jsoref)
- [#25279](https://github.com/apache/superset/pull/25279) build(deps): bump uuid from 9.0.0 to 9.0.1 in /superset-websocket (@dependabot[bot])
- [#25263](https://github.com/apache/superset/pull/25263) build(deps-dev): bump eslint from 8.48.0 to 8.49.0 in /superset-websocket (@dependabot[bot])
- [#25253](https://github.com/apache/superset/pull/25253) build(deps-dev): bump @types/node from 20.5.7 to 20.6.0 in /superset-websocket (@dependabot[bot])
- [#20631](https://github.com/apache/superset/pull/20631) refactor: Remove obsolete HiveEngineSpec.fetch_logs method (@john-bodley)
- [#25226](https://github.com/apache/superset/pull/25226) chore(read_csv): remove deprecated argument (@betodealmeida)
- [#25177](https://github.com/apache/superset/pull/25177) chore: Convert deckgl class components to functional (@kgabryje)
- [#24992](https://github.com/apache/superset/pull/24992) docs(FAQ): add answer re: necessary specs, copy-edit existing answer (@sfirke)
- [#25165](https://github.com/apache/superset/pull/25165) chore: back port 2.1.1 doc changes (@eschutho)
- [#25206](https://github.com/apache/superset/pull/25206) docs: add CVEs for 2.1.1 (@dpgaspar)
- [#25200](https://github.com/apache/superset/pull/25200) docs: fix wrong type in PREFERRED_DATABASES example (@cmontemuino)
- [#25160](https://github.com/apache/superset/pull/25160) chore: fix broken link to Celery worker docs (@wAVeckx)
- [#25142](https://github.com/apache/superset/pull/25142) build(deps-dev): bump @types/uuid from 9.0.2 to 9.0.3 in /superset-websocket (@dependabot[bot])
- [#25141](https://github.com/apache/superset/pull/25141) build(deps): bump jsonwebtoken from 9.0.1 to 9.0.2 in /superset-websocket (@dependabot[bot])
- [#25140](https://github.com/apache/superset/pull/25140) build(deps): bump jsonwebtoken from 9.0.1 to 9.0.2 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#25088](https://github.com/apache/superset/pull/25088) chore: consolidate sqllab store into SPA store (@justinpark)
- [#25121](https://github.com/apache/superset/pull/25121) chore: move TypedDict from typing_extensions to typing (@sebastianliebscher)
- [#24896](https://github.com/apache/superset/pull/24896) chore: use contextlib.surpress instead of passing on error (@sebastianliebscher)
- [#25098](https://github.com/apache/superset/pull/25098) build(deps-dev): bump eslint from 8.47.0 to 8.48.0 in /superset-websocket (@dependabot[bot])
- [#25097](https://github.com/apache/superset/pull/25097) build(deps-dev): bump @types/node from 20.5.6 to 20.5.7 in /superset-websocket (@dependabot[bot])
- [#24933](https://github.com/apache/superset/pull/24933) chore: Refactor deck.gl plugins to Typescript (@kgabryje)
- [#24980](https://github.com/apache/superset/pull/24980) chore: Update docs for docker-compose installation (@hughhhh)
- [#24771](https://github.com/apache/superset/pull/24771) docs(docker-compose): add missing parenthesis (@sfirke)
- [#25082](https://github.com/apache/superset/pull/25082) build(deps-dev): bump @types/node from 20.5.1 to 20.5.6 in /superset-websocket (@dependabot[bot])
- [#25080](https://github.com/apache/superset/pull/25080) chore(reports): add metrics to report schedule and log prune (@villebro)
- [#25047](https://github.com/apache/superset/pull/25047) chore(sqllab): typescript for getInitialState (@justinpark)
- [#25030](https://github.com/apache/superset/pull/25030) build(deps): Bump PyHive (@mdeshmu)
- [#24872](https://github.com/apache/superset/pull/24872) test(cypress): Fail Cypress on Console errors (@rusackas)
- [#25046](https://github.com/apache/superset/pull/25046) chore: Organizes the files of the ReportModal feature (@michael-s-molina)
- [#25045](https://github.com/apache/superset/pull/25045) chore(tests): Adding missing **init**.py files to various test packages (@craig-rueda)
- [#25038](https://github.com/apache/superset/pull/25038) build(deps-dev): bump @types/node from 20.5.0 to 20.5.1 in /superset-websocket (@dependabot[bot])
- [#25010](https://github.com/apache/superset/pull/25010) chore(sqllab): Relocate user in SqlLab to root (@justinpark)
- [#25034](https://github.com/apache/superset/pull/25034) docs: fix line break in Apache Druid page (@giuliotal)
- [#24994](https://github.com/apache/superset/pull/24994) chore: rename `get_iterable` (@betodealmeida)
- [#25007](https://github.com/apache/superset/pull/25007) chore: Removes Saved Query old code (@michael-s-molina)
- [#24894](https://github.com/apache/superset/pull/24894) chore: Update DAOs to use singular deletion method instead of bulk (@jfrag1)
- [#25005](https://github.com/apache/superset/pull/25005) chore: Removes src/modules top folder (@michael-s-molina)
- [#24998](https://github.com/apache/superset/pull/24998) build(deps-dev): bump prettier from 3.0.1 to 3.0.2 in /superset-websocket (@dependabot[bot])
- [#24941](https://github.com/apache/superset/pull/24941) chore(dashboard import/export): include additional fields to export/import commands (@Vitor-Avila)
- [#24967](https://github.com/apache/superset/pull/24967) chore(dao): Remove redundant convenience methods (@john-bodley)
- [#24973](https://github.com/apache/superset/pull/24973) build(deps-dev): bump @types/node from 20.4.9 to 20.5.0 in /superset-websocket (@dependabot[bot])
- [#24972](https://github.com/apache/superset/pull/24972) build(deps-dev): bump eslint from 8.46.0 to 8.47.0 in /superset-websocket (@dependabot[bot])
- [#24936](https://github.com/apache/superset/pull/24936) chore(sqllab): Relocate get bootstrap data logic (@justinpark)
- [#24467](https://github.com/apache/superset/pull/24467) chore(dao): Replace save/overwrite with create/update respectively (@john-bodley)
- [#24962](https://github.com/apache/superset/pull/24962) docs: Add wattbewerb to users list (@hbruch)
- [#24961](https://github.com/apache/superset/pull/24961) chore: Add Automattic to the list of users and contributors (@Khrol)
- [#24958](https://github.com/apache/superset/pull/24958) build(deps): bump tough-cookie and @cypress/request in /superset-frontend/cypress-base (@dependabot[bot])
- [#24920](https://github.com/apache/superset/pull/24920) docs: Fixing Superset typo in docker-compose local installation guide (@TannerBarcelos)
- [#24924](https://github.com/apache/superset/pull/24924) build(deps-dev): bump @types/node from 20.4.8 to 20.4.9 in /superset-websocket (@dependabot[bot])
- [#24915](https://github.com/apache/superset/pull/24915) docs: fix tip box in "Installing From Scratch" page (@giuliotal)
- [#24878](https://github.com/apache/superset/pull/24878) build(deps-dev): bump prettier from 2.8.8 to 3.0.1 in /superset-websocket (@dependabot[bot])
- [#24900](https://github.com/apache/superset/pull/24900) build(deps-dev): bump eslint-config-prettier from 8.10.0 to 9.0.0 in /superset-websocket (@dependabot[bot])
- [#24901](https://github.com/apache/superset/pull/24901) build(deps-dev): bump @types/node from 20.4.7 to 20.4.8 in /superset-websocket (@dependabot[bot])
- [#24888](https://github.com/apache/superset/pull/24888) build(deps-dev): bump @types/node from 20.4.6 to 20.4.7 in /superset-websocket (@dependabot[bot])
- [#24880](https://github.com/apache/superset/pull/24880) build(deps-dev): bump @types/node from 20.4.5 to 20.4.6 in /superset-websocket (@dependabot[bot])
- [#24879](https://github.com/apache/superset/pull/24879) build(deps-dev): bump eslint-config-prettier from 8.8.0 to 8.10.0 in /superset-websocket (@dependabot[bot])
- [#24873](https://github.com/apache/superset/pull/24873) docs(native-filters): Remove outdated statement (@john-bodley)
- [#24657](https://github.com/apache/superset/pull/24657) chore: Bump cryptography (@suryadev99)
- [#24842](https://github.com/apache/superset/pull/24842) build(deps-dev): bump eslint from 8.45.0 to 8.46.0 in /superset-websocket (@dependabot[bot])
- [#24838](https://github.com/apache/superset/pull/24838) chore(api): clean up API spec (@sebastianliebscher)
- [#24834](https://github.com/apache/superset/pull/24834) docs(Kubernetes): Fix typos, clarify language re: Scarf (@sfirke)
- [#24819](https://github.com/apache/superset/pull/24819) chore: remove get_columns_description duplication (@betodealmeida)
- [#24817](https://github.com/apache/superset/pull/24817) docs: Adding a couple links to contributing page (@rusackas)
- [#24820](https://github.com/apache/superset/pull/24820) docs: fixing stack overflow link (@rusackas)
- [#24809](https://github.com/apache/superset/pull/24809) build(deps-dev): bump @types/node from 20.4.4 to 20.4.5 in /superset-websocket (@dependabot[bot])
- [#19959](https://github.com/apache/superset/pull/19959) docs(K8s): Add instructions for loading the examples (@charris-msft)
- [#24147](https://github.com/apache/superset/pull/24147) chore: bump postgresql in docker-compose and github workflows (@sebastianliebscher)
- [#24779](https://github.com/apache/superset/pull/24779) build(deps-dev): bump @types/node from 20.4.2 to 20.4.4 in /superset-websocket (@dependabot[bot])
- [#24751](https://github.com/apache/superset/pull/24751) docs: update AWS Athena and Redshift docs (@mdeshmu)
- [#24461](https://github.com/apache/superset/pull/24461) docs(docker-compose): note the risk of running a Docker Postgres volume in production (@sfirke)
- [#24705](https://github.com/apache/superset/pull/24705) chore(deps): bump pandas >=2.0 (@sebastianliebscher)
- [#24732](https://github.com/apache/superset/pull/24732) build(deps-dev): bump word-wrap from 1.2.3 to 1.2.4 in /superset-websocket (@dependabot[bot])
- [#24715](https://github.com/apache/superset/pull/24715) chore: update deprecated arguments in schema (@sebastianliebscher)
- [#24733](https://github.com/apache/superset/pull/24733) build(deps): bump word-wrap from 1.2.3 to 1.2.4 in /superset-frontend/cypress-base (@dependabot[bot])
- [#24735](https://github.com/apache/superset/pull/24735) build(deps-dev): bump word-wrap from 1.2.3 to 1.2.4 in /superset-frontend (@dependabot[bot])
- [#24734](https://github.com/apache/superset/pull/24734) build(deps-dev): bump word-wrap from 1.2.3 to 1.2.4 in /superset-embedded-sdk (@dependabot[bot])
- [#24712](https://github.com/apache/superset/pull/24712) build(deps-dev): bump eslint from 8.44.0 to 8.45.0 in /superset-websocket (@dependabot[bot])
- [#24669](https://github.com/apache/superset/pull/24669) chore: remove obsolete fetchExploreJson function (@john-bodley)
- [#24682](https://github.com/apache/superset/pull/24682) build(deps-dev): bump @types/node from 20.4.1 to 20.4.2 in /superset-websocket (@dependabot[bot])
- [#24674](https://github.com/apache/superset/pull/24674) docs: Fix typo in Rockset docs (@gadhagod)
- [#24672](https://github.com/apache/superset/pull/24672) build(deps-dev): bump @types/node from 20.4.0 to 20.4.1 in /superset-websocket (@dependabot[bot])
- [#24673](https://github.com/apache/superset/pull/24673) build(deps-dev): bump @typescript-eslint/parser from 5.61.0 to 5.62.0 in /superset-websocket (@dependabot[bot])
- [#24649](https://github.com/apache/superset/pull/24649) chore: Update Rockset—switching out rockset for rockset-sqlalchemy (@gadhagod)
- [#24653](https://github.com/apache/superset/pull/24653) build(deps): bump semver from 5.7.1 to 5.7.2 in /superset-frontend (@dependabot[bot])
- [#24654](https://github.com/apache/superset/pull/24654) build(deps): bump semver from 6.3.0 to 6.3.1 in /superset-websocket (@dependabot[bot])
- [#24655](https://github.com/apache/superset/pull/24655) build(deps): bump semver from 6.3.0 to 6.3.1 in /superset-frontend/cypress-base (@dependabot[bot])
- [#24656](https://github.com/apache/superset/pull/24656) build(deps): bump trim and @superset-ui/core in /superset-frontend/cypress-base (@dependabot[bot])
- [#24659](https://github.com/apache/superset/pull/24659) build(deps): bump winston from 3.9.0 to 3.10.0 in /superset-websocket (@dependabot[bot])
- [#24626](https://github.com/apache/superset/pull/24626) chore: Re-enable some GitHub action workflows in draft mode (@john-bodley)
- [#24633](https://github.com/apache/superset/pull/24633) docs(databases): correct the way of using use environment variables (@duyet)
- [#24648](https://github.com/apache/superset/pull/24648) chore: update UI dev libs and fix warnings & vulnerabilities (@EugeneTorap)
- [#24651](https://github.com/apache/superset/pull/24651) build(deps): bump semver from 5.7.1 to 5.7.2 in /docs (@dependabot[bot])
- [#24634](https://github.com/apache/superset/pull/24634) build(deps): bump tough-cookie from 4.0.0 to 4.1.3 in /superset-embedded-sdk (@dependabot[bot])
- [#24614](https://github.com/apache/superset/pull/24614) build(deps): bump jsonwebtoken from 9.0.0 to 9.0.1 in /superset-websocket (@dependabot[bot])
- [#23987](https://github.com/apache/superset/pull/23987) docs(frontend): Fixed typo in command (@ved-kashyap-samsung)
- [#23992](https://github.com/apache/superset/pull/23992) docs: correct databricks pip package name (@devonkinghorn)
- [#24632](https://github.com/apache/superset/pull/24632) build(deps): bump tough-cookie from 4.0.0 to 4.1.3 in /superset-websocket (@dependabot[bot])
- [#24585](https://github.com/apache/superset/pull/24585) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.60.1 to 5.61.0 in /superset-websocket (@dependabot[bot])
- [#24576](https://github.com/apache/superset/pull/24576) build(deps-dev): bump eslint from 8.43.0 to 8.44.0 in /superset-websocket (@dependabot[bot])
- [#24601](https://github.com/apache/superset/pull/24601) build(deps-dev): bump @types/node from 20.3.2 to 20.4.0 in /superset-websocket (@dependabot[bot])
- [#24584](https://github.com/apache/superset/pull/24584) build(deps-dev): bump @typescript-eslint/parser from 5.60.1 to 5.61.0 in /superset-websocket (@dependabot[bot])
- [#24600](https://github.com/apache/superset/pull/24600) build(deps): bump jsonwebtoken from 9.0.0 to 9.0.1 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#24570](https://github.com/apache/superset/pull/24570) docs(helm): reference the correct chart (@muniter)
- [#24564](https://github.com/apache/superset/pull/24564) docs: add notice not to use gevent worker with bigquery datasource (@okayhooni)
- [#24578](https://github.com/apache/superset/pull/24578) refactor: pkg_resources -> importlib.resources (@cwegener)
- [#24523](https://github.com/apache/superset/pull/24523) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.60.0 to 5.60.1 in /superset-websocket (@dependabot[bot])
