/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.sql.SparkSession;

public final class JavaHdfsLR {
    private static final int D = 10;
    private static final Random rand = new Random(42L);

    static void showWarning() {
        String warning = "WARN: This is a naive implementation of Logistic Regression and is given as an example!\nPlease use org.apache.spark.ml.classification.LogisticRegression for more conventional use.";
        System.err.println(warning);
    }

    public static double dot(double[] a, double[] b) {
        double x = 0.0;
        for (int i = 0; i < 10; ++i) {
            x += a[i] * b[i];
        }
        return x;
    }

    public static void printWeights(double[] a) {
        System.out.println(Arrays.toString(a));
    }

    public static void main(String[] args) {
        int i;
        if (args.length < 2) {
            System.err.println("Usage: JavaHdfsLR <file> <iters>");
            System.exit(1);
        }
        JavaHdfsLR.showWarning();
        SparkSession spark = SparkSession.builder().appName("JavaHdfsLR").getOrCreate();
        JavaRDD lines = spark.read().textFile(args[0]).javaRDD();
        JavaRDD points = lines.map((Function)new ParsePoint()).cache();
        int ITERATIONS = Integer.parseInt(args[1]);
        double[] w = new double[10];
        for (i = 0; i < 10; ++i) {
            w[i] = 2.0 * rand.nextDouble() - 1.0;
        }
        System.out.print("Initial w: ");
        JavaHdfsLR.printWeights(w);
        for (i = 1; i <= ITERATIONS; ++i) {
            System.out.println("On iteration " + i);
            double[] gradient = (double[])points.map((Function)new ComputeGradient(w)).reduce((Function2)new VectorSum());
            for (int j = 0; j < 10; ++j) {
                int n = j;
                w[n] = w[n] - gradient[j];
            }
        }
        System.out.print("Final w: ");
        JavaHdfsLR.printWeights(w);
        spark.stop();
    }

    static class ParsePoint
    implements Function<String, DataPoint> {
        private static final Pattern SPACE = Pattern.compile(" ");

        ParsePoint() {
        }

        public DataPoint call(String line) {
            String[] tok = SPACE.split(line);
            double y = Double.parseDouble(tok[0]);
            double[] x = new double[10];
            for (int i = 0; i < 10; ++i) {
                x[i] = Double.parseDouble(tok[i + 1]);
            }
            return new DataPoint(x, y);
        }
    }

    static class ComputeGradient
    implements Function<DataPoint, double[]> {
        private final double[] weights;

        ComputeGradient(double[] weights) {
            this.weights = weights;
        }

        public double[] call(DataPoint p) {
            double[] gradient = new double[10];
            for (int i = 0; i < 10; ++i) {
                double dot = JavaHdfsLR.dot(this.weights, p.x);
                gradient[i] = (1.0 / (1.0 + Math.exp(-p.y * dot)) - 1.0) * p.y * p.x[i];
            }
            return gradient;
        }
    }

    static class VectorSum
    implements Function2<double[], double[], double[]> {
        VectorSum() {
        }

        public double[] call(double[] a, double[] b) {
            double[] result = new double[10];
            for (int j = 0; j < 10; ++j) {
                result[j] = a[j] + b[j];
            }
            return result;
        }
    }

    static class DataPoint
    implements Serializable {
        double[] x;
        double y;

        DataPoint(double[] x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

