/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.UnsafeRowUtils$;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.checkpointing.ChecksumFile;
import org.apache.spark.sql.execution.streaming.runtime.StreamExecution$;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class StateStoreProvider$
implements Logging {
    public static final StateStoreProvider$ MODULE$ = new StateStoreProvider$();
    @GuardedBy(value="this")
    private static StateStoreCoordinatorRef stateStoreCoordinatorRef;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StateStoreCoordinatorRef stateStoreCoordinatorRef() {
        return stateStoreCoordinatorRef;
    }

    private void stateStoreCoordinatorRef_$eq(StateStoreCoordinatorRef x$1) {
        stateStoreCoordinatorRef = x$1;
    }

    public StateStoreProvider create(String providerClassName) {
        Class providerClass = Utils$.MODULE$.classForName(providerClassName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        if (!StateStoreProvider.class.isAssignableFrom(providerClass)) {
            throw new SparkException("STATE_STORE_INVALID_PROVIDER", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputClass"), (Object)providerClassName)})), null);
        }
        return (StateStoreProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public StateStoreProvider createAndInit(StateStoreProviderId providerId, StructType keySchema, StructType valueSchema, KeyStateEncoderSpec keyStateEncoderSpec, boolean useColumnFamilies, StateStoreConf storeConf, Configuration hadoopConf, boolean useMultipleValuesPerKey, Option<StateSchemaProvider> stateSchemaProvider) {
        hadoopConf.set(StreamExecution$.MODULE$.RUN_ID_KEY(), providerId.queryRunId().toString());
        StateStoreProvider provider = this.create(storeConf.providerClass());
        provider.init(providerId.storeId(), keySchema, valueSchema, keyStateEncoderSpec, useColumnFamilies, storeConf, hadoopConf, useMultipleValuesPerKey, stateSchemaProvider);
        return provider;
    }

    public void validateStateRowFormat(UnsafeRow keyRow, StructType keySchema, UnsafeRow valueRow, StructType valueSchema, StateStoreId stateStoreId, StateStoreConf conf) {
        if (conf.formatValidationEnabled()) {
            Option validationError = UnsafeRowUtils$.MODULE$.validateStructuralIntegrityWithReason(keyRow, keySchema);
            validationError.foreach((Function1 & Serializable)error -> {
                throw StateStoreErrors$.MODULE$.keyRowFormatValidationFailure((String)error, stateStoreId.toString());
            });
            if (conf.formatValidationCheckValue()) {
                Option validationError2 = UnsafeRowUtils$.MODULE$.validateStructuralIntegrityWithReason(valueRow, valueSchema);
                validationError2.foreach((Function1 & Serializable)error -> {
                    throw StateStoreErrors$.MODULE$.valueRowFormatValidationFailure((String)error, stateStoreId.toString());
                });
                return;
            }
            return;
        }
    }

    public void deleteOrphanChecksumFiles(CheckpointFileManager fm, Seq<ChecksumFile> checksumFiles, Seq<Path> deletedStoreFiles, long minVersionToRetain, boolean fileChecksumEnabled) {
        ListBuffer failedFiles;
        Set deletedStoreFilesSet = ((IterableOnceOps)deletedStoreFiles.map((Function1 & Serializable)x$11 -> x$11.getName())).toSet();
        Seq oldChecksumFiles = (Seq)checksumFiles.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)StateStoreProvider$.$anonfun$deleteOrphanChecksumFiles$2(minVersionToRetain, f)));
        Seq orphanChecksumFiles = fileChecksumEnabled ? (Seq)oldChecksumFiles.filterNot((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)deletedStoreFilesSet.contains((Object)f.mainFilePath().getName()))) : oldChecksumFiles;
        Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0)((JFunction0.mcV.sp & Serializable)() -> StateStoreProvider$.$anonfun$deleteOrphanChecksumFiles$4(orphanChecksumFiles, fm, failedFiles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long dur = tuple2._2$mcJ$sp();
        long dur2 = dur;
        if (orphanChecksumFiles.nonEmpty()) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted orphan checksum files older than version "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FILE_VERSION, BoxesRunTime.boxToLong((long)minVersionToRetain))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(timeTakenMs = ", ") - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.DURATION, BoxesRunTime.boxToLong((long)dur2))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Orphan files: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FILE_NAME, orphanChecksumFiles.mkString(", "))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to Delete: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FILE_NAME, failedFiles.mkString(", "))})))));
            return;
        }
    }

    public String getRunId(Configuration hadoopConf) {
        String runId = hadoopConf.get(StreamExecution$.MODULE$.RUN_ID_KEY());
        Predef$.MODULE$.assert(runId != null);
        return runId;
    }

    public synchronized Option<StateStoreCoordinatorRef> coordinatorRef() {
        SparkEnv env = SparkEnv$.MODULE$.get();
        if (env != null) {
            boolean isDriver;
            String string = env.executorId();
            String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (isDriver = false);
            if (isDriver || this.stateStoreCoordinatorRef() == null) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Getting StateStoreCoordinatorRef");
                this.stateStoreCoordinatorRef_$eq(StateStoreCoordinatorRef$.MODULE$.forExecutor(env));
            }
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Retrieved reference to StateStoreCoordinator: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STATE_STORE_COORDINATOR, MODULE$.stateStoreCoordinatorRef())})))));
            return new Some((Object)this.stateStoreCoordinatorRef());
        }
        this.stateStoreCoordinatorRef_$eq(null);
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$deleteOrphanChecksumFiles$2(long minVersionToRetain$1, ChecksumFile f) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(f.baseName().split("_")[0])) < minVersionToRetain$1;
    }

    public static final /* synthetic */ void $anonfun$deleteOrphanChecksumFiles$5(CheckpointFileManager fm$1, ListBuffer failedFiles$1, ChecksumFile f) {
        try {
            fm$1.delete(f.path());
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                failedFiles$1.$plus$eq((Object)f.path());
                MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete orphan checksum file "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FILE_NAME, f.path())})))), throwable2);
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$deleteOrphanChecksumFiles$4(Seq orphanChecksumFiles$1, CheckpointFileManager fm$1, ListBuffer failedFiles$1) {
        orphanChecksumFiles$1.foreach((Function1 & Serializable)f -> {
            StateStoreProvider$.$anonfun$deleteOrphanChecksumFiles$5(fm$1, failedFiles$1, f);
            return BoxedUnit.UNIT;
        });
    }

    private StateStoreProvider$() {
    }
}

