/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Subquery;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.Metadata;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class RemoveRedundantAliases$
extends Rule<LogicalPlan> {
    public static final RemoveRedundantAliases$ MODULE$ = new RemoveRedundantAliases$();

    private Seq<Tuple2<Attribute, Attribute>> createAttributeMapping(LogicalPlan current, LogicalPlan next) {
        return (Seq)((IterableOps)current.output().zip(next.output())).filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RemoveRedundantAliases$.$anonfun$createAttributeMapping$1(x0$1)));
    }

    private Expression removeRedundantAlias(Expression e, AttributeSet excludeList) {
        Expression expression = e;
        if (expression instanceof Alias) {
            Attribute attribute;
            Alias alias = (Alias)expression;
            Expression attr = alias.child();
            String name = alias.name();
            if (attr instanceof Attribute && !excludeList.contains(attribute = (Attribute)attr) && !excludeList.contains(alias)) {
                String string = name;
                String string2 = attribute.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Metadata metadata = alias.metadata();
                    Metadata attrMetadata = attribute.metadata();
                    Metadata metadata2 = metadata;
                    Metadata metadata3 = attrMetadata;
                    if (!(metadata2 != null ? !metadata2.equals(metadata3) : metadata3 != null)) {
                        return attribute;
                    }
                    if (attribute.metadata().contains(package$.MODULE$.AUTO_GENERATED_ALIAS())) {
                        attrMetadata = attribute.metadata().withKeyRemoved(package$.MODULE$.AUTO_GENERATED_ALIAS());
                        Metadata metadata4 = metadata;
                        Metadata metadata5 = attrMetadata;
                        if (!(metadata4 != null ? !metadata4.equals(metadata5) : metadata5 != null)) {
                            return attribute.withMetadata(metadata);
                        }
                        return alias;
                    }
                    return alias;
                }
            }
        }
        return expression;
    }

    private LogicalPlan removeRedundantAliases(LogicalPlan plan2, AttributeSet excluded) {
        if (!plan2.containsPattern(TreePattern$.MODULE$.ALIAS())) {
            return plan2;
        }
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Subquery) {
            Subquery subquery = (Subquery)logicalPlan;
            LogicalPlan child2 = subquery.child();
            boolean correlated = subquery.correlated();
            return new Subquery(this.removeRedundantAliases(child2, excluded.$plus$plus(child2.outputSet())), correlated);
        }
        if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            LogicalPlan left = join.left();
            LogicalPlan right = join.right();
            JoinType joinType = join.joinType();
            Option<Expression> condition = join.condition();
            JoinHint hint = join.hint();
            LogicalPlan newLeft = this.removeRedundantAliases(left, excluded.$plus$plus(right.outputSet()));
            LogicalPlan newRight = this.removeRedundantAliases(right, excluded.$plus$plus(newLeft.outputSet()));
            AttributeMap mapping = AttributeMap$.MODULE$.apply((Seq)this.createAttributeMapping(left, newLeft).$plus$plus(this.createAttributeMapping(right, newRight)));
            Option newCondition = condition.map((Function1 & Serializable)x$14 -> (Expression)x$14.transform(new Serializable(mapping){
                private static final long serialVersionUID = 0L;
                private final AttributeMap mapping$1;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Attribute) {
                        Attribute attribute = (Attribute)A1;
                        return this.mapping$1.getOrElse(attribute, (Function0 & Serializable)() -> attribute);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    return expression instanceof Attribute;
                }
                {
                    this.mapping$1 = mapping$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$12(org.apache.spark.sql.catalyst.expressions.Attribute )}, serializedLambda);
                }
            }));
            return new Join(newLeft, newRight, joinType, (Option<Expression>)newCondition, hint);
        }
        if (logicalPlan instanceof Union) {
            Union union = (Union)logicalPlan;
            BooleanRef first = BooleanRef.create((boolean)true);
            return (LogicalPlan)plan2.mapChildren((Function1 & Serializable)child -> {
                if (!MODULE$.conf().unionIsResolvedWhenDuplicatesPerChildResolved() || MODULE$.shouldRemoveAliasesUnderUnion((LogicalPlan)child)) {
                    if (first$1.elem) {
                        first$1.elem = false;
                        return MODULE$.removeRedundantAliases((LogicalPlan)child, excluded.$plus$plus(child.outputSet()));
                    }
                    return MODULE$.removeRedundantAliases((LogicalPlan)child, excluded.$minus$minus(((QueryPlan)union.children().head()).outputSet()));
                }
                return child;
            });
        }
        AttributeSet subQueryAttributes = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.EXCLUDE_SUBQUERY_EXP_REFS_FROM_REMOVE_REDUNDANT_ALIASES())) ? AttributeSet$.MODULE$.fromAttributeSets((Iterable<AttributeSet>)((Iterable)plan2.expressions().flatMap((Function1 & Serializable)e -> e.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    return (B1)subqueryExpression.references();
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                return expression instanceof SubqueryExpression;
            }
        })))) : AttributeSet$.MODULE$.empty();
        Buffer currentNextAttrPairs = (Buffer)Buffer$.MODULE$.empty();
        LogicalPlan newNode = (LogicalPlan)plan2.mapChildren((Function1 & Serializable)child -> {
            LogicalPlan newChild = MODULE$.removeRedundantAliases((LogicalPlan)child, excluded.$plus$plus(subQueryAttributes));
            currentNextAttrPairs.$plus$plus$eq(MODULE$.createAttributeMapping((LogicalPlan)child, newChild));
            return newChild;
        });
        AttributeMap mapping = AttributeMap$.MODULE$.apply(currentNextAttrPairs);
        LogicalPlan logicalPlan2 = plan2;
        Function1 & Serializable clean = logicalPlan2 instanceof Project ? (Function1 & Serializable)x$15 -> MODULE$.removeRedundantAlias((Expression)x$15, excluded) : (logicalPlan2 instanceof Aggregate ? (Function1 & Serializable)x$16 -> MODULE$.removeRedundantAlias((Expression)x$16, excluded) : (logicalPlan2 instanceof Window ? (Function1 & Serializable)x$17 -> MODULE$.removeRedundantAlias((Expression)x$17, excluded) : (Function1 & Serializable)x -> (Expression)Predef$.MODULE$.identity(x)));
        return (LogicalPlan)newNode.mapExpressions((Function1<Expression, Expression>)(Function1 & Serializable)expr -> (Expression)clean.apply(expr.transform(new Serializable(mapping){
            private static final long serialVersionUID = 0L;
            private final AttributeMap mapping$2;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 instanceof Attribute) {
                    Attribute attribute = (Attribute)A1;
                    return (B1)this.mapping$2.get(attribute).map((Function1 & Serializable)x$18 -> x$18.withName(attribute.name())).getOrElse((Function0 & Serializable)() -> attribute);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Expression x3) {
                Expression expression = x3;
                return expression instanceof Attribute;
            }
            {
                this.mapping$2 = mapping$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$13(org.apache.spark.sql.catalyst.expressions.Attribute org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$14(org.apache.spark.sql.catalyst.expressions.Attribute )}, serializedLambda);
            }
        })));
    }

    private boolean shouldRemoveAliasesUnderUnion(LogicalPlan operator) {
        LogicalPlan logicalPlan = operator;
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            return project.projectList().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RemoveRedundantAliases$.$anonfun$shouldRemoveAliasesUnderUnion$1(project, x0$1)));
        }
        if (logicalPlan instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)logicalPlan;
            return aggregate.aggregateExpressions().forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)RemoveRedundantAliases$.$anonfun$shouldRemoveAliasesUnderUnion$2(aggregate, x0$2)));
        }
        if (logicalPlan instanceof Window) {
            Window window = (Window)logicalPlan;
            return window.windowExpressions().forall((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)RemoveRedundantAliases$.$anonfun$shouldRemoveAliasesUnderUnion$3(window, x0$3)));
        }
        return true;
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return this.removeRedundantAliases(plan2, AttributeSet$.MODULE$.empty());
    }

    public static final /* synthetic */ boolean $anonfun$createAttributeMapping$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Attribute a1 = (Attribute)tuple2._1();
            Attribute a2 = (Attribute)tuple2._2();
            return a1.semanticEquals(a2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$shouldRemoveAliasesUnderUnion$1(Project x2$6, NamedExpression x0$1) {
        Alias alias;
        Expression attribute;
        NamedExpression namedExpression = x0$1;
        if (namedExpression instanceof Alias && (attribute = (alias = (Alias)namedExpression).child()) instanceof Attribute) {
            Attribute attribute2 = (Attribute)attribute;
            return !x2$6.outputSet().contains(attribute2);
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$shouldRemoveAliasesUnderUnion$2(Aggregate x3$2, NamedExpression x0$2) {
        Alias alias;
        Expression attribute;
        NamedExpression namedExpression = x0$2;
        if (namedExpression instanceof Alias && (attribute = (alias = (Alias)namedExpression).child()) instanceof Attribute) {
            Attribute attribute2 = (Attribute)attribute;
            return !x3$2.outputSet().contains(attribute2);
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$shouldRemoveAliasesUnderUnion$3(Window x4$2, NamedExpression x0$3) {
        Alias alias;
        Expression attribute;
        NamedExpression namedExpression = x0$3;
        if (namedExpression instanceof Alias && (attribute = (alias = (Alias)namedExpression).child()) instanceof Attribute) {
            Attribute attribute2 = (Attribute)attribute;
            return !x4$2.outputSet().contains(attribute2);
        }
        return true;
    }

    private RemoveRedundantAliases$() {
    }
}

