/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Date;
import java.util.NoSuchElementException;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.ui.BatchUIData;
import org.apache.spark.streaming.ui.OutputOperationUIData;
import org.apache.spark.streaming.ui.SparkJobIdWithUIData;
import org.apache.spark.streaming.ui.StreamingJobProgressListener;
import org.apache.spark.streaming.ui.StreamingTab;
import org.apache.spark.streaming.ui.UIUtils$;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.WebUIPage;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractSeq;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005-h!B\f\u0019\u0001a\u0011\u0003\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u000b9\u0002A\u0011A\u0018\t\u000fI\u0002!\u0019!C\u0005g!1q\u0007\u0001Q\u0001\nQBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004A\u0001\u0001\u0006IA\u000f\u0005\u0006\u0003\u0002!IA\u0011\u0005\u0006/\u0002!I\u0001\u0017\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBAJ\u0001\u0011%\u0011Q\u0013\u0005\b\u0003G\u0003A\u0011BAS\u0011\u001d\tY\u000b\u0001C\u0005\u0003[Cq!a/\u0001\t\u0003\ti\fC\u0004\u0002B\u0002!\t!a1\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\"9\u0011\u0011\u001c\u0001\u0005\n\u0005m\u0007bBAq\u0001\u0011%\u00111\u001d\u0002\n\u0005\u0006$8\r\u001b)bO\u0016T!!\u0007\u000e\u0002\u0005UL'BA\u000e\u001d\u0003%\u0019HO]3b[&twM\u0003\u0002\u001e=\u0005)1\u000f]1sW*\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h'\t\u00011\u0005\u0005\u0002%M5\tQE\u0003\u0002\u001a9%\u0011q%\n\u0002\n/\u0016\u0014W+\u0013)bO\u0016\fa\u0001]1sK:$8\u0001\u0001\t\u0003W1j\u0011\u0001G\u0005\u0003[a\u0011Ab\u0015;sK\u0006l\u0017N\\4UC\n\fa\u0001P5oSRtDC\u0001\u00192!\tY\u0003\u0001C\u0003)\u0005\u0001\u0007!&A\ttiJ,\u0017-\\5oO2K7\u000f^3oKJ,\u0012\u0001\u000e\t\u0003WUJ!A\u000e\r\u00039M#(/Z1nS:<'j\u001c2Qe><'/Z:t\u0019&\u001cH/\u001a8fe\u0006\u00112\u000f\u001e:fC6Lgn\u001a'jgR,g.\u001a:!\u0003\u0015\u0019Ho\u001c:f+\u0005Q\u0004CA\u001e?\u001b\u0005a$BA\u001f\u001d\u0003\u0019\u0019H/\u0019;vg&\u0011q\b\u0010\u0002\u000f\u0003B\u00048\u000b^1ukN\u001cFo\u001c:f\u0003\u0019\u0019Ho\u001c:fA\u000591m\u001c7v[:\u001cX#A\"\u0011\u0007\u0011s\u0015K\u0004\u0002F\u0017:\u0011a)S\u0007\u0002\u000f*\u0011\u0001*K\u0001\u0007yI|w\u000e\u001e \n\u0003)\u000bQa]2bY\u0006L!\u0001T'\u0002\u000fA\f7m[1hK*\t!*\u0003\u0002P!\n\u00191+Z9\u000b\u00051k\u0005C\u0001*V\u001b\u0005\u0019&B\u0001+N\u0003\rAX\u000e\\\u0005\u0003-N\u0013AAT8eK\u0006qq-\u001a8fe\u0006$XMS8c%><H#C\"ZK*dg\u000f`A\u0002\u0011\u0015Q\u0006\u00021\u0001\\\u0003\u001d\u0011X-];fgR\u0004\"\u0001X2\u000e\u0003uS!AX0\u0002\t!$H\u000f\u001d\u0006\u0003A\u0006\fqa]3sm2,GOC\u0001c\u0003\u001dQ\u0017m[1si\u0006L!\u0001Z/\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f\u001e\u0005\u0006M\"\u0001\raZ\u0001\r_V$\b/\u001e;Pa\u0012\u000bG/\u0019\t\u0003W!L!!\u001b\r\u0003+=+H\u000f];u\u001fB,'/\u0019;j_:,\u0016\nR1uC\")1\u000e\u0003a\u0001\u0007\u0006\u0019r.\u001e;qkR|\u0005\u000fR3tGJL\u0007\u000f^5p]\")Q\u000e\u0003a\u0001]\u0006Ibm\u001c:nCR$X\rZ(viB,Ho\u00149EkJ\fG/[8o!\ty7O\u0004\u0002qcB\u0011a)T\u0005\u0003e6\u000ba\u0001\u0015:fI\u00164\u0017B\u0001;v\u0005\u0019\u0019FO]5oO*\u0011!/\u0014\u0005\u0006o\"\u0001\r\u0001_\u0001\u001a]Vl7\u000b]1sW*{'MU8xg&sw*\u001e;qkR|\u0005\u000f\u0005\u0002zu6\tQ*\u0003\u0002|\u001b\n\u0019\u0011J\u001c;\t\u000buD\u0001\u0019\u0001@\u0002\u0015%\u001ch)\u001b:tiJ{w\u000f\u0005\u0002z\u007f&\u0019\u0011\u0011A'\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0001\u0005A\u0002\u0005\u001d\u0011!\u00046pE&#w+\u001b;i\t\u0006$\u0018\rE\u0002,\u0003\u0013I1!a\u0003\u0019\u0005Q\u0019\u0006/\u0019:l\u0015>\u0014\u0017\nZ,ji\",\u0016\nR1uC\u0006\u0019s-\u001a8fe\u0006$XmT;uaV$x\n\u001d*po^KG\u000f[8viN\u0003\u0018M]6K_\n\u001cHcB\"\u0002\u0012\u0005M\u0011Q\u0003\u0005\u0006M&\u0001\ra\u001a\u0005\u0006W&\u0001\ra\u0011\u0005\u0006[&\u0001\rA\\\u0001\u0015O\u0016tWM]1uK:{'/\\1m\u0015>\u0014'k\\<\u0015\u001f\r\u000bY\"!\b\u0002 \u0005\u0005\u00121EA\u0013\u0003OAQA\u0017\u0006A\u0002mCQA\u001a\u0006A\u0002\u001dDQa\u001b\u0006A\u0002\rCQ!\u001c\u0006A\u00029DQa\u001e\u0006A\u0002aDQ! \u0006A\u0002yDq!!\u000b\u000b\u0001\u0004\tY#\u0001\u0005ta\u0006\u00148NS8c!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\t!A^\u0019\u000b\u0007\u0005UB(A\u0002ba&LA!!\u000f\u00020\t9!j\u001c2ECR\f\u0017!F4f]\u0016\u0014\u0018\r^3Ee>\u0004\b/\u001a3K_\n\u0014vn\u001e\u000b\u000e\u0007\u0006}\u0012\u0011IA\"\u0003\u000b\n9%!\u0013\t\u000b\u0019\\\u0001\u0019A4\t\u000b-\\\u0001\u0019A\"\t\u000b5\\\u0001\u0019\u00018\t\u000b]\\\u0001\u0019\u0001=\t\u000bu\\\u0001\u0019\u0001@\t\r\u0005-3\u00021\u0001y\u0003\u0015QwNY%e\u0003U9WM\\3sCR,w*\u001e;qkR|\u0005/\u00133S_^$raQA)\u0003'\n)\u0006C\u0003[\u0019\u0001\u00071\fC\u0003g\u0019\u0001\u0007q\rC\u0004\u0002X1\u0001\r!!\u0017\u0002\u0013M\u0004\u0018M]6K_\n\u001c\b\u0003\u0002#O\u0003\u000f\t1dZ3oKJ\fG/Z(viB,Ho\u00149EKN\u001c'/\u001b9uS>tGcA\"\u0002`!1\u0011\u0011M\u0007A\u0002\u001d\f\u0001b\\;uaV$x\n]\u0001\u000bO\u0016$(j\u001c2ECR\fG\u0003BA4\u0003[\u0002R!_A5\u0003WI1!a\u001bN\u0005\u0019y\u0005\u000f^5p]\"9\u0011q\u000e\bA\u0002\u0005E\u0014AC:qCJ\\'j\u001c2JIB!\u00111OAG\u001d\u0011\t)(!#\u000f\t\u0005]\u0014q\u0011\b\u0005\u0003s\n)I\u0004\u0003\u0002|\u0005\re\u0002BA?\u0003\u0003s1ARA@\u0013\u0005\t\u0013BA\u0010!\u0013\tib$\u0003\u0002\u001c9%\u0011\u0011DG\u0005\u0004\u0003\u0017C\u0012\u0001H*ue\u0016\fW.\u001b8h\u0015>\u0014\u0007K]8he\u0016\u001c8\u000fT5ti\u0016tWM]\u0005\u0005\u0003\u001f\u000b\tJ\u0001\u0006Ta\u0006\u00148NS8c\u0013\u0012T1!a#\u0019\u000319W\r^*uC\u001e,G)\u0019;b)\u0011\t9*a(\u0011\u000be\fI'!'\u0011\t\u00055\u00121T\u0005\u0005\u0003;\u000byCA\u0005Ti\u0006<W\rR1uC\"1\u0011\u0011U\bA\u0002a\fqa\u001d;bO\u0016LE-\u0001\u0012hK:,'/\u0019;f\u001fV$\b/\u001e;Pa\u0016\u0014\u0018\r^5p]N#\u0018\r^;t\r>\u0014X+\u0013\u000b\u0004]\u0006\u001d\u0006BBAU!\u0001\u0007a.A\u0004gC&dWO]3\u0002!\u001d,g.\u001a:bi\u0016TuN\u0019+bE2,G#B\"\u00020\u0006E\u0006\"\u0002.\u0012\u0001\u0004Y\u0006bBAZ#\u0001\u0007\u0011QW\u0001\fE\u0006$8\r[+J\t\u0006$\u0018\rE\u0002,\u0003oK1!!/\u0019\u0005-\u0011\u0015\r^2i+&#\u0015\r^1\u0002\rI,g\u000eZ3s)\r\u0019\u0015q\u0018\u0005\u00065J\u0001\raW\u0001\u001bO\u0016tWM]1uK&s\u0007/\u001e;NKR\fG-\u0019;b)\u0006\u0014G.\u001a\u000b\u0004\u0007\u0006\u0015\u0007bBAd'\u0001\u0007\u0011\u0011Z\u0001\u000fS:\u0004X\u000f^'fi\u0006$\u0017\r^1t!\u0011!e*a3\u0011\u000be\fi\r\u001f8\n\u0007\u0005=WJ\u0001\u0004UkBdWMM\u0001\u0019O\u0016tWM]1uK&s\u0007/\u001e;NKR\fG-\u0019;b%><HcA\"\u0002V\"9\u0011q\u001b\u000bA\u0002\u0005-\u0017!D5oaV$X*\u001a;bI\u0006$\u0018-A\rnKR\fG-\u0019;b\t\u0016\u001c8M]5qi&|g\u000eV8I)6cEcA\"\u0002^\"1\u0011q\\\u000bA\u00029\f1#\\3uC\u0012\fG/\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:\f!c\\;uaV$x\n]*uCR,8oQ3mYR)1)!:\u0002h\"1\u0011\u0011\r\fA\u0002\u001dDa!!;\u0017\u0001\u0004A\u0018a\u0002:poN\u0004\u0018M\u001c")
public class BatchPage
extends WebUIPage {
    private final StreamingTab parent;
    private final StreamingJobProgressListener streamingListener;
    private final AppStatusStore store;

    private StreamingJobProgressListener streamingListener() {
        return this.streamingListener;
    }

    private AppStatusStore store() {
        return this.store;
    }

    private scala.collection.immutable.Seq<Node> columns() {
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Output Op Id"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Description"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Output Op Duration "));
        $buf4.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken for all the jobs of this batch to finish processing from the time they were submitted.", "top"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Status"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Job Id"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Job Duration "));
        $buf7.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken from submission time to completion time of the job", "top"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("sorttable_nosort"), (MetaData)$md);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Stages: Succeeded/Total"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("sorttable_nosort"), (MetaData)$md2);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Tasks (for all stages): Succeeded/Total"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Error"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf10.toVector()));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    private scala.collection.immutable.Seq<Node> generateJobRow(HttpServletRequest request, OutputOperationUIData outputOpData, scala.collection.immutable.Seq<Node> outputOpDescription, String formattedOutputOpDuration, int numSparkJobRowsInOutputOp, boolean isFirstRow, SparkJobIdWithUIData jobIdWithData) {
        if (jobIdWithData.jobData().isDefined()) {
            return this.generateNormalJobRow(request, outputOpData, outputOpDescription, formattedOutputOpDuration, numSparkJobRowsInOutputOp, isFirstRow, (JobData)jobIdWithData.jobData().get());
        }
        return this.generateDroppedJobRow(outputOpData, outputOpDescription, formattedOutputOpDuration, numSparkJobRowsInOutputOp, isFirstRow, jobIdWithData.sparkJobId());
    }

    private scala.collection.immutable.Seq<Node> generateOutputOpRowWithoutSparkJobs(OutputOperationUIData outputOpData, scala.collection.immutable.Seq<Node> outputOpDescription, String formattedOutputOpDuration) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("output-op-id-cell"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)Integer.toString(outputOpData.id()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(outputOpDescription);
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)formattedOutputOpDuration);
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(this.outputOpStatusCell(outputOpData, 1));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Job Id "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Duration "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Stages: Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Tasks (for all stages): Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Error "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    private scala.collection.immutable.Seq<Node> generateNormalJobRow(HttpServletRequest request, OutputOperationUIData outputOpData, scala.collection.immutable.Seq<Node> outputOpDescription, String formattedOutputOpDuration, int numSparkJobRowsInOutputOp, boolean isFirstRow, JobData sparkJob) {
        Nil$ nil$;
        Option duration = sparkJob.submissionTime().map((Function1 & Serializable)start -> BoxesRunTime.boxToLong((long)BatchPage.$anonfun$generateNormalJobRow$1(sparkJob, start)));
        String lastFailureReason = (String)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)sparkJob.stageIds().sorted(Ordering.Int$.MODULE$.reverse())).flatMap((Function1 & Serializable)stageId -> this.getStageData(BoxesRunTime.unboxToInt((Object)stageId)))).dropWhile((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BatchPage.$anonfun$generateNormalJobRow$5(x$2)))).take(1)).flatMap((Function1 & Serializable)info -> info.failureReason())).headOption().getOrElse((Function0 & Serializable)() -> "");
        String formattedDuration = (String)duration.map((Function1 & Serializable)d -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)d))).getOrElse((Function0 & Serializable)() -> "-");
        String detailUrl = org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()) + "/jobs/job/?id=" + sparkJob.jobId();
        if (isFirstRow) {
            NodeBuffer $buf = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md);
            $md = new UnprefixedAttribute("class", (Seq)new Text("output-op-id-cell"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)Integer.toString(outputOpData.id()));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md2);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf3.$amp$plus(outputOpDescription);
            $buf3.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md3);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)formattedOutputOpDuration);
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
            nil$ = (AbstractSeq)$buf.$plus$plus(this.outputOpStatusCell(outputOpData, numSparkJobRowsInOutputOp));
        } else {
            nil$ = Nil$.MODULE$;
        }
        Nil$ prefixCells = nil$;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)prefixCells);
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("sorttable_customkey", Integer.toString(sparkJob.jobId()), (MetaData)$md);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("href", detailUrl, (MetaData)$md4);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)BoxesRunTime.boxToInteger((int)sparkJob.jobId()));
        $buf6.$amp$plus(sparkJob.jobGroup().map((Function1 & Serializable)id -> "(" + id + ")").getOrElse((Function0 & Serializable)() -> ""));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("sorttable_customkey", duration.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> Long.MAX_VALUE).toString(), (MetaData)$md5);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)formattedDuration);
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", (Seq)new Text("stage-progress-cell"), (MetaData)$md6);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)sparkJob.numCompletedStages()));
        $buf8.$amp$plus((Object)new Text("/"));
        $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)(sparkJob.stageIds().size() - sparkJob.numSkippedStages())));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)(sparkJob.numFailedStages() > 0 ? "(" + sparkJob.numFailedStages() + " failed)" : BoxedUnit.UNIT));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)(sparkJob.numSkippedStages() > 0 ? "(" + sparkJob.numSkippedStages() + " skipped)" : BoxedUnit.UNIT));
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("progress-cell"), (MetaData)$md7);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n        "));
        $buf9.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.makeProgressBar(sparkJob.numActiveTasks(), sparkJob.numCompletedTasks(), sparkJob.numFailedTasks(), sparkJob.numSkippedTasks(), sparkJob.killedTasksSummary(), sparkJob.numTasks() - sparkJob.numSkippedTasks()));
        $buf9.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(UIUtils$.MODULE$.failureReasonCell(lastFailureReason, UIUtils$.MODULE$.failureReasonCell$default$2(), UIUtils$.MODULE$.failureReasonCell$default$3()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    private scala.collection.immutable.Seq<Node> generateDroppedJobRow(OutputOperationUIData outputOpData, scala.collection.immutable.Seq<Node> outputOpDescription, String formattedOutputOpDuration, int numSparkJobRowsInOutputOp, boolean isFirstRow, int jobId) {
        Nil$ nil$;
        if (isFirstRow) {
            NodeBuffer $buf = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md);
            $md = new UnprefixedAttribute("class", (Seq)new Text("output-op-id-cell"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)Integer.toString(outputOpData.id()));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md2);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus(outputOpDescription);
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md3);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)formattedOutputOpDuration);
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
            nil$ = (AbstractSeq)$buf.$plus$plus(this.outputOpStatusCell(outputOpData, numSparkJobRowsInOutputOp));
        } else {
            nil$ = Nil$.MODULE$;
        }
        Nil$ prefixCells = nil$;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)prefixCells);
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("sorttable_customkey", Integer.toString(jobId), (MetaData)$md);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)(jobId >= 0 ? Integer.toString(jobId) : "-"));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Duration "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Stages: Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Tasks (for all stages): Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Error "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    private scala.collection.immutable.Seq<Node> generateOutputOpIdRow(HttpServletRequest request, OutputOperationUIData outputOpData, scala.collection.immutable.Seq<SparkJobIdWithUIData> sparkJobs) {
        String formattedOutputOpDuration = outputOpData.duration().isEmpty() ? "-" : org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)outputOpData.duration().get()));
        scala.collection.immutable.Seq<Node> description = this.generateOutputOpDescription(outputOpData);
        if (sparkJobs.isEmpty()) {
            return this.generateOutputOpRowWithoutSparkJobs(outputOpData, description, formattedOutputOpDuration);
        }
        scala.collection.immutable.Seq<Node> firstRow = this.generateJobRow(request, outputOpData, description, formattedOutputOpDuration, sparkJobs.size(), true, (SparkJobIdWithUIData)sparkJobs.head());
        scala.collection.immutable.Seq tailRows = (scala.collection.immutable.Seq)((IterableOps)sparkJobs.tail()).map((Function1 & Serializable)sparkJob -> this.generateJobRow(request, outputOpData, description, formattedOutputOpDuration, sparkJobs.size(), false, (SparkJobIdWithUIData)sparkJob));
        return (scala.collection.immutable.Seq)((IterableOps)firstRow.$plus$plus((IterableOnce)tailRows)).flatten(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Seq<Node> generateOutputOpDescription(OutputOperationUIData outputOp) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)outputOp.name());
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-details"), (MetaData)$md);
        $md = new UnprefixedAttribute("onclick", (Seq)new Text("this.parentNode.querySelector('.stage-details').classList.toggle('collapsed')"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          +details\n      "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("stage-details collapsed"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)outputOp.description());
        $buf3.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    private Option<JobData> getJobData(int sparkJobId) {
        Some some;
        try {
            some = new Some((Object)this.store().job(sparkJobId));
        }
        catch (NoSuchElementException noSuchElementException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private Option<StageData> getStageData(int stageId) {
        Some some;
        try {
            some = new Some((Object)this.store().lastStageAttempt(stageId));
        }
        catch (NoSuchElementException noSuchElementException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private String generateOutputOperationStatusForUI(String failure) {
        if (failure.startsWith("org.apache.spark.SparkException")) {
            return "Failed due to Spark job error\n" + failure;
        }
        int nextLineIndex = failure.indexOf("\n");
        if (nextLineIndex < 0) {
            nextLineIndex = failure.length();
        }
        String firstLine = failure.substring(0, nextLineIndex);
        return "Failed due to error: " + firstLine + "\n" + failure;
    }

    private scala.collection.immutable.Seq<Node> generateJobTable(HttpServletRequest request, BatchUIData batchUIData) {
        Map outputOpIdToSparkJobIds = (Map)batchUIData.outputOpIdSparkJobIdPairs().groupBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.outputOpId())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int outputOpId = tuple2._1$mcI$sp();
                Iterable outputOpIdAndSparkJobIds = (Iterable)tuple2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)outputOpId), ((IterableOnceOps)outputOpIdAndSparkJobIds.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.sparkJobId()))).toSeq().sorted((Ordering)Ordering.Int$.MODULE$));
            }
            throw new MatchError((Object)tuple2);
        });
        scala.collection.immutable.Seq outputOps = (scala.collection.immutable.Seq)batchUIData.outputOperations().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int outputOpId = tuple2._1$mcI$sp();
                OutputOperationUIData outputOperation = (OutputOperationUIData)tuple2._2();
                scala.collection.immutable.Seq sparkJobIds = (scala.collection.immutable.Seq)outputOpIdToSparkJobIds.getOrElse((Object)BoxesRunTime.boxToInteger((int)outputOpId), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
                return new Tuple2((Object)outputOperation, (Object)sparkJobIds);
            }
            throw new MatchError((Object)tuple2);
        }).toSeq().sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)BatchPage.$anonfun$generateJobTable$6(x$5)), (Ordering)Ordering.Int$.MODULE$);
        scala.collection.immutable.Seq outputOpWithJobs = (scala.collection.immutable.Seq)outputOps.map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                OutputOperationUIData outputOpData = (OutputOperationUIData)tuple2._1();
                scala.collection.immutable.Seq sparkJobIds = (scala.collection.immutable.Seq)tuple2._2();
                return new Tuple2((Object)outputOpData, sparkJobIds.map((Function1 & Serializable)jobId -> BatchPage.$anonfun$generateJobTable$8(this, BoxesRunTime.unboxToInt((Object)jobId))));
            }
            throw new MatchError((Object)tuple2);
        });
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("table table-bordered table-striped table-sm"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("batch-job-table"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(this.columns());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus(outputOpWithJobs.map((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                OutputOperationUIData outputOpData = (OutputOperationUIData)tuple2._1();
                scala.collection.immutable.Seq sparkJobs = (scala.collection.immutable.Seq)tuple2._2();
                return this.generateOutputOpIdRow(request, outputOpData, (scala.collection.immutable.Seq<SparkJobIdWithUIData>)sparkJobs);
            }
            throw new MatchError((Object)tuple2);
        }));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        scala.collection.immutable.Seq seq;
        StreamingJobProgressListener streamingJobProgressListener = this.streamingListener();
        synchronized (streamingJobProgressListener) {
            BoxedUnit boxedUnit;
            Time batchTime = (Time)Option$.MODULE$.apply((Object)request.getParameter("id")).map((Function1 & Serializable)id -> new Time(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id)))).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Missing id parameter");
            });
            String formattedBatchTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(batchTime.milliseconds(), this.streamingListener().batchDuration(), org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$3(), org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
            BatchUIData batchUIData = (BatchUIData)this.streamingListener().getBatchUIData(batchTime).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Batch " + formattedBatchTime + " does not exist");
            });
            String formattedSchedulingDelay = (String)batchUIData.schedulingDelay().map((Function1 & Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable)() -> "-");
            String formattedProcessingTime = (String)batchUIData.processingDelay().map((Function1 & Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable)() -> "-");
            String formattedTotalDelay = (String)batchUIData.totalDelay().map((Function1 & Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable)() -> "-");
            scala.collection.immutable.Seq inputMetadatas = ((IterableOnceOps)batchUIData.streamIdToInputInfo().values().flatMap((Function1 & Serializable)inputInfo -> inputInfo.metadataDescription().map((Function1 & Serializable)desc -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId())), desc)))).toSeq();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("Batch Duration: "));
            $buf3.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(this.streamingListener().batchDuration()));
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("Input data size: "));
            $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
            $buf5.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)BoxesRunTime.boxToLong((long)batchUIData.numRecords()));
            $buf5.$amp$plus((Object)new Text(" records\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("Scheduling delay: "));
            $buf7.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
            $buf7.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)formattedSchedulingDelay);
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf10 = new NodeBuffer();
            $buf10.$amp$plus((Object)new Text("Processing time: "));
            $buf9.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf10.toVector()));
            $buf9.$amp$plus((Object)new Text("\n            "));
            $buf9.$amp$plus((Object)formattedProcessingTime);
            $buf9.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("Total delay: "));
            $buf11.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf12.toVector()));
            $buf11.$amp$plus((Object)new Text("\n            "));
            $buf11.$amp$plus((Object)formattedTotalDelay);
            $buf11.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf11.toVector()));
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (inputMetadatas.nonEmpty()) {
                NodeBuffer $buf13 = new NodeBuffer();
                $buf13.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf14 = new NodeBuffer();
                $buf14.$amp$plus((Object)new Text("Input Metadata:"));
                $buf13.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf14.toVector()));
                $buf13.$amp$plus(this.generateInputMetadataTable((scala.collection.immutable.Seq<Tuple2<Object, String>>)inputMetadatas));
                $buf13.$amp$plus((Object)new Text("\n              "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf13.toVector());
                boxedUnit = elem;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit);
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
            NodeSeq content = summary.$plus$plus(this.generateJobTable(request, batchUIData));
            seq = org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage(request, "Details of batch at " + formattedBatchTime, (Function0 & Serializable)() -> content, (SparkUITab)this.parent, org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$5(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$6(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$7());
        }
        return seq;
    }

    public scala.collection.immutable.Seq<Node> generateInputMetadataTable(scala.collection.immutable.Seq<Tuple2<Object, String>> inputMetadatas) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", org.apache.spark.ui.UIUtils$.MODULE$.TABLE_CLASS_STRIPED_SORTABLE(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Input"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Metadata "));
        $buf5.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Batch Input Details", "right"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus(inputMetadatas.flatMap((Function1 & Serializable)inputMetadata -> this.generateInputMetadataRow((Tuple2<Object, String>)inputMetadata)));
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    public scala.collection.immutable.Seq<Node> generateInputMetadataRow(Tuple2<Object, String> inputMetadata) {
        int streamId = inputMetadata._1$mcI$sp();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus(this.streamingListener().streamName(streamId).getOrElse((Function0 & Serializable)() -> "Stream-" + streamId));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(this.metadataDescriptionToHTML((String)inputMetadata._2()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    private scala.collection.immutable.Seq<Node> metadataDescriptionToHTML(String metadataDescription) {
        return Unparsed$.MODULE$.apply(StringEscapeUtils.escapeHtml4((String)metadataDescription).replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;").replace("\n", "<br/>"));
    }

    private scala.collection.immutable.Seq<Node> outputOpStatusCell(OutputOperationUIData outputOp, int rowspan) {
        Option<String> option = outputOp.failureReason();
        if (option instanceof Some) {
            Some some = (Some)option;
            String failureReason = (String)some.value();
            String failureReasonForUI = UIUtils$.MODULE$.createOutputOperationFailureForUI(failureReason);
            return UIUtils$.MODULE$.failureReasonCell(failureReasonForUI, rowspan, false);
        }
        if (None$.MODULE$.equals(option)) {
            if (outputOp.endTime().isEmpty()) {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("rowspan", Integer.toString(rowspan), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("-"));
                return new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
            }
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", Integer.toString(rowspan), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("Succeeded"));
            return new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ long $anonfun$generateNormalJobRow$1(JobData sparkJob$1, Date start) {
        long end = BoxesRunTime.unboxToLong((Object)sparkJob$1.completionTime().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> System.currentTimeMillis()));
        return end - start.getTime();
    }

    public static final /* synthetic */ boolean $anonfun$generateNormalJobRow$5(StageData x$2) {
        Option option = x$2.failureReason();
        None$ none$ = None$.MODULE$;
        return !(option != null ? !option.equals(none$) : none$ != null);
    }

    public static final /* synthetic */ int $anonfun$generateJobTable$6(Tuple2 x$5) {
        return ((OutputOperationUIData)x$5._1()).id();
    }

    public static final /* synthetic */ SparkJobIdWithUIData $anonfun$generateJobTable$8(BatchPage $this, int jobId) {
        return new SparkJobIdWithUIData(jobId, $this.getJobData(jobId));
    }

    public BatchPage(StreamingTab parent) {
        this.parent = parent;
        super("batch");
        this.streamingListener = parent.listener();
        this.store = parent.parent().store();
    }
}

