/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.mllib.feature.Word2VecModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Loader;
import org.apache.spark.mllib.util.Loader$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.MonadicJValue$;
import org.json4s.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Builder;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Word2VecModel$
implements Loader<Word2VecModel>,
Serializable {
    public static final Word2VecModel$ MODULE$ = new Word2VecModel$();

    public Tuple2<Map<String, Object>, float[]> org$apache$spark$mllib$feature$Word2VecModel$$buildFromVecMap(Map<String, float[]> model) {
        Predef$.MODULE$.require(model.nonEmpty(), (Function0 & Serializable)() -> "Word2VecMap should be non-empty");
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(((float[])((Tuple2)model.head())._2()).length, model.size());
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int vectorSize = sp2._1$mcI$sp();
        int numWords = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(vectorSize, numWords);
        int vectorSize2 = sp3._1$mcI$sp();
        int numWords2 = sp3._2$mcI$sp();
        float[] wordVectors = new float[vectorSize2 * numWords2];
        Builder wordIndex = Map$.MODULE$.newBuilder();
        wordIndex.sizeHint(numWords2);
        model.iterator().zipWithIndex().foreach((Function1 & Serializable)x0$1 -> {
            Word2VecModel$.$anonfun$buildFromVecMap$2(wordIndex, wordVectors, vectorSize2, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Tuple2(wordIndex.result(), (Object)wordVectors);
    }

    @Override
    public Word2VecModel load(SparkContext sc, String path) {
        String string;
        Tuple3<String, String, JValue> tuple3 = Loader$.MODULE$.loadMetadata(sc, path);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String loadedClassName = (String)tuple3._1();
        String loadedVersion = (String)tuple3._2();
        JValue metadata = (JValue)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)loadedClassName, (Object)loadedVersion, (Object)metadata);
        String loadedClassName2 = (String)tuple32._1();
        String loadedVersion2 = (String)tuple32._2();
        JValue metadata2 = (JValue)tuple32._3();
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        int expectedVectorSize = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(metadata2), "vectorSize")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
        int expectedNumWords = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(metadata2), "numWords")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
        String classNameV1_0 = Word2VecModel$SaveLoadV1_0$.MODULE$.classNameV1_0();
        Tuple2 tuple2 = new Tuple2((Object)loadedClassName2, (Object)loadedVersion2);
        if (tuple2 != null && "1.0".equals(string = (String)tuple2._2())) {
            Word2VecModel model = Word2VecModel$SaveLoadV1_0$.MODULE$.load(sc, path);
            int vectorSize = ((float[])model.getVectors().values().head()).length;
            int numWords = model.getVectors().size();
            Predef$.MODULE$.require(expectedVectorSize == vectorSize, (Function0 & Serializable)() -> "Word2VecModel requires each word to be mapped to a vector of size " + expectedVectorSize + ", got vector of size " + vectorSize);
            Predef$.MODULE$.require(expectedNumWords == numWords, (Function0 & Serializable)() -> "Word2VecModel requires " + expectedNumWords + " words, but got " + numWords);
            return model;
        }
        throw new Exception("Word2VecModel.load did not recognize model with (className, format version):(" + loadedClassName2 + ", " + loadedVersion2 + ").  Supported:\n  (" + classNameV1_0 + ", 1.0)");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Word2VecModel$.class);
    }

    public static final /* synthetic */ void $anonfun$buildFromVecMap$2(Builder wordIndex$1, float[] wordVectors$1, int vectorSize$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                String word = (String)tuple22._1();
                float[] vector = (float[])tuple22._2();
                wordIndex$1.$plus$eq((Object)new Tuple2((Object)word, (Object)BoxesRunTime.boxToInteger((int)i)));
                Array$.MODULE$.copy((Object)vector, 0, (Object)wordVectors$1, i * vectorSize$2, vectorSize$2);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private Word2VecModel$() {
    }
}

