/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.io.netty.handler.codec.socks;

import java.util.List;
import org.sparkproject.io.netty.buffer.ByteBuf;
import org.sparkproject.io.netty.channel.ChannelHandlerContext;
import org.sparkproject.io.netty.handler.codec.ReplayingDecoder;
import org.sparkproject.io.netty.handler.codec.socks.SocksAuthResponse;
import org.sparkproject.io.netty.handler.codec.socks.SocksAuthStatus;
import org.sparkproject.io.netty.handler.codec.socks.SocksCommonUtils;
import org.sparkproject.io.netty.handler.codec.socks.SocksSubnegotiationVersion;

public class SocksAuthResponseDecoder
extends ReplayingDecoder<State> {
    public SocksAuthResponseDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                if (byteBuf.readByte() != SocksSubnegotiationVersion.AUTH_PASSWORD.byteValue()) {
                    out.add(SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE);
                    break;
                }
                this.checkpoint(State.READ_AUTH_RESPONSE);
            }
            case READ_AUTH_RESPONSE: {
                SocksAuthStatus authStatus = SocksAuthStatus.valueOf(byteBuf.readByte());
                out.add(new SocksAuthResponse(authStatus));
                break;
            }
            default: {
                throw new Error("Unexpected response decoder state: " + this.state());
            }
        }
        channelHandlerContext.pipeline().remove(this);
    }

    public static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_AUTH_RESPONSE;

    }
}

