/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.QueryContext;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisContext$;
import org.apache.spark.sql.catalyst.analysis.MultiInstanceRelation;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.analysis.V2TableReference;
import org.apache.spark.sql.catalyst.analysis.V2TableReferenceUtils$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.TemporaryViewRelation;
import org.apache.spark.sql.catalyst.catalog.UnresolvedCatalogRelation;
import org.apache.spark.sql.catalyst.catalog.UnresolvedCatalogRelation$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan$;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias$;
import org.apache.spark.sql.catalyst.streaming.StreamingRelationV2;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.LookupCatalog;
import org.apache.spark.sql.connector.catalog.LookupCatalog$AsTableIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$CatalogAndIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$CatalogAndMultipartIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$CatalogAndNamespace$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$NonSessionCatalogAndIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$SessionCatalogAndIdentifier$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.catalog.V2TableWithV1Fallback;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tma\u0001\u0002\u000e\u001c\u0001!B\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0005\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0013\")Q\n\u0001C\u0001\u001d\u0016!!\u000b\u0001\u0001T\u0011\u001d\u0001\bA1A\u0005\u0002EDaa\u001e\u0001!\u0002\u0013\u0011\b\"\u0002=\u0001\t\u0013I\bbBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gA\u0011\"!\u0012\u0001#\u0003%\t!a\u0012\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`!9\u00111\u0014\u0001\u0005\n\u0005u\u0005\"CAT\u0001E\u0005I\u0011BAU\u0011%\ti\u000bAI\u0001\n\u0013\tI\u000bC\u0004\u00020\u0002!\t!!-\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBAe\u0001\u0011%\u00111\u001a\u0005\b\u0003'\u0004A\u0011BAk\u0011\u001d\t\t\u0010\u0001C\u0005\u0003gDq!!>\u0001\t\u0013\t9\u0010C\u0004\u0002|\u0002!I!!@\t\u0013\t\u0015\u0001!%A\u0005\n\u0005\u001d\u0003b\u0002B\u0004\u0001\u0011%!\u0011\u0002\u0002\u0013%\u0016d\u0017\r^5p]J+7o\u001c7vi&|gN\u0003\u0002\u001d;\u0005A\u0011M\\1msNL7O\u0003\u0002\u001f?\u0005A1-\u0019;bYf\u001cHO\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001S=*4h\u0011\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A\u001aT\"A\u0019\u000b\u0005Iz\u0012AB3se>\u00148/\u0003\u00025c\t\u0011B)\u0019;b)f\u0004X-\u0012:s_J\u001c()Y:f!\t1\u0014(D\u00018\u0015\tA\u0014%\u0001\u0005j]R,'O\\1m\u0013\tQtGA\u0004M_\u001e<\u0017N\\4\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014aB2bi\u0006dwn\u001a\u0006\u0003\u0001~\t\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005\tk$!\u0004'p_.,\boQ1uC2|w\r\u0005\u0002E\u000b6\tQ$\u0003\u0002G;\ti1+\u0015'D_:4\u0007*\u001a7qKJ\fabY1uC2|w-T1oC\u001e,'/F\u0001J!\ta$*\u0003\u0002L{\tq1)\u0019;bY><W*\u00198bO\u0016\u0014\u0018aD2bi\u0006dwnZ'b]\u0006<WM\u001d\u0011\u0002\rqJg.\u001b;?)\ty\u0015\u000b\u0005\u0002Q\u00015\t1\u0004C\u0003H\u0007\u0001\u0007\u0011J\u0001\u0005DC\u000eDWmS3z!\u0011QCK\u00166\n\u0005U[#A\u0002+va2,'\u0007E\u0002X?\nt!\u0001W/\u000f\u0005ecV\"\u0001.\u000b\u0005m;\u0013A\u0002\u001fs_>$h(C\u0001-\u0013\tq6&A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\f'aA*fc*\u0011al\u000b\t\u0003G\u001et!\u0001Z3\u0011\u0005e[\u0013B\u00014,\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\\\u0003c\u0001\u0016l[&\u0011An\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005As\u0017BA8\u001c\u00059!\u0016.\\3Ue\u00064X\r\\*qK\u000e\f\u0001C^\u0019TKN\u001c\u0018n\u001c8DCR\fGn\\4\u0016\u0003I\u0004\"a];\u000e\u0003QT!AP\u000f\n\u0005Y$(AD*fgNLwN\\\"bi\u0006dwnZ\u0001\u0012mF\u001aVm]:j_:\u001c\u0015\r^1m_\u001e\u0004\u0013!\u0004:fY\u0006$\u0018n\u001c8DC\u000eDW-F\u0001{!\u001dY\u0018\u0011AA\u0003\u0003\u0013i\u0011\u0001 \u0006\u0003{z\fq!\\;uC\ndWM\u0003\u0002\u0000W\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007\u0005\rAPA\u0002NCB\u00042!a\u0002\u0005\u001b\u0005\u0001\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\bY><\u0017nY1m\u0015\r\t\u0019\"H\u0001\u0006a2\fgn]\u0005\u0005\u0003/\tiAA\u0006M_\u001eL7-\u00197QY\u0006t\u0017\u0001E3ya\u0006tG-\u00133f]RLg-[3s)\r1\u0016Q\u0004\u0005\u0007\u0003?A\u0001\u0019\u0001,\u0002\u00139\fW.\u001a)beR\u001c\u0018A\u00047p_.,\b\u000fV3naZKWm\u001e\u000b\u0005\u0003K\ti\u0003\u0005\u0003+W\u0006\u001d\u0002cA:\u0002*%\u0019\u00111\u0006;\u0003+Q+W\u000e]8sCJLh+[3x%\u0016d\u0017\r^5p]\"1\u0011qF\u0005A\u0002Y\u000b!\"\u001b3f]RLg-[3s\u0003=\u0011Xm]8mm\u0016\u0014V\r\\1uS>tGCBA\u001b\u0003o\t\t\u0005\u0005\u0003+W\u0006%\u0001bBA\u001d\u0015\u0001\u0007\u00111H\u0001\u0002kB\u0019\u0001+!\u0010\n\u0007\u0005}2D\u0001\nV]J,7o\u001c7wK\u0012\u0014V\r\\1uS>t\u0007\u0002CA\"\u0015A\u0005\t\u0019\u00016\u0002\u001dQLW.\u001a+sCZ,Gn\u00159fG\u0006I\"/Z:pYZ,'+\u001a7bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\tIEK\u0002k\u0003\u0017Z#!!\u0014\u0011\t\u0005=\u0013\u0011L\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/Z\u0013AC1o]>$\u0018\r^5p]&!\u00111LA)\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fGJ,\u0017\r^3SK2\fG/[8o)9\t)$!\u0019\u0002j\u0005M\u0014qPAH\u00033CaA\u0010\u0007A\u0002\u0005\r\u0004c\u0001\u001f\u0002f%\u0019\u0011qM\u001f\u0003\u001b\r\u000bG/\u00197pOBcWoZ5o\u0011\u001d\tY\u0007\u0004a\u0001\u0003[\nQ!\u001b3f]R\u00042\u0001PA8\u0013\r\t\t(\u0010\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\bbBA;\u0019\u0001\u0007\u0011qO\u0001\u0006i\u0006\u0014G.\u001a\t\u0005U-\fI\bE\u0002=\u0003wJ1!! >\u0005\u0015!\u0016M\u00197f\u0011\u001d\t\t\t\u0004a\u0001\u0003\u0007\u000bqa\u001c9uS>t7\u000f\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tIiH\u0001\u0005kRLG.\u0003\u0003\u0002\u000e\u0006\u001d%\u0001G\"bg\u0016Len]3og&$\u0018N^3TiJLgnZ'ba\"9\u0011\u0011\u0013\u0007A\u0002\u0005M\u0015aC5t'R\u0014X-Y7j]\u001e\u00042AKAK\u0013\r\t9j\u000b\u0002\b\u0005>|G.Z1o\u0011\u0019\t\u0019\u0005\u0004a\u0001U\u0006y!/Z:pYZ,G+Z7q-&,w\u000f\u0006\u0005\u00026\u0005}\u0015\u0011UAR\u0011\u0019\ty#\u0004a\u0001-\"I\u0011\u0011S\u0007\u0011\u0002\u0003\u0007\u00111\u0013\u0005\n\u0003Kk\u0001\u0013!a\u0001\u0003'\u000bA\"[:US6,GK]1wK2\f\u0011D]3t_24X\rV3naZKWm\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0016\u0016\u0005\u0003'\u000bY%A\rsKN|GN^3UK6\u0004h+[3xI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u0005:fg>dg/\u001a*fM\u0016\u0014XM\\2f)\u0011\tI!a-\t\u000f\u0005U\u0006\u00031\u0001\u00028\u0006\u0019!/\u001a4\u0011\u0007A\u000bI,C\u0002\u0002<n\u0011\u0001C\u0016\u001aUC\ndWMU3gKJ,gnY3\u0002#\u001d,Go\u0014:M_\u0006$'+\u001a7bi&|g\u000e\u0006\u0003\u0002\n\u0005\u0005\u0007bBA[#\u0001\u0007\u0011qW\u0001\rY>\fGMU3mCRLwN\u001c\u000b\u0005\u0003\u0013\t9\rC\u0004\u00026J\u0001\r!a.\u0002'\u0005$\u0017\r\u001d;DC\u000eDW\r\u001a*fY\u0006$\u0018n\u001c8\u0015\r\u0005%\u0011QZAi\u0011\u001d\tym\u0005a\u0001\u0003\u0013\taaY1dQ\u0016$\u0007bBA['\u0001\u0007\u0011qW\u0001\u0011[\u0006$8\r[3t%\u00164WM]3oG\u0016$b!a%\u0002X\u0006=\bbBAm)\u0001\u0007\u00111\\\u0001\te\u0016d\u0017\r^5p]B!\u0011Q\\Av\u001b\t\tyN\u0003\u0003\u0002b\u0006\r\u0018A\u0001<3\u0015\u0011\t)/a:\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0004\u0003S|\u0012!C3yK\u000e,H/[8o\u0013\u0011\ti/a8\u0003)\u0011\u000bG/Y*pkJ\u001cWM\u0016\u001aSK2\fG/[8o\u0011\u001d\t)\f\u0006a\u0001\u0003o\u000bq\"[:SKN|GN^5oOZKWm^\u000b\u0003\u0003'\u000ba#[:SK\u001a,'O]3e)\u0016l\u0007OV5fo:\u000bW.\u001a\u000b\u0005\u0003'\u000bI\u0010\u0003\u0004\u0002 Y\u0001\rAV\u0001\u000bi>\u001c\u0015m\u00195f\u0017\u0016LH\u0003CA\u0003\u0003\u007f\u0014\tAa\u0001\t\ry:\u0002\u0019AA2\u0011\u001d\tYg\u0006a\u0001\u0003[B\u0001\"a\u0011\u0018!\u0003\u0005\rA[\u0001\u0015i>\u001c\u0015m\u00195f\u0017\u0016LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\rdwN\\3XSRD\u0007\u000b\\1o\u0013\u0012$b!!\u0003\u0003\f\t=\u0001b\u0002B\u00073\u0001\u0007\u0011\u0011B\u0001\u0005a2\fg\u000eC\u0004\u0003\u0012e\u0001\rAa\u0005\u0002\rAd\u0017M\\%e!\u0011Q3N!\u0006\u0011\u0007)\u00129\"C\u0002\u0003\u001a-\u0012A\u0001T8oO\u0002")
public class RelationResolution
implements DataTypeErrorsBase,
LookupCatalog,
SQLConfHelper {
    private final CatalogManager catalogManager;
    private final SessionCatalog v1SessionCatalog;
    private volatile LookupCatalog$CatalogAndMultipartIdentifier$ CatalogAndMultipartIdentifier$module;
    private volatile LookupCatalog$SessionCatalogAndIdentifier$ SessionCatalogAndIdentifier$module;
    private volatile LookupCatalog$NonSessionCatalogAndIdentifier$ NonSessionCatalogAndIdentifier$module;
    private volatile LookupCatalog$CatalogAndNamespace$ CatalogAndNamespace$module;
    private volatile LookupCatalog$CatalogAndIdentifier$ CatalogAndIdentifier$module;
    private volatile LookupCatalog$AsTableIdentifier$ AsTableIdentifier$module;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public CatalogPlugin currentCatalog() {
        return LookupCatalog.currentCatalog$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public LookupCatalog$CatalogAndMultipartIdentifier$ org$apache$spark$sql$connector$catalog$LookupCatalog$$CatalogAndMultipartIdentifier() {
        if (this.CatalogAndMultipartIdentifier$module == null) {
            this.org$apache$spark$sql$connector$catalog$LookupCatalog$$CatalogAndMultipartIdentifier$lzycompute$1();
        }
        return this.CatalogAndMultipartIdentifier$module;
    }

    @Override
    public LookupCatalog$SessionCatalogAndIdentifier$ SessionCatalogAndIdentifier() {
        if (this.SessionCatalogAndIdentifier$module == null) {
            this.SessionCatalogAndIdentifier$lzycompute$1();
        }
        return this.SessionCatalogAndIdentifier$module;
    }

    @Override
    public LookupCatalog$NonSessionCatalogAndIdentifier$ NonSessionCatalogAndIdentifier() {
        if (this.NonSessionCatalogAndIdentifier$module == null) {
            this.NonSessionCatalogAndIdentifier$lzycompute$1();
        }
        return this.NonSessionCatalogAndIdentifier$module;
    }

    @Override
    public LookupCatalog$CatalogAndNamespace$ CatalogAndNamespace() {
        if (this.CatalogAndNamespace$module == null) {
            this.CatalogAndNamespace$lzycompute$1();
        }
        return this.CatalogAndNamespace$module;
    }

    @Override
    public LookupCatalog$CatalogAndIdentifier$ CatalogAndIdentifier() {
        if (this.CatalogAndIdentifier$module == null) {
            this.CatalogAndIdentifier$lzycompute$1();
        }
        return this.CatalogAndIdentifier$module;
    }

    @Override
    public LookupCatalog$AsTableIdentifier$ AsTableIdentifier() {
        if (this.AsTableIdentifier$module == null) {
            this.AsTableIdentifier$lzycompute$1();
        }
        return this.AsTableIdentifier$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    public SessionCatalog v1SessionCatalog() {
        return this.v1SessionCatalog;
    }

    private scala.collection.mutable.Map<Tuple2<Seq<String>, Option<TimeTravelSpec>>, LogicalPlan> relationCache() {
        return AnalysisContext$.MODULE$.get().relationCache();
    }

    public Seq<String> expandIdentifier(Seq<String> nameParts) {
        if (!this.isResolvingView() || this.isReferredTempViewName(nameParts)) {
            return nameParts;
        }
        if (nameParts.length() == 1) {
            return (Seq)AnalysisContext$.MODULE$.get().catalogAndNamespace().$colon$plus(nameParts.head());
        }
        if (this.catalogManager().isCatalogRegistered((String)nameParts.head())) {
            return nameParts;
        }
        String string = (String)AnalysisContext$.MODULE$.get().catalogAndNamespace().head();
        return (Seq)nameParts.$plus$colon((Object)string);
    }

    public Option<TemporaryViewRelation> lookupTempView(Seq<String> identifier) {
        if (this.isResolvingView() && !this.isReferredTempViewName(identifier)) {
            return None$.MODULE$;
        }
        return this.v1SessionCatalog().getRawLocalOrGlobalTempView(identifier);
    }

    public Option<LogicalPlan> resolveRelation(UnresolvedRelation u, Option<TimeTravelSpec> timeTravelSpec) {
        Option<TimeTravelSpec> timeTravelSpecFromOptions = TimeTravelSpec$.MODULE$.fromOptions(u.options(), this.conf().getConf(SQLConf$.MODULE$.TIME_TRAVEL_TIMESTAMP_KEY()), this.conf().getConf(SQLConf$.MODULE$.TIME_TRAVEL_VERSION_KEY()), this.conf().sessionLocalTimeZone());
        if (timeTravelSpec.nonEmpty() && timeTravelSpecFromOptions.nonEmpty()) {
            throw new AnalysisException("MULTIPLE_TIME_TRAVEL_SPEC", Predef$.MODULE$.Map().empty());
        }
        Option finalTimeTravelSpec = timeTravelSpec.orElse((Function0 & Serializable)() -> timeTravelSpecFromOptions);
        return this.resolveTempView(u.multipartIdentifier(), u.isStreaming(), finalTimeTravelSpec.isDefined()).orElse((Function0 & Serializable)() -> {
            Option<Tuple2<CatalogPlugin, Identifier>> option;
            Seq<String> seq = this.expandIdentifier(u.multipartIdentifier());
            if (seq != null && !(option = this.CatalogAndIdentifier().unapply(seq)).isEmpty()) {
                CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
                Identifier ident = (Identifier)((Tuple2)option.get())._2();
                Tuple2<Seq<String>, Option<TimeTravelSpec>> key = this.toCacheKey(catalog, ident, (Option<TimeTravelSpec>)finalTimeTravelSpec);
                Option<Object> planId = u.getTagValue(LogicalPlan$.MODULE$.PLAN_ID_TAG());
                return this.relationCache().get(key).map((Function1 & Serializable)cache -> {
                    LogicalPlan cachedRelation = (LogicalPlan)cache.transform(new Serializable(null){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 instanceof MultiInstanceRelation) {
                                A1 A12 = A1;
                                LogicalPlan newRelation = ((MultiInstanceRelation)((Object)A12)).newInstance();
                                newRelation.copyTagsFrom(A12);
                                return (B1)newRelation;
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(LogicalPlan x1) {
                            LogicalPlan logicalPlan = x1;
                            return logicalPlan instanceof MultiInstanceRelation;
                        }
                    });
                    return this.cloneWithPlanId(cachedRelation, planId);
                }).orElse((Function0 & Serializable)() -> {
                    Option writePrivilegesString = Option$.MODULE$.apply((Object)u.options().get(UnresolvedRelation$.MODULE$.REQUIRED_WRITE_PRIVILEGES()));
                    Option<Table> table = CatalogV2Util$.MODULE$.loadTable(catalog, ident, (Option<TimeTravelSpec>)finalTimeTravelSpec, (Option<String>)writePrivilegesString);
                    Option<LogicalPlan> loaded = this.createRelation(catalog, ident, table, u.clearWritePrivileges().options(), u.isStreaming(), (Option<TimeTravelSpec>)finalTimeTravelSpec);
                    loaded.foreach((Function1 & Serializable)x$1 -> {
                        RelationResolution.$anonfun$resolveRelation$5(this, key, x$1);
                        return BoxedUnit.UNIT;
                    });
                    return loaded.map((Function1 & Serializable)x$2 -> this.cloneWithPlanId((LogicalPlan)x$2, planId));
                });
            }
            return None$.MODULE$;
        });
    }

    public Option<TimeTravelSpec> resolveRelation$default$2() {
        return None$.MODULE$;
    }

    private Option<LogicalPlan> createRelation(CatalogPlugin catalog, Identifier ident, Option<Table> table, CaseInsensitiveStringMap options, boolean isStreaming, Option<TimeTravelSpec> timeTravelSpec) {
        return table.map((Function1 & Serializable)x0$1 -> {
            Table table = x0$1;
            if (table instanceof V1Table) {
                V1Table v1Table = (V1Table)table;
                if (CatalogV2Util$.MODULE$.isSessionCatalog(catalog) || !v1Table.catalogTable().tracksPartitionsInCatalog()) {
                    if (isStreaming) {
                        CatalogTableType catalogTableType = v1Table.v1Table().tableType();
                        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
                        if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                            throw QueryCompilationErrors$.MODULE$.permanentViewNotSupportedByStreamingReadingAPIError(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted());
                        }
                        String string = catalog.name();
                        return SubqueryAlias$.MODULE$.apply((Seq<String>)((Seq)CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier().$plus$colon((Object)string)), (LogicalPlan)new UnresolvedCatalogRelation(v1Table.v1Table(), options, true));
                    }
                    return this.v1SessionCatalog().getRelation(v1Table.v1Table(), options);
                }
            }
            if (isStreaming) {
                None$ none$;
                Predef$.MODULE$.assert(timeTravelSpec.isEmpty(), (Function0 & Serializable)() -> "time travel is not allowed in streaming");
                Table table2 = table;
                if (table2 instanceof V2TableWithV1Fallback) {
                    V2TableWithV1Fallback v2TableWithV1Fallback = (V2TableWithV1Fallback)table2;
                    CatalogTable x$1 = v2TableWithV1Fallback.v1Table();
                    boolean x$2 = true;
                    CaseInsensitiveStringMap x$3 = UnresolvedCatalogRelation$.MODULE$.apply$default$2();
                    Some some = new Some((Object)new UnresolvedCatalogRelation(x$1, x$3, true));
                    none$ = some;
                } else {
                    none$ = None$.MODULE$;
                }
                None$ v1Fallback = none$;
                String string = catalog.name();
                return SubqueryAlias$.MODULE$.apply((Seq<String>)((Seq)CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier().$plus$colon((Object)string)), (LogicalPlan)new StreamingRelationV2((Option<TableProvider>)None$.MODULE$, table.name(), table, options, CatalogV2Implicits$.MODULE$.ColumnsHelper(table.columns()).toAttributes(), (Option<CatalogPlugin>)new Some((Object)catalog), (Option<Identifier>)new Some((Object)ident), (Option<LogicalPlan>)v1Fallback));
            }
            String string = catalog.name();
            return SubqueryAlias$.MODULE$.apply((Seq<String>)((Seq)CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier().$plus$colon((Object)string)), (LogicalPlan)DataSourceV2Relation$.MODULE$.create(table, (Option<CatalogPlugin>)new Some((Object)catalog), (Option<Identifier>)new Some((Object)ident), options, timeTravelSpec));
        });
    }

    private Option<LogicalPlan> resolveTempView(Seq<String> identifier, boolean isStreaming, boolean isTimeTravel) {
        return this.lookupTempView(identifier).map((Function1 & Serializable)v -> {
            SubqueryAlias tempViewPlan = this.v1SessionCatalog().getTempViewRelation((TemporaryViewRelation)v);
            if (isStreaming && !tempViewPlan.isStreaming()) {
                throw QueryCompilationErrors$.MODULE$.readNonStreamingTempViewError(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(identifier).quoted());
            }
            if (isTimeTravel) {
                throw QueryCompilationErrors$.MODULE$.timeTravelUnsupportedError(this.toSQLId(identifier));
            }
            return tempViewPlan;
        });
    }

    private boolean resolveTempView$default$2() {
        return false;
    }

    private boolean resolveTempView$default$3() {
        return false;
    }

    public LogicalPlan resolveReference(V2TableReference ref) {
        LogicalPlan relation = this.getOrLoadRelation(ref);
        Option<Object> planId = ref.getTagValue(LogicalPlan$.MODULE$.PLAN_ID_TAG());
        return this.cloneWithPlanId(relation, planId);
    }

    private LogicalPlan getOrLoadRelation(V2TableReference ref) {
        Tuple2<Seq<String>, Option<TimeTravelSpec>> key = this.toCacheKey(ref.catalog(), ref.identifier(), this.toCacheKey$default$3());
        Option option = this.relationCache().get(key);
        if (option instanceof Some) {
            Some some = (Some)option;
            LogicalPlan cached = (LogicalPlan)some.value();
            return this.adaptCachedRelation(cached, ref);
        }
        if (None$.MODULE$.equals(option)) {
            LogicalPlan relation = this.loadRelation(ref);
            this.relationCache().update(key, (Object)relation);
            return relation;
        }
        throw new MatchError((Object)option);
    }

    private LogicalPlan loadRelation(V2TableReference ref) {
        Table table = ref.catalog().loadTable(ref.identifier());
        V2TableReferenceUtils$.MODULE$.validateLoadedTable(table, ref);
        Seq<String> tableName = CatalogV2Implicits$.MODULE$.IdentifierHelper(ref.identifier()).toQualifiedNameParts(ref.catalog());
        return SubqueryAlias$.MODULE$.apply(tableName, (LogicalPlan)ref.toRelation(table));
    }

    private LogicalPlan adaptCachedRelation(LogicalPlan cached, V2TableReference ref) {
        return (LogicalPlan)cached.transform(new Serializable(this, ref){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ RelationResolution $outer;
            private final V2TableReference ref$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSourceV2Relation dataSourceV2Relation;
                A1 A1 = x1;
                if (A1 instanceof DataSourceV2Relation && this.$outer.org$apache$spark$sql$catalyst$analysis$RelationResolution$$matchesReference(dataSourceV2Relation = (DataSourceV2Relation)A1, this.ref$1)) {
                    V2TableReferenceUtils$.MODULE$.validateLoadedTable(dataSourceV2Relation.table(), this.ref$1);
                    Seq<AttributeReference> x$1 = this.ref$1.output();
                    CaseInsensitiveStringMap x$2 = this.ref$1.options();
                    Table x$3 = dataSourceV2Relation.copy$default$1();
                    Option<CatalogPlugin> x$4 = dataSourceV2Relation.copy$default$3();
                    Option<Identifier> x$5 = dataSourceV2Relation.copy$default$4();
                    Option<TimeTravelSpec> x$6 = dataSourceV2Relation.copy$default$6();
                    return (B1)dataSourceV2Relation.copy(x$3, x$1, x$4, x$5, x$2, x$6);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                DataSourceV2Relation dataSourceV2Relation;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof DataSourceV2Relation && this.$outer.org$apache$spark$sql$catalyst$analysis$RelationResolution$$matchesReference(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan, this.ref$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ref$1 = ref$1;
            }
        });
    }

    public boolean org$apache$spark$sql$catalyst$analysis$RelationResolution$$matchesReference(DataSourceV2Relation relation, V2TableReference ref) {
        return relation.catalog().contains((Object)ref.catalog()) && relation.identifier().contains((Object)ref.identifier());
    }

    private boolean isResolvingView() {
        return AnalysisContext$.MODULE$.get().catalogAndNamespace().nonEmpty();
    }

    private boolean isReferredTempViewName(Seq<String> nameParts) {
        Function2<String, String, Object> resolver = this.conf().resolver();
        return AnalysisContext$.MODULE$.get().referredTempViewNames().exists((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)RelationResolution.$anonfun$isReferredTempViewName$1(nameParts, resolver, n)));
    }

    private Tuple2<Seq<String>, Option<TimeTravelSpec>> toCacheKey(CatalogPlugin catalog, Identifier ident, Option<TimeTravelSpec> timeTravelSpec) {
        String string = catalog.name();
        return new Tuple2((Object)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)string, ClassTag$.MODULE$.apply(String.class))), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq(), timeTravelSpec);
    }

    private Option<TimeTravelSpec> toCacheKey$default$3() {
        return None$.MODULE$;
    }

    private LogicalPlan cloneWithPlanId(LogicalPlan plan2, Option<Object> planId) {
        Option<Object> option = planId;
        if (option instanceof Some) {
            Some some = (Some)option;
            long id = BoxesRunTime.unboxToLong((Object)some.value());
            LogicalPlan clone = plan2.clone();
            clone.setTagValue(LogicalPlan$.MODULE$.PLAN_ID_TAG(), BoxesRunTime.boxToLong((long)id));
            return clone;
        }
        if (None$.MODULE$.equals(option)) {
            return plan2;
        }
        throw new MatchError(option);
    }

    private final void org$apache$spark$sql$connector$catalog$LookupCatalog$$CatalogAndMultipartIdentifier$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.CatalogAndMultipartIdentifier$module == null) {
                this.CatalogAndMultipartIdentifier$module = new LookupCatalog$CatalogAndMultipartIdentifier$(this);
            }
        }
    }

    private final void SessionCatalogAndIdentifier$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.SessionCatalogAndIdentifier$module == null) {
                this.SessionCatalogAndIdentifier$module = new LookupCatalog$SessionCatalogAndIdentifier$(this);
            }
        }
    }

    private final void NonSessionCatalogAndIdentifier$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.NonSessionCatalogAndIdentifier$module == null) {
                this.NonSessionCatalogAndIdentifier$module = new LookupCatalog$NonSessionCatalogAndIdentifier$(this);
            }
        }
    }

    private final void CatalogAndNamespace$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.CatalogAndNamespace$module == null) {
                this.CatalogAndNamespace$module = new LookupCatalog$CatalogAndNamespace$(this);
            }
        }
    }

    private final void CatalogAndIdentifier$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.CatalogAndIdentifier$module == null) {
                this.CatalogAndIdentifier$module = new LookupCatalog$CatalogAndIdentifier$(this);
            }
        }
    }

    private final void AsTableIdentifier$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.AsTableIdentifier$module == null) {
                this.AsTableIdentifier$module = new LookupCatalog$AsTableIdentifier$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$resolveRelation$5(RelationResolution $this, Tuple2 key$1, LogicalPlan x$1) {
        $this.relationCache().update((Object)key$1, (Object)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$isReferredTempViewName$2(Function2 resolver$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String a = (String)tuple2._1();
            String b = (String)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)a, (Object)b));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isReferredTempViewName$1(Seq nameParts$1, Function2 resolver$1, Seq n) {
        return n.length() == nameParts$1.length() && ((IterableOnceOps)n.zip((IterableOnce)nameParts$1)).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RelationResolution.$anonfun$isReferredTempViewName$2(resolver$1, x0$1)));
    }

    public RelationResolution(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        Logging.$init$((Logging)this);
        LookupCatalog.$init$(this);
        SQLConfHelper.$init$(this);
        this.v1SessionCatalog = catalogManager.v1SessionCatalog();
    }
}

