/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.LinkedList;
import org.apache.spark.network.util.JavaUtils;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class TransportFrameDecoder
extends ChannelInboundHandlerAdapter {
    public static final String HANDLER_NAME = "frameDecoder";
    private static final int LENGTH_SIZE = 8;
    private static final int MAX_FRAME_SIZE = Integer.MAX_VALUE;
    private static final int UNKNOWN_FRAME_SIZE = -1;
    private static final long CONSOLIDATE_THRESHOLD = 0x1400000L;
    private final LinkedList<ByteBuf> buffers = new LinkedList();
    private final ByteBuf frameLenBuf = Unpooled.buffer((int)8, (int)8);
    private final long consolidateThreshold;
    private CompositeByteBuf frameBuf = null;
    private long consolidatedFrameBufSize = 0L;
    private int consolidatedNumComponents = 0;
    private long totalSize = 0L;
    private long nextFrameSize = -1L;
    private int frameRemainingBytes = -1;
    private volatile Interceptor interceptor;

    public TransportFrameDecoder() {
        this(0x1400000L);
    }

    @VisibleForTesting
    TransportFrameDecoder(long consolidateThreshold) {
        this.consolidateThreshold = consolidateThreshold;
    }

    public void channelRead(ChannelHandlerContext ctx, Object data) throws Exception {
        ByteBuf in = (ByteBuf)data;
        this.buffers.add(in);
        this.totalSize += (long)in.readableBytes();
        while (!this.buffers.isEmpty()) {
            if (this.interceptor != null) {
                ByteBuf first = this.buffers.getFirst();
                int available = first.readableBytes();
                if (this.feedInterceptor(first)) assert (!first.isReadable()) : "Interceptor still active but buffer has data.";
                int read = available - first.readableBytes();
                if (read == available) {
                    this.buffers.removeFirst().release();
                }
                this.totalSize -= (long)read;
                continue;
            }
            ByteBuf frame = this.decodeNext();
            if (frame == null) break;
            ctx.fireChannelRead((Object)frame);
        }
    }

    private long decodeFrameSize() {
        if (this.nextFrameSize != -1L || this.totalSize < 8L) {
            return this.nextFrameSize;
        }
        ByteBuf first = this.buffers.getFirst();
        if (first.readableBytes() >= 8) {
            this.nextFrameSize = first.readLong() - 8L;
            this.totalSize -= 8L;
            if (!first.isReadable()) {
                this.buffers.removeFirst().release();
            }
            return this.nextFrameSize;
        }
        while (this.frameLenBuf.readableBytes() < 8) {
            ByteBuf next = this.buffers.getFirst();
            int toRead = Math.min(next.readableBytes(), 8 - this.frameLenBuf.readableBytes());
            this.frameLenBuf.writeBytes(next, toRead);
            if (next.isReadable()) continue;
            this.buffers.removeFirst().release();
        }
        this.nextFrameSize = this.frameLenBuf.readLong() - 8L;
        this.totalSize -= 8L;
        this.frameLenBuf.clear();
        return this.nextFrameSize;
    }

    private ByteBuf decodeNext() {
        long frameSize = this.decodeFrameSize();
        if (frameSize == -1L) {
            return null;
        }
        if (this.frameBuf == null) {
            JavaUtils.checkArgument((frameSize < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Too large frame: %s", (Object[])new Object[]{frameSize});
            JavaUtils.checkArgument((frameSize > 0L ? 1 : 0) != 0, (String)"Frame length should be positive: %s", (Object[])new Object[]{frameSize});
            this.frameRemainingBytes = (int)frameSize;
            if (this.buffers.isEmpty()) {
                return null;
            }
            if (this.buffers.getFirst().readableBytes() >= this.frameRemainingBytes) {
                this.frameBuf = null;
                this.nextFrameSize = -1L;
                return this.nextBufferForFrame(this.frameRemainingBytes);
            }
            this.frameBuf = this.buffers.getFirst().alloc().compositeBuffer(Integer.MAX_VALUE);
        }
        while (this.frameRemainingBytes > 0 && !this.buffers.isEmpty()) {
            ByteBuf next = this.nextBufferForFrame(this.frameRemainingBytes);
            this.frameRemainingBytes -= next.readableBytes();
            this.frameBuf.addComponent(true, next);
        }
        if ((long)this.frameBuf.capacity() - this.consolidatedFrameBufSize > this.consolidateThreshold) {
            int newNumComponents = this.frameBuf.numComponents() - this.consolidatedNumComponents;
            this.frameBuf.consolidate(this.consolidatedNumComponents, newNumComponents);
            this.consolidatedFrameBufSize = this.frameBuf.capacity();
            this.consolidatedNumComponents = this.frameBuf.numComponents();
        }
        if (this.frameRemainingBytes > 0) {
            return null;
        }
        return this.consumeCurrentFrameBuf();
    }

    private ByteBuf consumeCurrentFrameBuf() {
        CompositeByteBuf frame = this.frameBuf;
        this.frameBuf = null;
        this.consolidatedFrameBufSize = 0L;
        this.consolidatedNumComponents = 0;
        this.nextFrameSize = -1L;
        return frame;
    }

    private ByteBuf nextBufferForFrame(int bytesToRead) {
        ByteBuf frame;
        ByteBuf buf = this.buffers.getFirst();
        if (buf.readableBytes() > bytesToRead) {
            frame = buf.retain().readSlice(bytesToRead);
            this.totalSize -= (long)bytesToRead;
        } else {
            frame = buf;
            this.buffers.removeFirst();
            this.totalSize -= (long)frame.readableBytes();
        }
        return frame;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.interceptor != null) {
            this.interceptor.channelInactive();
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.interceptor != null) {
            this.interceptor.exceptionCaught(cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        for (ByteBuf b : this.buffers) {
            b.release();
        }
        this.buffers.clear();
        this.frameLenBuf.release();
        ByteBuf frame = this.consumeCurrentFrameBuf();
        if (frame != null) {
            frame.release();
        }
        super.handlerRemoved(ctx);
    }

    public void setInterceptor(Interceptor interceptor) {
        JavaUtils.checkState((this.interceptor == null ? 1 : 0) != 0, (String)"Already have an interceptor.", (Object[])new Object[0]);
        this.interceptor = interceptor;
    }

    private boolean feedInterceptor(ByteBuf buf) throws Exception {
        if (this.interceptor != null && !this.interceptor.handle(buf)) {
            this.interceptor = null;
        }
        return this.interceptor != null;
    }

    public static interface Interceptor {
        public boolean handle(ByteBuf var1) throws Exception;

        public void exceptionCaught(Throwable var1) throws Exception;

        public void channelInactive() throws Exception;
    }
}

