/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.CollationAwareUTF8String;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeNonCSAICollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ", since="2.0.1", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001\u0002\u0016,\u0001bB\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011!Q\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C.\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u000bq\u0003A\u0011A/\t\u000b\t\u0004A\u0011I2\t\u000bq\u0003A\u0011A4\t\u000bq\u0003A\u0011A6\t\u000b5\u0004A\u0011I2\t\u000b9\u0004A\u0011I*\t\u000b=\u0004A\u0011I*\t\u000bA\u0004A\u0011I*\t\u000bE\u0004A\u0011\t:\t\u000bq\u0004A\u0011I?\t\u0015\u0005\r\u0001\u0001#b\u0001\n\u0013\t)\u0001\u0003\u0006\u0002\u0014\u0001A)\u0019!C\u0007\u0003+A\u0011\"!\b\u0001\u0011\u000b\u0007I\u0011B2\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u0011Q\u0007\u0001\u0005R\u0005]\u0002bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003O\u0002A\u0011KA5\u0011%\t9\bAA\u0001\n\u0003\tI\bC\u0005\u0002\u0002\u0002\t\n\u0011\"\u0001\u0002\u0004\"I\u0011\u0011\u0014\u0001\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u00037\u0003\u0011\u0013!C\u0001\u0003\u0007C\u0011\"!(\u0001\u0003\u0003%\t%a(\t\u0013\u0005=\u0006!!A\u0005\u0002\u0005U\u0001\"CAY\u0001\u0005\u0005I\u0011AAZ\u0011%\tI\fAA\u0001\n\u0003\nY\fC\u0005\u0002J\u0002\t\t\u0011\"\u0001\u0002L\"I\u0011q\u001a\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u001b\u0005\n\u0003+\u0004\u0011\u0011!C!\u0003/<\u0011\"a?,\u0003\u0003E\t!!@\u0007\u0011)Z\u0013\u0011!E\u0001\u0003\u007fDa\u0001\u0018\u0013\u0005\u0002\t]\u0001\"\u0003B\rI\u0005\u0005IQ\tB\u000e\u0011%\u0011i\u0002JA\u0001\n\u0003\u0013y\u0002C\u0005\u0003(\u0011\n\t\u0011\"!\u0003*!I!1\b\u0013\u0002\u0002\u0013%!Q\b\u0002\f'R\u0014\u0018N\\4U_6\u000b\u0007O\u0003\u0002-[\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqs&\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0014'A\u0002tc2T!AM\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0011(\u0010!G!\tQ4(D\u0001,\u0013\ta4FA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"A\u000f \n\u0005}Z#!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n9\u0001K]8ek\u000e$\bCA$P\u001d\tAUJ\u0004\u0002J\u00196\t!J\u0003\u0002Lo\u00051AH]8pizJ\u0011aQ\u0005\u0003\u001d\n\u000bq\u0001]1dW\u0006<W-\u0003\u0002Q#\na1+\u001a:jC2L'0\u00192mK*\u0011aJQ\u0001\u0005i\u0016DH/F\u0001U!\tQT+\u0003\u0002WW\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000bQ,\u0007\u0010\u001e\u0011\u0002\u0013A\f\u0017N\u001d#fY&l\u0017A\u00039bSJ$U\r\\5nA\u0005i1.Z=WC2,X\rR3mS6\fab[3z-\u0006dW/\u001a#fY&l\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005=~\u0003\u0017\r\u0005\u0002;\u0001!)!k\u0002a\u0001)\")\u0001l\u0002a\u0001)\")!l\u0002a\u0001)\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#\u00013\u0011\u0005\u0005+\u0017B\u00014C\u0005\u001d\u0011un\u001c7fC:$2A\u00185k\u0011\u0015I\u0017\u00021\u0001U\u0003\u0015\u0019\u0007.\u001b7e\u0011\u0015A\u0016\u00021\u0001U)\tqF\u000eC\u0003j\u0015\u0001\u0007A+\u0001\u0005ti\u0006$XMZ;m\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003M\u00042a\u0012;w\u0013\t)\u0018KA\u0002TKF\u0004\"a\u001e>\u000e\u0003aT!!_\u0018\u0002\u000bQL\b/Z:\n\u0005mD(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#\u0001@\u0011\u0005]|\u0018bAA\u0001q\nAA)\u0019;b)f\u0004X-\u0001\u0006nCB\u0014U/\u001b7eKJ,\"!a\u0002\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004.\u0003\u0011)H/\u001b7\n\t\u0005E\u00111\u0002\u0002\u0015\u0003J\u0014\u0018-\u001f\"bg\u0016$W*\u00199Ck&dG-\u001a:\u0002\u0017\r|G\u000e\\1uS>t\u0017\nZ\u000b\u0003\u0003/\u00012!QA\r\u0013\r\tYB\u0011\u0002\u0004\u0013:$\u0018a\u00057fO\u0006\u001c\u0017p\u00159mSR$&/\u001e8dCR,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003CA\u0012\u0003S\ti#!\r\u0011\u0007\u0005\u000b)#C\u0002\u0002(\t\u00131!\u00118z\u0011\u001d\tY\u0003\u0006a\u0001\u0003G\t1\"\u001b8qkR\u001cFO]5oO\"9\u0011q\u0006\u000bA\u0002\u0005\r\u0012aD:ue&tw\rR3mS6LG/\u001a:\t\u000f\u0005MB\u00031\u0001\u0002$\u0005\t2.Z=WC2,X\rR3mS6LG/\u001a:\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u001d\u0003\u000b\ny\u0005\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\tydK\u0001\bG>$WmZ3o\u0013\u0011\t\u0019%!\u0010\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0012\u0016\u0001\u0004\tI%A\u0002dib\u0004B!a\u000f\u0002L%!\u0011QJA\u001f\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u0015\u0016\u0001\u0004\tI$\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005]\u0003\u0003BA-\u0003CrA!a\u0017\u0002^A\u0011\u0011JQ\u0005\u0004\u0003?\u0012\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002d\u0005\u0015$AB*ue&twMC\u0002\u0002`\t\u000bqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000fQ\u000bY'a\u001c\u0002t!1\u0011QN\fA\u0002Q\u000b\u0001B\\3x\r&\u00148\u000f\u001e\u0005\u0007\u0003c:\u0002\u0019\u0001+\u0002\u00139,woU3d_:$\u0007BBA;/\u0001\u0007A+\u0001\u0005oK^$\u0006.\u001b:e\u0003\u0011\u0019w\u000e]=\u0015\u000fy\u000bY(! \u0002\u0000!9!\u000b\u0007I\u0001\u0002\u0004!\u0006b\u0002-\u0019!\u0003\u0005\r\u0001\u0016\u0005\b5b\u0001\n\u00111\u0001U\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\"+\u0007Q\u000b9i\u000b\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015!C;oG\",7m[3e\u0015\r\t\u0019JQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAL\u0003\u001b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003C\u0003B!a)\u0002.6\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000bI+\u0001\u0003mC:<'BAAV\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0014QU\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019#!.\t\u0013\u0005]f$!AA\u0002\u0005]\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002>B1\u0011qXAc\u0003Gi!!!1\u000b\u0007\u0005\r')\u0001\u0006d_2dWm\u0019;j_:LA!a2\u0002B\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r!\u0017Q\u001a\u0005\n\u0003o\u0003\u0013\u0011!a\u0001\u0003G\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011UAj\u0011%\t9,IA\u0001\u0002\u0004\t9\"\u0001\u0004fcV\fGn\u001d\u000b\u0004I\u0006e\u0007\"CA\\E\u0005\u0005\t\u0019AA\u0012QM\u0001\u0011Q\\Ar\u0003K\fI/a;\u0002p\u0006E\u0018Q_A|!\rQ\u0014q\\\u0005\u0004\u0003C\\#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003O\f!qC0G+:\u001bu\f\u000b;fqR\\F\u0006\t9bSJ$U\r\\5n72\u00023.Z=WC2,X\rR3mS6lV,\u000b\u0011.A\r\u0013X-\u0019;fg\u0002\n\u0007%\\1qA\u00054G/\u001a:!gBd\u0017\u000e\u001e;j]\u001e\u0004C\u000f[3!i\u0016DH\u000fI5oi>\u00043.Z=0m\u0006dW/\u001a\u0011qC&\u00148\u000fI;tS:<\u0007\u0005Z3mS6LG/\u001a:t]\u0001\"UMZ1vYR\u0004C-\u001a7j[&$XM]:!CJ,\u0007e\n\u0017(A\u0019|'\u000f\t1qC&\u0014H)\u001a7j[\u0002\u0004\u0013M\u001c3!Oi:\u0003EZ8sA\u0001\\W-\u001f,bYV,G)\u001a7j[\u0002t\u0003EQ8uQ\u0002\u0002\u0007/Y5s\t\u0016d\u0017.\u001c1!C:$\u0007\u0005Y6fsZ\u000bG.^3EK2LW\u000e\u0019\u0011be\u0016\u0004CO]3bi\u0016$\u0007%Y:!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gn\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!<\u0002\u0003CQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ1;c1\u0012'H\r\u0017duM:C\u0006I\u0014-O1\u0002sEO\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;EE\u0012CF\t2#u\t\u0012$\u0005\f\u0012dEi\u00123GI?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\nw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\n'E\u000f8vY2l(\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005M\u0018!\u0002\u001a/a9\n\u0014!B4s_V\u0004\u0018EAA}\u0003%i\u0017\r]0gk:\u001c7/A\u0006TiJLgn\u001a+p\u001b\u0006\u0004\bC\u0001\u001e%'\u0015!#\u0011\u0001B\u0007!!\u0011\u0019A!\u0003U)RsVB\u0001B\u0003\u0015\r\u00119AQ\u0001\beVtG/[7f\u0013\u0011\u0011YA!\u0002\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0003\u0010\tUQB\u0001B\t\u0015\u0011\u0011\u0019\"!+\u0002\u0005%|\u0017b\u0001)\u0003\u0012Q\u0011\u0011Q`\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011U\u0001\u0006CB\u0004H.\u001f\u000b\b=\n\u0005\"1\u0005B\u0013\u0011\u0015\u0011v\u00051\u0001U\u0011\u0015Av\u00051\u0001U\u0011\u0015Qv\u00051\u0001U\u0003\u001d)h.\u00199qYf$BAa\u000b\u00038A)\u0011I!\f\u00032%\u0019!q\u0006\"\u0003\r=\u0003H/[8o!\u0019\t%1\u0007+U)&\u0019!Q\u0007\"\u0003\rQ+\b\u000f\\34\u0011!\u0011I\u0004KA\u0001\u0002\u0004q\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\b\t\u0005\u0003G\u0013\t%\u0003\u0003\u0003D\u0005\u0015&AB(cU\u0016\u001cG\u000f")
public class StringToMap
extends TernaryExpression
implements ExpectsInputTypes,
Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private int collationId;
    private boolean legacySplitTruncate;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap x$0) {
        return StringToMap$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Expression first() {
        return this.text();
    }

    @Override
    public Expression second() {
        return this.pairDelim();
    }

    @Override
    public Expression third() {
        return this.keyValueDelim();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$, (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$, (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(this.first().dataType(), this.first().dataType());
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.first().dataType(), this.first().dataType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.mapBuilder$lzycompute();
        }
        return this.mapBuilder;
    }

    private int collationId$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.collationId = ((StringType)this.text().dataType()).collationId();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.collationId;
    }

    private final int collationId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    private boolean legacySplitTruncate$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.legacySplitTruncate = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_TRUNCATE_FOR_EMPTY_REGEX_SPLIT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.legacySplitTruncate;
    }

    private boolean legacySplitTruncate() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.legacySplitTruncate$lzycompute();
        }
        return this.legacySplitTruncate;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = CollationAwareUTF8String.splitSQL((UTF8String)((UTF8String)inputString), (UTF8String)((UTF8String)stringDelimiter), (int)-1, (int)this.collationId(), (boolean)this.legacySplitTruncate());
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = CollationAwareUTF8String.splitSQL((UTF8String)keyValues[i], (UTF8String)keyValueDelimiterUTF8String, (int)2, (int)this.collationId(), (boolean)this.legacySplitTruncate());
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        String keyValues = ctx.freshName("kvs");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(text, pd, kvd) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |UTF8String[] " + keyValues + " =\n         |  CollationAwareUTF8String.splitSQL(" + text + ", " + pd + ", -1, " + this.collationId() + ", " + this.legacySplitTruncate() + ");\n         |for(UTF8String kvEntry: " + keyValues + ") {\n         |  UTF8String[] kv = CollationAwareUTF8String.splitSQL(\n         |    kvEntry, " + kvd + ", 2, " + this.collationId() + ", " + this.legacySplitTruncate() + ");\n         |  " + builderTerm + ".put(kv[0], kv.length == 2 ? kv[1] : null);\n         |}\n         |" + ev.value() + " = " + builderTerm + ".build();\n         |")));
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.text();
            }
            case 1: {
                return this.pairDelim();
            }
            case 2: {
                return this.keyValueDelim();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "text";
            }
            case 1: {
                return "pairDelim";
            }
            case 2: {
                return "keyValueDelim";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.create(":", (DataType)StringType$.MODULE$));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.create(",", (DataType)StringType$.MODULE$), Literal$.MODULE$.create(":", (DataType)StringType$.MODULE$));
    }
}

