/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.distribution;

import breeze.generic.UFunc;
import breeze.gymnastics.NotGiven$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.linalg.eigSym;
import breeze.linalg.eigSym$;
import breeze.linalg.max$;
import breeze.linalg.operators.HasOps$;
import breeze.storage.Zero$;
import java.io.Serializable;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001\u0002\t\u0012\u0001yA\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005g!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015a\u0005\u0001\"\u0001N\u0011!)\u0006\u0001#b\u0001\n\u00131\u0006B\u0002'\u0001\t\u0003)R\r\u0003\u0005l\u0001!\u0015\r\u0011\"\u0003m\u0011!\t\b\u0001#b\u0001\n\u0013\u0011\b\u0002\u0003;\u0001\u0011\u000b\u0007I\u0011B;\t\u000b]\u0004A\u0011\u0001=\t\u000bq\u0004A\u0011A?\t\u000f]\u0004A\u0011A\u000b\u0002\u0002!9A\u0010\u0001C\u0001+\u0005%\u0001BBA\u0007\u0001\u0011%AN\u0001\u000bNk2$\u0018N^1sS\u0006$XmR1vgNL\u0017M\u001c\u0006\u0003%M\tA\u0002Z5tiJL'-\u001e;j_:T!\u0001F\u000b\u0002\tM$\u0018\r\u001e\u0006\u0003-]\tQ!\u001c7mS\nT!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019rcBA\u0014-\u001d\tA3&D\u0001*\u0015\tQS$\u0001\u0004=e>|GOP\u0005\u0002E%\u0011Q&I\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0003G\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002.C\u0005\u0011Q.^\u000b\u0002gA\u0011AgN\u0007\u0002k)\u0011a'F\u0001\u0007Y&t\u0017\r\\4\n\u0005a*$A\u0002,fGR|'\u000fK\u0002\u0002u\u0001\u0003\"a\u000f \u000e\u0003qR!!P\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002@y\t)1+\u001b8dK\u0006\n\u0011)A\u00032]Mr\u0003'A\u0002nk\u0002B3A\u0001\u001eA\u0003\u0015\u0019\u0018nZ7b+\u00051\u0005C\u0001\u001bH\u0013\tAUG\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0015\u0004\u0007i\u0002\u0015AB:jO6\f\u0007\u0005K\u0002\u0005u\u0001\u000ba\u0001P5oSRtDc\u0001(Q%B\u0011q\nA\u0007\u0002#!)\u0011'\u0002a\u0001g!\u001a\u0001K\u000f!\t\u000b\u0011+\u0001\u0019\u0001$)\u0007IS\u0004\tK\u0002\u0006u\u0001\u000b\u0001B\u0019:fKj,W*^\u000b\u0002/B\u0019\u0001\f\u00180\u000e\u0003eS!A\u000e.\u000b\u0003m\u000baA\u0019:fKj,\u0017BA/Z\u0005-!UM\\:f-\u0016\u001cGo\u001c:\u0011\u0005\u0001z\u0016B\u00011\"\u0005\u0019!u.\u001e2mK\"\u0012aA\u0019\t\u0003A\rL!\u0001Z\u0011\u0003\u0013Q\u0014\u0018M\\:jK:$Hc\u0001(gO\")\u0011g\u0002a\u0001/\")Ai\u0002a\u0001QB\u0019\u0001,\u001b0\n\u0005)L&a\u0003#f]N,W*\u0019;sSb\fQ\u0001^;qY\u0016,\u0012!\u001c\t\u0005A9Dg,\u0003\u0002pC\t1A+\u001e9mKJB#\u0001\u00032\u0002\u0019I|w\u000e^*jO6\f\u0017J\u001c<\u0016\u0003!D#!\u00032\u0002\u0003U,\u0012A\u0018\u0015\u0003\u0015\t\f1\u0001\u001d3g)\tq\u0016\u0010C\u0003{\u0017\u0001\u00071'A\u0001yQ\rY!\bQ\u0001\u0007Y><\u0007\u000f\u001a4\u0015\u0005ys\b\"\u0002>\r\u0001\u0004\u0019\u0004f\u0001\u0007;\u0001R\u0019a,a\u0001\t\ril\u0001\u0019AA\u0003!\u0011A\u0016q\u00010\n\u0005aJFc\u00010\u0002\f!1!P\u0004a\u0001\u0003\u000b\tAdY1mGVd\u0017\r^3D_Z\f'/[1oG\u0016\u001cuN\\:uC:$8\u000fK\u0002\u0001u\u0001\u0003")
public class MultivariateGaussian
implements Serializable {
    private transient DenseVector<Object> breezeMu;
    private transient Tuple2<DenseMatrix<Object>, Object> tuple;
    private transient DenseMatrix<Object> rootSigmaInv;
    private transient double u;
    private final Vector mu;
    private final org.apache.spark.mllib.linalg.Matrix sigma;
    private volatile transient byte bitmap$trans$0;

    public Vector mu() {
        return this.mu;
    }

    public org.apache.spark.mllib.linalg.Matrix sigma() {
        return this.sigma;
    }

    private DenseVector<Object> breezeMu$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.breezeMu = this.mu().asBreeze().toDenseVector$mcD$sp((ClassTag)ClassTag$.MODULE$.Double());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.breezeMu;
    }

    private DenseVector<Object> breezeMu() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.breezeMu$lzycompute();
        }
        return this.breezeMu;
    }

    private Tuple2<DenseMatrix<Object>, Object> tuple$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.tuple = this.calculateCovarianceConstants();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.tuple;
    }

    private Tuple2<DenseMatrix<Object>, Object> tuple() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.tuple$lzycompute();
        }
        return this.tuple;
    }

    private DenseMatrix<Object> rootSigmaInv$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.rootSigmaInv = (DenseMatrix)this.tuple()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.rootSigmaInv;
    }

    private DenseMatrix<Object> rootSigmaInv() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.rootSigmaInv$lzycompute();
        }
        return this.rootSigmaInv;
    }

    private double u$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.u = this.tuple()._2$mcD$sp();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.u;
    }

    private double u() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.u$lzycompute();
        }
        return this.u;
    }

    public double pdf(Vector x) {
        return this.pdf(x.asBreeze());
    }

    public double logpdf(Vector x) {
        return this.logpdf(x.asBreeze());
    }

    public double pdf(breeze.linalg.Vector<Object> x) {
        return package$.MODULE$.exp(this.logpdf(x));
    }

    public double logpdf(breeze.linalg.Vector<Object> x) {
        breeze.linalg.Vector delta = (breeze.linalg.Vector)x.$minus(this.breezeMu(), HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.castUpdateOps_V_V((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.neq(), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_V_V_Idempotent_Double_OpSub()), Vector$.MODULE$.canCopy()));
        DenseVector v = (DenseVector)this.rootSigmaInv().$times((Object)delta, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DM_V_eq_DV_Double());
        return this.u() + BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)v.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()))).$times((Object)v, HasOps$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)HasOps$.MODULE$.canDotD()))) * -0.5;
    }

    private Tuple2<DenseMatrix<Object>, Object> calculateCovarianceConstants() {
        Tuple2 tuple2;
        eigSym.EigSym eigSym2 = (eigSym.EigSym)eigSym$.MODULE$.apply((Object)this.sigma().asBreeze().toDenseMatrix$mcD$sp((ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()), (UFunc.UImpl)eigSym.EigSym_DM_Impl$.MODULE$);
        if (eigSym2 == null) {
            throw new MatchError((Object)eigSym2);
        }
        DenseVector d = (DenseVector)eigSym2.eigenvalues();
        DenseMatrix u = (DenseMatrix)eigSym2.eigenvectors();
        Tuple2 tuple22 = new Tuple2((Object)d, (Object)u);
        DenseVector d2 = (DenseVector)tuple22._1();
        DenseMatrix u2 = (DenseMatrix)tuple22._2();
        double tol = MLUtils$.MODULE$.EPSILON() * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)d2, max$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))) * (double)d2.length();
        try {
            double logPseudoDetSigma = BoxesRunTime.unboxToDouble((Object)d2.activeValuesIterator().filter((Function1)(JFunction1.mcZD.sp & Serializable)x$2 -> x$2 > tol).map((Function1)(JFunction1.mcDD.sp & Serializable)x -> package$.MODULE$.log(x)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DenseMatrix pinvS = (DenseMatrix)diag$.MODULE$.apply((Object)new DenseVector.mcD.sp(((DenseVector)d2.map$mcD$sp((Function1)(JFunction1.mcDD.sp & Serializable)v -> {
                if (v > tol) {
                    return package$.MODULE$.sqrt(1.0 / v);
                }
                return 0.0;
            }, DenseVector$.MODULE$.DV_canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double()))).toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double())), diag$.MODULE$.diagDVDMImpl((ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()));
            tuple2 = new Tuple2(pinvS.$times(u2.t(HasOps$.MODULE$.canTranspose_DM()), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)(-0.5 * ((double)this.mu().size() * package$.MODULE$.log(Math.PI * 2) + logPseudoDetSigma))));
        }
        catch (UnsupportedOperationException uex) {
            throw new IllegalArgumentException("Covariance matrix has no non-zero singular values");
        }
        return tuple2;
    }

    public MultivariateGaussian(Vector mu, org.apache.spark.mllib.linalg.Matrix sigma) {
        this.mu = mu;
        this.sigma = sigma;
        Predef$.MODULE$.require(sigma.numCols() == sigma.numRows(), (Function0 & Serializable)() -> "Covariance matrix must be square");
        Predef$.MODULE$.require(mu.size() == sigma.numCols(), (Function0 & Serializable)() -> "Mean vector length must match covariance matrix size");
    }

    public MultivariateGaussian(DenseVector<Object> mu, DenseMatrix<Object> sigma) {
        this(Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mu), Matrices$.MODULE$.fromBreeze((Matrix<Object>)sigma));
    }
}

