/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.AdminAsynchronousProtocol;
import org.apache.ratis.protocol.AdminProtocol;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientProtocol;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.server.DataStreamMap;
import org.apache.ratis.server.DataStreamServerRpc;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.DivisionProperties;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.RetryCache;
import org.apache.ratis.server.ServerFactory;
import org.apache.ratis.server.metrics.RaftServerMetrics;
import org.apache.ratis.server.protocol.RaftServerAsynchronousProtocol;
import org.apache.ratis.server.protocol.RaftServerProtocol;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.thirdparty.com.google.common.collect.Iterables;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftServer
extends Closeable,
RpcType.Get,
RaftServerProtocol,
RaftServerAsynchronousProtocol,
RaftClientProtocol,
RaftClientAsynchronousProtocol,
AdminProtocol,
AdminAsynchronousProtocol {
    public static final Logger LOG = LoggerFactory.getLogger(RaftServer.class);

    public RaftPeerId getId();

    public RaftPeer getPeer();

    public Iterable<RaftGroupId> getGroupIds();

    public Iterable<RaftGroup> getGroups() throws IOException;

    public Division getDivision(RaftGroupId var1) throws IOException;

    public RaftProperties getProperties();

    public RaftServerRpc getServerRpc();

    public DataStreamServerRpc getDataStreamServerRpc();

    @Override
    default public RpcType getRpcType() {
        return this.getFactory().getRpcType();
    }

    public ServerFactory getFactory();

    public void start() throws IOException;

    public LifeCycle.State getLifeCycleState();

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private static final Method NEW_RAFT_SERVER_METHOD = Builder.initNewRaftServerMethod();
        private RaftPeerId serverId;
        private StateMachine.Registry stateMachineRegistry;
        private RaftGroup group = null;
        private RaftStorage.StartupOption option = RaftStorage.StartupOption.FORMAT;
        private RaftProperties properties;
        private Parameters parameters;
        private ThreadGroup threadGroup;

        private static Method initNewRaftServerMethod() {
            String className = RaftServer.class.getPackage().getName() + ".impl.ServerImplUtils";
            Class[] argClasses = new Class[]{RaftPeerId.class, RaftGroup.class, RaftStorage.StartupOption.class, StateMachine.Registry.class, ThreadGroup.class, RaftProperties.class, Parameters.class};
            try {
                Class<?> clazz = ReflectionUtils.getClassByName(className);
                return clazz.getMethod("newRaftServer", argClasses);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to initNewRaftServerMethod", e);
            }
        }

        private static RaftServer newRaftServer(RaftPeerId serverId, RaftGroup group, RaftStorage.StartupOption option, StateMachine.Registry stateMachineRegistry, ThreadGroup threadGroup, RaftProperties properties, Parameters parameters) throws IOException {
            try {
                return (RaftServer)NEW_RAFT_SERVER_METHOD.invoke(null, new Object[]{serverId, group, option, stateMachineRegistry, threadGroup, properties, parameters});
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to build " + serverId, e);
            }
            catch (InvocationTargetException e) {
                throw IOUtils.asIOException(e.getCause());
            }
        }

        public RaftServer build() throws IOException {
            return Builder.newRaftServer(this.serverId, this.group, this.option, Objects.requireNonNull(this.stateMachineRegistry, "Neither 'stateMachine' nor 'setStateMachineRegistry' is initialized."), this.threadGroup, Objects.requireNonNull(this.properties, "The 'properties' field is not initialized."), this.parameters);
        }

        public Builder setServerId(RaftPeerId serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder setStateMachine(StateMachine stateMachine) {
            return this.setStateMachineRegistry(gid -> stateMachine);
        }

        public Builder setStateMachineRegistry(StateMachine.Registry stateMachineRegistry) {
            this.stateMachineRegistry = stateMachineRegistry;
            return this;
        }

        public Builder setGroup(RaftGroup group) {
            this.group = group;
            return this;
        }

        public Builder setOption(RaftStorage.StartupOption option) {
            this.option = option;
            return this;
        }

        public Builder setProperties(RaftProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder setParameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setThreadGroup(ThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
            return this;
        }
    }

    public static interface Division
    extends Closeable {
        public static final Logger LOG = LoggerFactory.getLogger(Division.class);

        public DivisionProperties properties();

        public RaftGroupMemberId getMemberId();

        default public RaftPeerId getId() {
            return this.getMemberId().getPeerId();
        }

        default public RaftPeer getPeer() {
            return Optional.ofNullable(this.getRaftConf().getPeer(this.getId(), RaftProtos.RaftPeerRole.FOLLOWER, RaftProtos.RaftPeerRole.LISTENER)).orElseGet(() -> this.getRaftServer().getPeer());
        }

        public DivisionInfo getInfo();

        default public RaftGroup getGroup() {
            Collection<RaftPeer> allFollowerPeers = this.getRaftConf().getAllPeers(RaftProtos.RaftPeerRole.FOLLOWER);
            Collection<RaftPeer> allListenerPeers = this.getRaftConf().getAllPeers(RaftProtos.RaftPeerRole.LISTENER);
            Iterable<RaftPeer> peers = Iterables.concat(allFollowerPeers, allListenerPeers);
            return RaftGroup.valueOf(this.getMemberId().getGroupId(), peers);
        }

        public RaftConfiguration getRaftConf();

        public RaftServer getRaftServer();

        public RaftServerMetrics getRaftServerMetrics();

        public StateMachine getStateMachine();

        public RaftLog getRaftLog();

        public RaftStorage getRaftStorage();

        public Collection<RaftProtos.CommitInfoProto> getCommitInfos();

        public RetryCache getRetryCache();

        public DataStreamMap getDataStreamMap();

        public ThreadGroup getThreadGroup();

        @Override
        public void close();
    }
}

