/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.servlet.rest.QueryServlet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;

public class BrokerQueryServlet
extends QueryServlet<Broker<?>> {
    private static final long serialVersionUID = 1L;

    @Override
    protected Broker<?> getParent(HttpServletRequest request, ConfiguredObject<?> managedObject) {
        return managedObject instanceof Broker ? HttpManagementUtil.getBroker(request.getServletContext()) : null;
    }

    @Override
    protected Class<? extends ConfiguredObject> getSupportedCategory(String categoryName, Model brokerModel) {
        Class category = null;
        for (Class supportedCategory : brokerModel.getSupportedCategories()) {
            if (!categoryName.equalsIgnoreCase(supportedCategory.getSimpleName())) continue;
            category = supportedCategory;
            break;
        }
        return category;
    }

    @Override
    protected String getRequestedCategory(HttpServletRequest request, ConfiguredObject<?> managedObject) {
        List<String> pathInfoElements = HttpManagementUtil.getPathInfoElements(request.getServletPath(), request.getPathInfo());
        if (pathInfoElements.size() == 1) {
            return pathInfoElements.get(0);
        }
        return null;
    }

    @Override
    protected List<ConfiguredObject<?>> getAllObjects(Broker<?> broker, Class<? extends ConfiguredObject> category, HttpServletRequest request) {
        if (category == Broker.class) {
            return List.of(broker);
        }
        Model brokerModel = broker.getModel();
        ArrayList<Class> hierarchy = new ArrayList<Class>();
        Class element = category;
        while (element != null && element != Broker.class) {
            hierarchy.add(element);
            Class parentType = brokerModel.getParentType(element);
            if (parentType == null) break;
            element = parentType;
        }
        Collections.reverse(hierarchy);
        Collection<Object> parents = List.of(broker);
        Collection children = List.of();
        for (Class childClass : hierarchy) {
            children = new HashSet();
            for (ConfiguredObject configuredObject : parents) {
                children.addAll(configuredObject.getChildren(childClass));
            }
            parents = children;
        }
        return new ArrayList(children);
    }
}

