/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.typedmessage.mimecontentconverter;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentToObjectConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.typedmessage.TypedBytesContentReader;
import org.apache.qpid.server.typedmessage.TypedBytesFormatException;

@PluggableService
public class JmsStreamMessageToList
implements MimeContentToObjectConverter<List> {
    @Override
    public String getType() {
        return this.getMimeType();
    }

    @Override
    public Class<List> getObjectClass() {
        return List.class;
    }

    @Override
    public String getMimeType() {
        return "jms/stream-message";
    }

    @Override
    public List toObject(byte[] data) {
        if (data == null || data.length == 0) {
            return Collections.emptyList();
        }
        TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.remaining() != 0) {
            try {
                list.add(reader.readObject());
            }
            catch (EOFException | TypedBytesFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return list;
    }
}

