/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.LinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.type.BaseSource;
import org.apache.qpid.server.protocol.v1_0.type.BaseTarget;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.transaction.TransactionalState;
import org.apache.qpid.server.protocol.v1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;

public class Delivery {
    private final UnsignedInteger _deliveryId;
    private final Binary _deliveryTag;
    private final List<Transfer> _transfers = new CopyOnWriteArrayList<Transfer>();
    private final LinkEndpoint<? extends BaseSource, ? extends BaseTarget> _linkEndpoint;
    private final UnsignedInteger _messageFormat;
    private volatile boolean _complete;
    private volatile boolean _settled;
    private volatile boolean _aborted;
    private volatile DeliveryState _state;
    private volatile ReceiverSettleMode _receiverSettleMode;
    private volatile boolean _resume;
    private volatile long _totalPayloadSize = 0L;

    public Delivery(Transfer transfer, LinkEndpoint<? extends BaseSource, ? extends BaseTarget> endpoint) {
        this._deliveryId = transfer.getDeliveryId();
        this._deliveryTag = transfer.getDeliveryTag();
        this._linkEndpoint = endpoint;
        this._messageFormat = transfer.getMessageFormat() != null ? transfer.getMessageFormat() : UnsignedInteger.ZERO;
        this.addTransfer(transfer);
    }

    public UnsignedInteger getDeliveryId() {
        return this._deliveryId;
    }

    public Binary getDeliveryTag() {
        return this._deliveryTag;
    }

    public boolean isComplete() {
        return this._complete;
    }

    public boolean isSettled() {
        return this._settled;
    }

    public boolean isAborted() {
        return this._aborted;
    }

    public DeliveryState getState() {
        return this._state;
    }

    public ReceiverSettleMode getReceiverSettleMode() {
        return this._receiverSettleMode;
    }

    public UnsignedInteger getMessageFormat() {
        return this._messageFormat;
    }

    public boolean getResume() {
        return this._resume;
    }

    public long getTotalPayloadSize() {
        return this._totalPayloadSize;
    }

    final void addTransfer(Transfer transfer) {
        DeliveryState currentState;
        if (this._aborted) {
            throw new IllegalStateException(String.format("Delivery '%s/%d' is already aborted", this._deliveryTag, this._deliveryId.intValue()));
        }
        if (this._complete) {
            throw new IllegalStateException(String.format("Delivery '%s/%d' is already completed", this._deliveryTag, this._deliveryId.intValue()));
        }
        this._transfers.add(transfer);
        if (Boolean.TRUE.equals(transfer.getAborted())) {
            this._aborted = true;
            this.discard();
        }
        if (!Boolean.TRUE.equals(transfer.getMore())) {
            this._complete = true;
        }
        if (Boolean.TRUE.equals(transfer.getSettled())) {
            this._settled = true;
        }
        if (Boolean.TRUE.equals(transfer.getResume())) {
            this._resume = true;
        }
        if (transfer.getState() != null && !((currentState = this._state instanceof TransactionalState ? ((TransactionalState)this._state).getOutcome() : this._state) instanceof Outcome)) {
            this._state = transfer.getState();
        }
        if (transfer.getRcvSettleMode() != null && this._receiverSettleMode == null) {
            this._receiverSettleMode = transfer.getRcvSettleMode();
        }
        try (QpidByteBuffer payload = transfer.getPayload();){
            if (payload != null) {
                this._totalPayloadSize += (long)payload.remaining();
            }
        }
    }

    public LinkEndpoint<? extends BaseSource, ? extends BaseTarget> getLinkEndpoint() {
        return this._linkEndpoint;
    }

    public QpidByteBuffer getPayload() {
        ArrayList<QpidByteBuffer> transferBuffers = new ArrayList<QpidByteBuffer>(this._transfers.size());
        for (Transfer t : this._transfers) {
            QpidByteBuffer payload = t.getPayload();
            if (payload != null) {
                transferBuffers.add(payload);
            }
            t.dispose();
        }
        this._transfers.clear();
        QpidByteBuffer combined = QpidByteBuffer.concatenate(transferBuffers);
        transferBuffers.forEach(QpidByteBuffer::dispose);
        return combined;
    }

    public void discard() {
        for (Transfer transfer : this._transfers) {
            transfer.dispose();
        }
        this._transfers.clear();
    }
}

