/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.client.Collector;
import io.prometheus.client.Counter;
import io.prometheus.jmx.JmxMBeanPropertyCache;
import io.prometheus.jmx.JmxScraper;
import io.prometheus.jmx.MatchedRule;
import io.prometheus.jmx.MatchedRulesCache;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.yaml.snakeyaml.Yaml;

public class JmxCollector
extends Collector
implements Collector.Describable {
    static final Counter configReloadSuccess = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("jmx_config_reload_success_total")).help("Number of times configuration have successfully been reloaded.")).register();
    static final Counter configReloadFailure = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("jmx_config_reload_failure_total")).help("Number of times configuration have failed to be reloaded.")).register();
    private static final Logger LOGGER = Logger.getLogger(JmxCollector.class.getName());
    private Config config;
    private File configFile;
    private long createTimeNanoSecs = System.nanoTime();
    private final JmxMBeanPropertyCache jmxMBeanPropertyCache = new JmxMBeanPropertyCache();

    public JmxCollector(File in) throws IOException, MalformedObjectNameException {
        this.configFile = in;
        this.config = this.loadConfig((Map)new Yaml().load((Reader)new FileReader(in)));
        this.config.lastUpdate = this.configFile.lastModified();
    }

    public JmxCollector(String yamlConfig) throws MalformedObjectNameException {
        this.config = this.loadConfig((Map)new Yaml().load(yamlConfig));
    }

    public JmxCollector(InputStream inputStream) throws MalformedObjectNameException {
        this.config = this.loadConfig((Map)new Yaml().load(inputStream));
    }

    private void reloadConfig() {
        try {
            FileReader fr = new FileReader(this.configFile);
            try {
                Map newYamlConfig = (Map)new Yaml().load((Reader)fr);
                this.config = this.loadConfig(newYamlConfig);
                this.config.lastUpdate = this.configFile.lastModified();
                configReloadSuccess.inc();
            }
            catch (Exception e) {
                LOGGER.severe("Configuration reload failed: " + e.toString());
                configReloadFailure.inc();
            }
            finally {
                fr.close();
            }
        }
        catch (IOException e) {
            LOGGER.severe("Configuration reload failed: " + e.toString());
            configReloadFailure.inc();
        }
    }

    private synchronized Config getLatestConfig() {
        long mtime;
        if (this.configFile != null && (mtime = this.configFile.lastModified()) > this.config.lastUpdate) {
            LOGGER.fine("Configuration file changed, reloading...");
            this.reloadConfig();
        }
        return this.config;
    }

    private Config loadConfig(Map<String, Object> yamlConfig) throws MalformedObjectNameException {
        List names;
        Config cfg = new Config();
        if (yamlConfig == null) {
            yamlConfig = new HashMap<String, Object>();
        }
        if (yamlConfig.containsKey("startDelaySeconds")) {
            try {
                cfg.startDelaySeconds = (Integer)yamlConfig.get("startDelaySeconds");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid number provided for startDelaySeconds", e);
            }
        }
        if (yamlConfig.containsKey("hostPort")) {
            if (yamlConfig.containsKey("jmxUrl")) {
                throw new IllegalArgumentException("At most one of hostPort and jmxUrl must be provided");
            }
            cfg.jmxUrl = "service:jmx:rmi:///jndi/rmi://" + (String)yamlConfig.get("hostPort") + "/jmxrmi";
        } else if (yamlConfig.containsKey("jmxUrl")) {
            cfg.jmxUrl = (String)yamlConfig.get("jmxUrl");
        }
        if (yamlConfig.containsKey("username")) {
            cfg.username = (String)yamlConfig.get("username");
        }
        if (yamlConfig.containsKey("password")) {
            cfg.password = (String)yamlConfig.get("password");
        }
        if (yamlConfig.containsKey("ssl")) {
            cfg.ssl = (Boolean)yamlConfig.get("ssl");
        }
        if (yamlConfig.containsKey("lowercaseOutputName")) {
            cfg.lowercaseOutputName = (Boolean)yamlConfig.get("lowercaseOutputName");
        }
        if (yamlConfig.containsKey("lowercaseOutputLabelNames")) {
            cfg.lowercaseOutputLabelNames = (Boolean)yamlConfig.get("lowercaseOutputLabelNames");
        }
        if (yamlConfig.containsKey("whitelistObjectNames")) {
            names = (List)yamlConfig.get("whitelistObjectNames");
            for (Object name : names) {
                cfg.whitelistObjectNames.add(new ObjectName((String)name));
            }
        } else {
            cfg.whitelistObjectNames.add(null);
        }
        if (yamlConfig.containsKey("blacklistObjectNames")) {
            names = (List)yamlConfig.get("blacklistObjectNames");
            for (Object name : names) {
                cfg.blacklistObjectNames.add(new ObjectName((String)name));
            }
        }
        if (yamlConfig.containsKey("rules")) {
            List configRules = (List)yamlConfig.get("rules");
            Iterator iterator = configRules.iterator();
            while (iterator.hasNext()) {
                Map ruleObject;
                Map yamlRule = ruleObject = (Map)iterator.next();
                Rule rule = new Rule();
                cfg.rules.add(rule);
                if (yamlRule.containsKey("pattern")) {
                    rule.pattern = Pattern.compile("^.*(?:" + (String)yamlRule.get("pattern") + ").*$");
                }
                if (yamlRule.containsKey("name")) {
                    rule.name = (String)yamlRule.get("name");
                }
                if (yamlRule.containsKey("value")) {
                    rule.value = String.valueOf(yamlRule.get("value"));
                }
                if (yamlRule.containsKey("valueFactor")) {
                    String valueFactor = String.valueOf(yamlRule.get("valueFactor"));
                    try {
                        rule.valueFactor = Double.valueOf(valueFactor);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (yamlRule.containsKey("attrNameSnakeCase")) {
                    rule.attrNameSnakeCase = (Boolean)yamlRule.get("attrNameSnakeCase");
                }
                if (yamlRule.containsKey("cache")) {
                    rule.cache = (Boolean)yamlRule.get("cache");
                }
                if (yamlRule.containsKey("type")) {
                    String t = (String)yamlRule.get("type");
                    if ("UNTYPED".equals(t)) {
                        t = "UNKNOWN";
                    }
                    rule.type = Collector.Type.valueOf((String)t);
                }
                if (yamlRule.containsKey("help")) {
                    rule.help = (String)yamlRule.get("help");
                }
                if (yamlRule.containsKey("labels")) {
                    TreeMap labels = new TreeMap((Map)yamlRule.get("labels"));
                    rule.labelNames = new ArrayList();
                    rule.labelValues = new ArrayList();
                    for (Map.Entry entry : labels.entrySet()) {
                        rule.labelNames.add((String)entry.getKey());
                        rule.labelValues.add((String)entry.getValue());
                    }
                }
                if ((rule.labelNames != null || rule.help != null) && rule.name == null) {
                    throw new IllegalArgumentException("Must provide name, if help or labels are given: " + yamlRule);
                }
                if (rule.name == null || rule.pattern != null) continue;
                throw new IllegalArgumentException("Must provide pattern, if name is given: " + yamlRule);
            }
        } else {
            cfg.rules.add(new Rule());
        }
        cfg.rulesCache = new MatchedRulesCache(cfg.rules);
        return cfg;
    }

    static String toSnakeAndLowerCase(String attrName) {
        if (attrName == null || attrName.isEmpty()) {
            return attrName;
        }
        char firstChar = attrName.subSequence(0, 1).charAt(0);
        boolean prevCharIsUpperCaseOrUnderscore = Character.isUpperCase(firstChar) || firstChar == '_';
        StringBuilder resultBuilder = new StringBuilder(attrName.length()).append(Character.toLowerCase(firstChar));
        for (char attrChar : attrName.substring(1).toCharArray()) {
            boolean charIsUpperCase = Character.isUpperCase(attrChar);
            if (!prevCharIsUpperCaseOrUnderscore && charIsUpperCase) {
                resultBuilder.append("_");
            }
            resultBuilder.append(Character.toLowerCase(attrChar));
            prevCharIsUpperCaseOrUnderscore = charIsUpperCase || attrChar == '_';
        }
        return resultBuilder.toString();
    }

    static String safeName(String name) {
        if (name == null) {
            return null;
        }
        boolean prevCharIsUnderscore = false;
        StringBuilder safeNameBuilder = new StringBuilder(name.length());
        if (!name.isEmpty() && Character.isDigit(name.charAt(0))) {
            safeNameBuilder.append("_");
        }
        for (char nameChar : name.toCharArray()) {
            boolean isUnsafeChar;
            boolean bl = isUnsafeChar = !JmxCollector.isLegalCharacter(nameChar);
            if (isUnsafeChar || nameChar == '_') {
                if (prevCharIsUnderscore) continue;
                safeNameBuilder.append("_");
                prevCharIsUnderscore = true;
                continue;
            }
            safeNameBuilder.append(nameChar);
            prevCharIsUnderscore = false;
        }
        return safeNameBuilder.toString();
    }

    private static boolean isLegalCharacter(char input) {
        return input == ':' || input == '_' || input >= 'a' && input <= 'z' || input >= 'A' && input <= 'Z' || input >= '0' && input <= '9';
    }

    public List<Collector.MetricFamilySamples> collect() {
        Config config = this.getLatestConfig();
        MatchedRulesCache.StalenessTracker stalenessTracker = new MatchedRulesCache.StalenessTracker();
        Receiver receiver = new Receiver(config, stalenessTracker);
        JmxScraper scraper = new JmxScraper(config.jmxUrl, config.username, config.password, config.ssl, config.whitelistObjectNames, config.blacklistObjectNames, receiver, this.jmxMBeanPropertyCache);
        long start = System.nanoTime();
        double error = 0.0;
        if (config.startDelaySeconds > 0 && (start - this.createTimeNanoSecs) / 1000000000L < (long)config.startDelaySeconds.intValue()) {
            throw new IllegalStateException("JMXCollector waiting for startDelaySeconds");
        }
        try {
            scraper.doScrape();
        }
        catch (Exception e) {
            error = 1.0;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            LOGGER.severe("JMX scrape failed: " + sw.toString());
        }
        config.rulesCache.evictStaleEntries(stalenessTracker);
        ArrayList<Collector.MetricFamilySamples> mfsList = new ArrayList<Collector.MetricFamilySamples>();
        mfsList.addAll(receiver.metricFamilySamplesMap.values());
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        samples.add(new Collector.MetricFamilySamples.Sample("jmx_scrape_duration_seconds", new ArrayList(), new ArrayList(), (double)(System.nanoTime() - start) / 1.0E9));
        mfsList.add(new Collector.MetricFamilySamples("jmx_scrape_duration_seconds", Collector.Type.GAUGE, "Time this JMX scrape took, in seconds.", samples));
        samples = new ArrayList();
        samples.add(new Collector.MetricFamilySamples.Sample("jmx_scrape_error", new ArrayList(), new ArrayList(), error));
        mfsList.add(new Collector.MetricFamilySamples("jmx_scrape_error", Collector.Type.GAUGE, "Non-zero if this scrape failed.", samples));
        samples = new ArrayList();
        samples.add(new Collector.MetricFamilySamples.Sample("jmx_scrape_cached_beans", new ArrayList(), new ArrayList(), (double)stalenessTracker.cachedCount()));
        mfsList.add(new Collector.MetricFamilySamples("jmx_scrape_cached_beans", Collector.Type.GAUGE, "Number of beans with their matching rule cached", samples));
        return mfsList;
    }

    public List<Collector.MetricFamilySamples> describe() {
        ArrayList<Collector.MetricFamilySamples> sampleFamilies = new ArrayList<Collector.MetricFamilySamples>();
        sampleFamilies.add(new Collector.MetricFamilySamples("jmx_scrape_duration_seconds", Collector.Type.GAUGE, "Time this JMX scrape took, in seconds.", new ArrayList()));
        sampleFamilies.add(new Collector.MetricFamilySamples("jmx_scrape_error", Collector.Type.GAUGE, "Non-zero if this scrape failed.", new ArrayList()));
        sampleFamilies.add(new Collector.MetricFamilySamples("jmx_scrape_cached_beans", Collector.Type.GAUGE, "Number of beans with their matching rule cached", new ArrayList()));
        return sampleFamilies;
    }

    public static void main(String[] args) throws Exception {
        String hostPort = "";
        if (args.length > 0) {
            hostPort = args[0];
        }
        JmxCollector jc = new JmxCollector(("{`hostPort`: `" + hostPort + "`,}").replace('`', '\"'));
        for (Collector.MetricFamilySamples mfs : jc.collect()) {
            System.out.println(mfs);
        }
    }

    class Receiver
    implements JmxScraper.MBeanReceiver {
        Map<String, Collector.MetricFamilySamples> metricFamilySamplesMap = new HashMap<String, Collector.MetricFamilySamples>();
        Config config;
        MatchedRulesCache.StalenessTracker stalenessTracker;
        private static final char SEP = '_';

        Receiver(Config config, MatchedRulesCache.StalenessTracker stalenessTracker) {
            this.config = config;
            this.stalenessTracker = stalenessTracker;
        }

        private String angleBrackets(String s) {
            return "<" + s.substring(1, s.length() - 1) + ">";
        }

        void addSample(Collector.MetricFamilySamples.Sample sample, Collector.Type type, String help) {
            Collector.MetricFamilySamples mfs = this.metricFamilySamplesMap.get(sample.name);
            if (mfs == null) {
                mfs = new Collector.MetricFamilySamples(sample.name, type, help, new ArrayList());
                this.metricFamilySamplesMap.put(sample.name, mfs);
            }
            mfs.samples.add(sample);
        }

        private void addToCache(Rule rule, String cacheKey, MatchedRule matchedRule) {
            if (rule.cache) {
                this.config.rulesCache.put(rule, cacheKey, matchedRule);
                this.stalenessTracker.add(rule, cacheKey);
            }
        }

        private MatchedRule defaultExport(String matchName, String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String help, Double value, double valueFactor, Collector.Type type) {
            StringBuilder name = new StringBuilder();
            name.append(domain);
            if (beanProperties.size() > 0) {
                name.append('_');
                name.append(beanProperties.values().iterator().next());
            }
            for (String k : attrKeys) {
                name.append('_');
                name.append(k);
            }
            name.append('_');
            name.append(attrName);
            String fullname = JmxCollector.safeName(name.toString());
            if (this.config.lowercaseOutputName) {
                fullname = fullname.toLowerCase();
            }
            ArrayList<String> labelNames = new ArrayList<String>();
            ArrayList<String> labelValues = new ArrayList<String>();
            if (beanProperties.size() > 1) {
                Iterator<Map.Entry<String, String>> iter = beanProperties.entrySet().iterator();
                iter.next();
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    String labelName = JmxCollector.safeName(entry.getKey());
                    if (this.config.lowercaseOutputLabelNames) {
                        labelName = labelName.toLowerCase();
                    }
                    labelNames.add(labelName);
                    labelValues.add(entry.getValue());
                }
            }
            return new MatchedRule(fullname, matchName, type, help, labelNames, labelValues, value, valueFactor);
        }

        @Override
        public void recordBean(String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object beanValue) {
            Number value;
            String beanName = domain + this.angleBrackets(beanProperties.toString()) + this.angleBrackets(attrKeys.toString());
            String help = attrDescription + " (" + beanName + attrName + ")";
            String attrNameSnakeCase = JmxCollector.toSnakeAndLowerCase(attrName);
            MatchedRule matchedRule = MatchedRule.unmatched();
            for (Rule rule : this.config.rules) {
                MatchedRule cachedRule;
                Object matchBeanValue = rule.cache ? "<cache>" : beanValue;
                String matchName = beanName + (rule.attrNameSnakeCase ? attrNameSnakeCase : attrName) + ": " + matchBeanValue;
                if (rule.cache && (cachedRule = this.config.rulesCache.get(rule, matchName)) != null) {
                    this.stalenessTracker.add(rule, matchName);
                    if (!cachedRule.isMatched()) continue;
                    matchedRule = cachedRule;
                    break;
                }
                Matcher matcher = null;
                if (rule.pattern != null && !(matcher = rule.pattern.matcher(matchName)).matches()) {
                    this.addToCache(rule, matchName, MatchedRule.unmatched());
                    continue;
                }
                Double value2 = null;
                if (rule.value != null && !rule.value.isEmpty()) {
                    String val = matcher.replaceAll(rule.value);
                    try {
                        value2 = Double.valueOf(val);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.fine("Unable to parse configured value '" + val + "' to number for bean: " + beanName + attrName + ": " + beanValue);
                        return;
                    }
                }
                if (rule.name == null) {
                    matchedRule = this.defaultExport(matchName, domain, beanProperties, attrKeys, rule.attrNameSnakeCase ? attrNameSnakeCase : attrName, help, value2, rule.valueFactor, rule.type);
                    this.addToCache(rule, matchName, matchedRule);
                    break;
                }
                String name = JmxCollector.safeName(matcher.replaceAll(rule.name));
                if (name.isEmpty()) {
                    return;
                }
                if (this.config.lowercaseOutputName) {
                    name = name.toLowerCase();
                }
                if (rule.help != null) {
                    help = matcher.replaceAll(rule.help);
                }
                ArrayList<String> labelNames = new ArrayList<String>();
                ArrayList<String> labelValues = new ArrayList<String>();
                if (rule.labelNames != null) {
                    for (int i = 0; i < rule.labelNames.size(); ++i) {
                        String unsafeLabelName = rule.labelNames.get(i);
                        String labelValReplacement = rule.labelValues.get(i);
                        try {
                            String labelName = JmxCollector.safeName(matcher.replaceAll(unsafeLabelName));
                            String labelValue = matcher.replaceAll(labelValReplacement);
                            if (this.config.lowercaseOutputLabelNames) {
                                labelName = labelName.toLowerCase();
                            }
                            if (labelName.isEmpty() || labelValue.isEmpty()) continue;
                            labelNames.add(labelName);
                            labelValues.add(labelValue);
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(String.format("Matcher '%s' unable to use: '%s' value: '%s'", matcher, unsafeLabelName, labelValReplacement), e);
                        }
                    }
                }
                matchedRule = new MatchedRule(name, matchName, rule.type, help, labelNames, labelValues, value2, rule.valueFactor);
                this.addToCache(rule, matchName, matchedRule);
                break;
            }
            if (matchedRule.isUnmatched()) {
                return;
            }
            if (matchedRule.value != null) {
                beanValue = matchedRule.value;
            }
            if (beanValue instanceof Number) {
                value = ((Number)beanValue).doubleValue() * matchedRule.valueFactor;
            } else if (beanValue instanceof Boolean) {
                value = (Boolean)beanValue != false ? 1 : 0;
            } else {
                LOGGER.fine("Ignoring unsupported bean: " + beanName + attrName + ": " + beanValue);
                return;
            }
            LOGGER.fine("add metric sample: " + matchedRule.name + " " + matchedRule.labelNames + " " + matchedRule.labelValues + " " + value.doubleValue());
            this.addSample(new Collector.MetricFamilySamples.Sample(matchedRule.name, matchedRule.labelNames, matchedRule.labelValues, value.doubleValue()), matchedRule.type, matchedRule.help);
        }
    }

    private static class Config {
        Integer startDelaySeconds = 0;
        String jmxUrl = "";
        String username = "";
        String password = "";
        boolean ssl = false;
        boolean lowercaseOutputName;
        boolean lowercaseOutputLabelNames;
        List<ObjectName> whitelistObjectNames = new ArrayList<ObjectName>();
        List<ObjectName> blacklistObjectNames = new ArrayList<ObjectName>();
        List<Rule> rules = new ArrayList<Rule>();
        long lastUpdate = 0L;
        MatchedRulesCache rulesCache;

        private Config() {
        }
    }

    static class Rule {
        Pattern pattern;
        String name;
        String value;
        Double valueFactor = 1.0;
        String help;
        boolean attrNameSnakeCase;
        boolean cache = false;
        Collector.Type type = Collector.Type.UNKNOWN;
        ArrayList<String> labelNames;
        ArrayList<String> labelValues;

        Rule() {
        }
    }
}

