/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server;

import com.google.common.base.MoreObjects;
import io.airlift.discovery.server.DynamicAnnouncement;
import io.airlift.discovery.server.DynamicStore;
import io.airlift.discovery.server.Id;
import io.airlift.discovery.server.Node;
import io.airlift.node.NodeInfo;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/announcement/{node_id}")
public class DynamicAnnouncementResource {
    private final NodeInfo nodeInfo;
    private final DynamicStore dynamicStore;

    @Inject
    public DynamicAnnouncementResource(DynamicStore dynamicStore, NodeInfo nodeInfo) {
        this.dynamicStore = dynamicStore;
        this.nodeInfo = nodeInfo;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response put(@PathParam(value="node_id") Id<Node> nodeId, @Context UriInfo uriInfo, DynamicAnnouncement announcement) {
        if (!this.nodeInfo.getEnvironment().equals(announcement.getEnvironment())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Environment mismatch. Expected: %s, Provided: %s", this.nodeInfo.getEnvironment(), announcement.getEnvironment())).build();
        }
        String location = (String)MoreObjects.firstNonNull((Object)announcement.getLocation(), (Object)("/somewhere/" + nodeId.toString()));
        DynamicAnnouncement announcementWithLocation = DynamicAnnouncement.copyOf(announcement).setLocation(location).build();
        this.dynamicStore.put(nodeId, announcementWithLocation);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @DELETE
    public Response delete(@PathParam(value="node_id") Id<Node> nodeId) {
        this.dynamicStore.delete(nodeId);
        return Response.noContent().build();
    }
}

