/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;

public class PulsarConnectorMetricsTracker
implements AutoCloseable {
    private final StatsLogger statsLogger;
    private static final String SCOPE = "split";
    private static final String ENTRY_QUEUE_DEQUEUE_WAIT_TIME = "entry-queue-dequeue-wait-time";
    private static final String ENTRY_QUEUE_DEQUEUE_WAIT_TIME_PER_QUERY = "entry-queue-dequeue-wait-time-per-query";
    private static final String BYTES_READ = "bytes-read";
    private static final String BYTES_READ_PER_QUERY = "bytes-read-per-query";
    private static final String ENTRY_DESERIALIZE_TIME = "entry-deserialize-time";
    private static final String ENTRY_DESERIALIZE_TIME_PER_QUERY = "entry-deserialize-time_per_query";
    private static final String MESSAGE_QUEUE_ENQUEUE_WAIT_TIME = "message-queue-enqueue-wait-time";
    private static final String MESSAGE_QUEUE_ENQUEUE_WAIT_TIME_PER_QUERY = "message-queue-enqueue-wait-time-per-query";
    private static final String NUM_MESSAGES_DERSERIALIZED = "num-messages-deserialized";
    public static final String NUM_MESSAGES_DERSERIALIZED_PER_ENTRY = "num-messages-deserialized-per-entry";
    public static final String NUM_MESSAGES_DERSERIALIZED_PER_QUERY = "num-messages-deserialized-per-query";
    public static final String READ_ATTEMPTS = "read-attempts";
    public static final String READ_ATTEMTPS_PER_QUERY = "read-attempts-per-query";
    public static final String READ_LATENCY_PER_BATCH = "read-latency-per-batch";
    public static final String READ_LATENCY_PER_QUERY = "read-latency-per-query";
    public static final String NUM_ENTRIES_PER_BATCH = "num-entries-per-batch";
    public static final String NUM_ENTRIES_PER_QUERY = "num-entries-per-query";
    public static final String MESSAGE_QUEUE_DEQUEUE_WAIT_TIME_PER_QUERY = "message-queue-dequeue-wait-time-per-query";
    public static final String RECORD_DESERIALIZE_TIME = "record-deserialize-time";
    private static final String RECORD_DESERIALIZE_TIME_PER_QUERY = "record-deserialize-time-per-query";
    private static final String NUM_RECORD_DESERIALIZED = "num-record-deserialized";
    private static final String TOTAL_EXECUTION_TIME = "total-execution-time";
    private final OpStatsLogger statsLoggerEntryQueueDequeueWaitTime;
    private final Counter statsLoggerBytesRead;
    private final OpStatsLogger statsLoggerEntryDeserializeTime;
    private final OpStatsLogger statsLoggerMessageQueueEnqueueWaitTime;
    private final Counter statsLoggerNumMessagesDeserialized;
    private final OpStatsLogger statsLoggerNumMessagesDeserializedPerEntry;
    private final OpStatsLogger statsLoggerReadAttempts;
    private final OpStatsLogger statsLoggerReadLatencyPerBatch;
    private final OpStatsLogger statsLoggerNumEntriesPerBatch;
    private final OpStatsLogger statsLoggerRecordDeserializeTime;
    private final Counter statsLoggerNumRecordDeserialized;
    private final OpStatsLogger statsLoggerTotalExecutionTime;
    private long entryQueueDequeueWaitTimeStartTime;
    private long entryQueueDequeueWaitTimeSum = 0L;
    private long bytesReadSum = 0L;
    private long entryDeserializeTimeStartTime;
    private long entryDeserializeTimeSum = 0L;
    private long messageQueueEnqueueWaitTimeStartTime;
    private long messageQueueEnqueueWaitTimeSum = 0L;
    private long numMessagesDerserializedSum = 0L;
    private long numMessagedDerserializedPerBatch = 0L;
    private long readAttemptsSuccessSum = 0L;
    private long readAttemptsFailSum = 0L;
    private long readLatencySuccessSum = 0L;
    private long readLatencyFailSum = 0L;
    private long numEntriesPerBatchSum = 0L;
    private long messageQueueDequeueWaitTimeSum = 0L;
    private long recordDeserializeTimeStartTime;
    private long recordDeserializeTimeSum = 0L;

    public PulsarConnectorMetricsTracker(StatsProvider statsProvider) {
        StatsLogger statsLogger = this.statsLogger = statsProvider instanceof NullStatsProvider ? null : statsProvider.getStatsLogger(SCOPE);
        if (this.statsLogger != null) {
            this.statsLoggerEntryQueueDequeueWaitTime = this.statsLogger.getOpStatsLogger(ENTRY_QUEUE_DEQUEUE_WAIT_TIME);
            this.statsLoggerBytesRead = this.statsLogger.getCounter(BYTES_READ);
            this.statsLoggerEntryDeserializeTime = this.statsLogger.getOpStatsLogger(ENTRY_DESERIALIZE_TIME);
            this.statsLoggerMessageQueueEnqueueWaitTime = this.statsLogger.getOpStatsLogger(MESSAGE_QUEUE_ENQUEUE_WAIT_TIME);
            this.statsLoggerNumMessagesDeserialized = this.statsLogger.getCounter(NUM_MESSAGES_DERSERIALIZED);
            this.statsLoggerNumMessagesDeserializedPerEntry = this.statsLogger.getOpStatsLogger(NUM_MESSAGES_DERSERIALIZED_PER_ENTRY);
            this.statsLoggerReadAttempts = this.statsLogger.getOpStatsLogger(READ_ATTEMPTS);
            this.statsLoggerReadLatencyPerBatch = this.statsLogger.getOpStatsLogger(READ_LATENCY_PER_BATCH);
            this.statsLoggerNumEntriesPerBatch = this.statsLogger.getOpStatsLogger(NUM_ENTRIES_PER_BATCH);
            this.statsLoggerRecordDeserializeTime = this.statsLogger.getOpStatsLogger(RECORD_DESERIALIZE_TIME);
            this.statsLoggerNumRecordDeserialized = this.statsLogger.getCounter(NUM_RECORD_DESERIALIZED);
            this.statsLoggerTotalExecutionTime = this.statsLogger.getOpStatsLogger(TOTAL_EXECUTION_TIME);
        } else {
            this.statsLoggerEntryQueueDequeueWaitTime = null;
            this.statsLoggerBytesRead = null;
            this.statsLoggerEntryDeserializeTime = null;
            this.statsLoggerMessageQueueEnqueueWaitTime = null;
            this.statsLoggerNumMessagesDeserialized = null;
            this.statsLoggerNumMessagesDeserializedPerEntry = null;
            this.statsLoggerReadAttempts = null;
            this.statsLoggerReadLatencyPerBatch = null;
            this.statsLoggerNumEntriesPerBatch = null;
            this.statsLoggerRecordDeserializeTime = null;
            this.statsLoggerNumRecordDeserialized = null;
            this.statsLoggerTotalExecutionTime = null;
        }
    }

    public void start_ENTRY_QUEUE_DEQUEUE_WAIT_TIME() {
        if (this.statsLogger != null) {
            this.entryQueueDequeueWaitTimeStartTime = System.nanoTime();
        }
    }

    public void end_ENTRY_QUEUE_DEQUEUE_WAIT_TIME() {
        if (this.statsLogger != null) {
            long time = System.nanoTime() - this.entryQueueDequeueWaitTimeStartTime;
            this.entryQueueDequeueWaitTimeSum += time;
            this.statsLoggerEntryQueueDequeueWaitTime.registerSuccessfulEvent(time, TimeUnit.NANOSECONDS);
        }
    }

    public void register_BYTES_READ(long bytes) {
        if (this.statsLogger != null) {
            this.bytesReadSum += bytes;
            this.statsLoggerBytesRead.addCount(bytes);
        }
    }

    public void start_ENTRY_DESERIALIZE_TIME() {
        if (this.statsLogger != null) {
            this.entryDeserializeTimeStartTime = System.nanoTime();
        }
    }

    public void end_ENTRY_DESERIALIZE_TIME() {
        if (this.statsLogger != null) {
            long time = System.nanoTime() - this.entryDeserializeTimeStartTime;
            this.entryDeserializeTimeSum += time;
            this.statsLoggerEntryDeserializeTime.registerSuccessfulEvent(time, TimeUnit.NANOSECONDS);
        }
    }

    public void start_MESSAGE_QUEUE_ENQUEUE_WAIT_TIME() {
        if (this.statsLogger != null) {
            this.messageQueueEnqueueWaitTimeStartTime = System.nanoTime();
        }
    }

    public void end_MESSAGE_QUEUE_ENQUEUE_WAIT_TIME() {
        if (this.statsLogger != null) {
            long time = System.nanoTime() - this.messageQueueEnqueueWaitTimeStartTime;
            this.messageQueueEnqueueWaitTimeSum += time;
            this.statsLoggerMessageQueueEnqueueWaitTime.registerSuccessfulEvent(time, TimeUnit.NANOSECONDS);
        }
    }

    public void incr_NUM_MESSAGES_DESERIALIZED_PER_ENTRY() {
        if (this.statsLogger != null) {
            ++this.numMessagedDerserializedPerBatch;
            this.statsLoggerNumMessagesDeserialized.addCount(1L);
        }
    }

    public void end_NUM_MESSAGES_DESERIALIZED_PER_ENTRY() {
        if (this.statsLogger != null) {
            this.numMessagesDerserializedSum += this.numMessagedDerserializedPerBatch;
            this.statsLoggerNumMessagesDeserializedPerEntry.registerSuccessfulValue(this.numMessagedDerserializedPerBatch);
            this.numMessagedDerserializedPerBatch = 0L;
        }
    }

    public void incr_READ_ATTEMPTS_SUCCESS() {
        if (this.statsLogger != null) {
            ++this.readAttemptsSuccessSum;
            this.statsLoggerReadAttempts.registerSuccessfulValue(1L);
        }
    }

    public void incr_READ_ATTEMPTS_FAIL() {
        if (this.statsLogger != null) {
            ++this.readAttemptsFailSum;
            this.statsLoggerReadAttempts.registerFailedValue(1L);
        }
    }

    public void register_READ_LATENCY_PER_BATCH_SUCCESS(long latency) {
        if (this.statsLogger != null) {
            this.readLatencySuccessSum += latency;
            this.statsLoggerReadLatencyPerBatch.registerSuccessfulEvent(latency, TimeUnit.NANOSECONDS);
        }
    }

    public void register_READ_LATENCY_PER_BATCH_FAIL(long latency) {
        if (this.statsLogger != null) {
            this.readLatencyFailSum += latency;
            this.statsLoggerReadLatencyPerBatch.registerFailedEvent(latency, TimeUnit.NANOSECONDS);
        }
    }

    public void incr_NUM_ENTRIES_PER_BATCH_SUCCESS(long delta) {
        if (this.statsLogger != null) {
            this.numEntriesPerBatchSum += delta;
            this.statsLoggerNumEntriesPerBatch.registerSuccessfulValue(delta);
        }
    }

    public void incr_NUM_ENTRIES_PER_BATCH_FAIL(long delta) {
        if (this.statsLogger != null) {
            this.statsLoggerNumEntriesPerBatch.registerFailedValue(delta);
        }
    }

    public void register_MESSAGE_QUEUE_DEQUEUE_WAIT_TIME(long latency) {
        if (this.statsLogger != null) {
            this.messageQueueDequeueWaitTimeSum += latency;
        }
    }

    public void start_RECORD_DESERIALIZE_TIME() {
        if (this.statsLogger != null) {
            this.recordDeserializeTimeStartTime = System.nanoTime();
        }
    }

    public void end_RECORD_DESERIALIZE_TIME() {
        if (this.statsLogger != null) {
            long time = System.nanoTime() - this.recordDeserializeTimeStartTime;
            this.recordDeserializeTimeSum += time;
            this.statsLoggerRecordDeserializeTime.registerSuccessfulEvent(time, TimeUnit.NANOSECONDS);
        }
    }

    public void incr_NUM_RECORD_DESERIALIZED() {
        if (this.statsLogger != null) {
            this.statsLoggerNumRecordDeserialized.addCount(1L);
        }
    }

    public void register_TOTAL_EXECUTION_TIME(long latency) {
        if (this.statsLogger != null) {
            this.statsLoggerTotalExecutionTime.registerSuccessfulEvent(latency, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void close() {
        if (this.statsLogger != null) {
            this.statsLogger.getOpStatsLogger(ENTRY_QUEUE_DEQUEUE_WAIT_TIME_PER_QUERY).registerSuccessfulEvent(this.entryQueueDequeueWaitTimeSum, TimeUnit.NANOSECONDS);
            this.statsLogger.getOpStatsLogger(BYTES_READ_PER_QUERY).registerSuccessfulValue(this.bytesReadSum);
            this.statsLogger.getOpStatsLogger(ENTRY_DESERIALIZE_TIME_PER_QUERY).registerSuccessfulEvent(this.entryDeserializeTimeSum, TimeUnit.NANOSECONDS);
            this.statsLogger.getOpStatsLogger(MESSAGE_QUEUE_ENQUEUE_WAIT_TIME_PER_QUERY).registerSuccessfulEvent(this.messageQueueEnqueueWaitTimeSum, TimeUnit.NANOSECONDS);
            this.statsLogger.getOpStatsLogger(NUM_MESSAGES_DERSERIALIZED_PER_QUERY).registerSuccessfulValue(this.numMessagesDerserializedSum);
            this.statsLogger.getOpStatsLogger(READ_ATTEMTPS_PER_QUERY).registerSuccessfulValue(this.readAttemptsSuccessSum);
            this.statsLogger.getOpStatsLogger(READ_ATTEMTPS_PER_QUERY).registerFailedValue(this.readAttemptsFailSum);
            this.statsLogger.getOpStatsLogger(READ_LATENCY_PER_QUERY).registerSuccessfulEvent(this.readLatencySuccessSum, TimeUnit.NANOSECONDS);
            this.statsLogger.getOpStatsLogger(READ_LATENCY_PER_QUERY).registerFailedEvent(this.readLatencyFailSum, TimeUnit.NANOSECONDS);
            this.statsLogger.getOpStatsLogger(NUM_ENTRIES_PER_QUERY).registerSuccessfulValue(this.numEntriesPerBatchSum);
            this.statsLogger.getOpStatsLogger(MESSAGE_QUEUE_DEQUEUE_WAIT_TIME_PER_QUERY).registerSuccessfulEvent(this.messageQueueDequeueWaitTimeSum, TimeUnit.MILLISECONDS);
            this.statsLogger.getOpStatsLogger(RECORD_DESERIALIZE_TIME_PER_QUERY).registerSuccessfulEvent(this.recordDeserializeTimeSum, TimeUnit.NANOSECONDS);
        }
    }
}

