/*
 * Decompiled with CFR 0.152.
 */
package io.trino.matching;

import io.trino.matching.Capture;
import io.trino.matching.Pattern;
import io.trino.matching.PropertyPattern;
import io.trino.matching.pattern.EqualsPattern;
import io.trino.matching.pattern.FilterPattern;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public class Property<F, C, T> {
    private final String name;
    private final BiFunction<F, C, Optional<T>> function;

    public static <F, C, T> Property<F, C, T> property(String name, Function<F, T> function) {
        return Property.property(name, (F source, C context) -> function.apply(source));
    }

    public static <F, C, T> Property<F, C, T> property(String name, BiFunction<F, C, T> function) {
        return Property.optionalProperty(name, (F source, C context) -> Optional.of(function.apply(source, context)));
    }

    public static <F, C, T> Property<F, C, T> optionalProperty(String name, Function<F, Optional<T>> function) {
        return new Property<Object, Object, T>(name, (source, context) -> (Optional)function.apply(source));
    }

    public static <F, C, T> Property<F, C, T> optionalProperty(String name, BiFunction<F, C, Optional<T>> function) {
        return new Property<F, C, T>(name, function);
    }

    public Property(String name, BiFunction<F, C, Optional<T>> function) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.function = Objects.requireNonNull(function, "function is null");
    }

    public String getName() {
        return this.name;
    }

    public BiFunction<F, C, Optional<?>> getFunction() {
        return this.function::apply;
    }

    public <R> PropertyPattern<F, C, R> matching(Pattern<R> pattern) {
        return PropertyPattern.of(this, pattern);
    }

    public PropertyPattern<F, C, T> capturedAs(Capture<T> capture) {
        Pattern<Object> matchAll = Pattern.any();
        return this.matching(matchAll.capturedAs(capture));
    }

    public PropertyPattern<F, C, T> equalTo(T expectedValue) {
        return this.matching(new EqualsPattern<T>(expectedValue, Optional.empty()));
    }

    public PropertyPattern<F, C, T> matching(Predicate<? super T> predicate) {
        return this.matching((? super T t, ? context) -> predicate.test(t));
    }

    public PropertyPattern<F, C, T> matching(BiPredicate<? super T, ?> predicate) {
        return this.matching(new FilterPattern<T>(predicate, Optional.empty()));
    }
}

