/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.operator.aggregation.WindowAccumulator;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.WindowFunction;
import io.trino.spi.function.WindowIndex;
import java.util.Objects;
import java.util.function.Supplier;

class AggregateWindowFunction
implements WindowFunction {
    private final Supplier<WindowAccumulator> accumulatorFactory;
    private final boolean hasRemoveInput;
    private WindowIndex windowIndex;
    private WindowAccumulator accumulator;
    private int currentStart;
    private int currentEnd;

    public AggregateWindowFunction(Supplier<WindowAccumulator> accumulatorFactory, boolean hasRemoveInput) {
        this.accumulatorFactory = Objects.requireNonNull(accumulatorFactory, "accumulatorFactory is null");
        this.hasRemoveInput = hasRemoveInput;
    }

    public void reset(WindowIndex windowIndex) {
        this.windowIndex = windowIndex;
        this.resetAccumulator();
    }

    public void processRow(BlockBuilder output, int peerGroupStart, int peerGroupEnd, int frameStart, int frameEnd) {
        if (frameStart < 0) {
            this.resetAccumulator();
        } else if (frameStart == this.currentStart && frameEnd >= this.currentEnd) {
            this.accumulate(this.currentEnd + 1, frameEnd);
            this.currentEnd = frameEnd;
        } else {
            this.buildNewFrame(frameStart, frameEnd);
        }
        this.accumulator.evaluateFinal(output);
    }

    private void buildNewFrame(int frameStart, int frameEnd) {
        if (this.hasRemoveInput) {
            int suffixRemoveLength;
            int prefixRemoveLength;
            if (this.currentStart < 0) {
                this.currentStart = 0;
                this.currentEnd = -1;
            }
            int overlapStart = Math.max(frameStart, this.currentStart);
            int overlapEnd = Math.min(frameEnd, this.currentEnd);
            if (overlapEnd - overlapStart + 1 > (prefixRemoveLength = overlapStart - this.currentStart) + (suffixRemoveLength = this.currentEnd - overlapEnd)) {
                if (this.currentStart < frameStart) {
                    this.remove(this.currentStart, frameStart - 1);
                }
                if (frameEnd < this.currentEnd) {
                    this.remove(frameEnd + 1, this.currentEnd);
                }
                if (frameStart < this.currentStart) {
                    this.accumulate(frameStart, this.currentStart - 1);
                }
                if (this.currentEnd < frameEnd) {
                    this.accumulate(this.currentEnd + 1, frameEnd);
                }
                this.currentStart = frameStart;
                this.currentEnd = frameEnd;
                return;
            }
        }
        this.resetAccumulator();
        this.accumulate(frameStart, frameEnd);
        this.currentStart = frameStart;
        this.currentEnd = frameEnd;
    }

    private void accumulate(int start, int end) {
        this.accumulator.addInput(this.windowIndex, start, end);
    }

    private void remove(int start, int end) {
        this.accumulator.removeInput(this.windowIndex, start, end);
    }

    private void resetAccumulator() {
        if (this.currentStart >= 0) {
            this.accumulator = this.accumulatorFactory.get();
            this.currentStart = -1;
            this.currentEnd = -1;
        }
    }
}

