/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import io.airlift.units.DataSize;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;

public class ExceededSpillLimitException
extends TrinoException {
    public static ExceededSpillLimitException exceededLocalLimit(DataSize maxSpill) {
        return new ExceededSpillLimitException(String.format("Query exceeded local spill limit of %s", maxSpill));
    }

    public static ExceededSpillLimitException exceededPerQueryLocalLimit(DataSize maxSpill) {
        return new ExceededSpillLimitException(String.format("Query exceeded per-query local spill limit of %s", maxSpill));
    }

    private ExceededSpillLimitException(String message) {
        super((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_SPILL_LIMIT, message);
    }
}

