/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.apache.inlong.audit.entity.AuditInformation;
import org.apache.inlong.audit.entity.AuditProxy;
import org.apache.inlong.manager.pojo.audit.AuditRequest;
import org.apache.inlong.manager.pojo.audit.AuditVO;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.service.core.AuditService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Audit-API"})
public class AuditController {
    @Lazy
    @Autowired
    private AuditService auditService;

    @PostMapping(value={"/audit/list"})
    @ApiOperation(value="Query audit list according to conditions")
    public Response<List<AuditVO>> listByCondition(@Valid @RequestBody AuditRequest request) throws Exception {
        return Response.success((Object)this.auditService.listByCondition(request));
    }

    @PostMapping(value={"/audit/listAll"})
    @ApiOperation(value="Query audit list all according to conditions")
    public Response<List<AuditVO>> listAll(@Valid @RequestBody AuditRequest request) throws Exception {
        return Response.success((Object)this.auditService.listAll(request));
    }

    @ApiOperation(value="Refresh audit base item cache")
    @PostMapping(value={"/audit/refreshCache"})
    public Response<Boolean> refreshCache() {
        return Response.success((Object)this.auditService.refreshBaseItemCache());
    }

    @ApiOperation(value="Get the audit base info")
    @GetMapping(value={"/audit/getAuditBases"})
    public Response<List<AuditInformation>> getAuditBases(@RequestParam(required=false, defaultValue="false") boolean isMetric) {
        return Response.success((Object)this.auditService.getAuditBases(Boolean.valueOf(isMetric)));
    }

    @GetMapping(value={"/audit/getAuditProxy"})
    @ApiOperation(value="Get audit proxy url")
    @ApiImplicitParam(name="component", dataTypeClass=String.class, required=true)
    public Response<List<AuditProxy>> getAuditProxy(@RequestParam String component) throws Exception {
        return Response.success((Object)this.auditService.getAuditProxy(component));
    }
}

