/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZNodePaths {
    public static final char ZNODE_PATH_SEPARATOR = '/';
    public static final String META_ZNODE_PREFIX_CONF_KEY = "zookeeper.znode.metaserver";
    public static final String META_ZNODE_PREFIX = "meta-region-server";
    private static final String DEFAULT_SNAPSHOT_CLEANUP_ZNODE = "snapshot-cleanup";
    public final String baseZNode;
    private final String metaZNodePrefix;
    public final String rsZNode;
    public final String drainingZNode;
    public final String masterAddressZNode;
    public final String backupMasterAddressesZNode;
    public final String clusterStateZNode;
    @Deprecated
    public final String tableZNode;
    public final String clusterIdZNode;
    public final String splitLogZNode;
    public final String balancerZNode;
    public final String regionNormalizerZNode;
    public final String switchZNode;
    public final String namespaceZNode;
    public final String masterMaintZNode;
    public final String replicationZNode;
    public final String peersZNode;
    public final String queuesZNode;
    public final String hfileRefsZNode;
    final String snapshotCleanupZNode;

    public ZNodePaths(Configuration conf) {
        this.baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        this.metaZNodePrefix = conf.get(META_ZNODE_PREFIX_CONF_KEY, META_ZNODE_PREFIX);
        this.rsZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.rs", "rs"));
        this.drainingZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.draining.rs", "draining"));
        this.masterAddressZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.master", "master"));
        this.backupMasterAddressesZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.backup.masters", "backup-masters"));
        this.clusterStateZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.state", "running"));
        this.tableZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableEnableDisable", "table"));
        this.clusterIdZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.clusterId", "hbaseid"));
        this.splitLogZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.splitlog", "splitWAL"));
        this.balancerZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.balancer", "balancer"));
        this.regionNormalizerZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.regionNormalizer", "normalizer"));
        this.switchZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.switch", "switch"));
        this.namespaceZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.namespace", "namespace"));
        this.masterMaintZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.masterMaintenance", "master-maintenance"));
        this.replicationZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.replication", "replication"));
        this.peersZNode = ZNodePaths.joinZNode(this.replicationZNode, conf.get("zookeeper.znode.replication.peers", "peers"));
        this.queuesZNode = ZNodePaths.joinZNode(this.replicationZNode, conf.get("zookeeper.znode.replication.rs", "rs"));
        this.hfileRefsZNode = ZNodePaths.joinZNode(this.replicationZNode, conf.get("zookeeper.znode.replication.hfile.refs", "hfile-refs"));
        this.snapshotCleanupZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.snapshot.cleanup", DEFAULT_SNAPSHOT_CLEANUP_ZNODE));
    }

    public String toString() {
        return "ZNodePaths [baseZNode=" + this.baseZNode + ", rsZNode=" + this.rsZNode + ", drainingZNode=" + this.drainingZNode + ", masterAddressZNode=" + this.masterAddressZNode + ", backupMasterAddressesZNode=" + this.backupMasterAddressesZNode + ", clusterStateZNode=" + this.clusterStateZNode + ", tableZNode=" + this.tableZNode + ", clusterIdZNode=" + this.clusterIdZNode + ", splitLogZNode=" + this.splitLogZNode + ", balancerZNode=" + this.balancerZNode + ", regionNormalizerZNode=" + this.regionNormalizerZNode + ", switchZNode=" + this.switchZNode + ", namespaceZNode=" + this.namespaceZNode + ", masterMaintZNode=" + this.masterMaintZNode + ", replicationZNode=" + this.replicationZNode + ", peersZNode=" + this.peersZNode + ", queuesZNode=" + this.queuesZNode + ", hfileRefsZNode=" + this.hfileRefsZNode + ", snapshotCleanupZNode=" + this.snapshotCleanupZNode + "]";
    }

    public String getZNodeForReplica(int replicaId) {
        if (RegionReplicaUtil.isDefaultReplica(replicaId)) {
            return ZNodePaths.joinZNode(this.baseZNode, this.metaZNodePrefix);
        }
        return ZNodePaths.joinZNode(this.baseZNode, this.metaZNodePrefix + "-" + replicaId);
    }

    public int getMetaReplicaIdFromPath(String path) {
        int prefixLen = this.baseZNode.length() + 1;
        return this.getMetaReplicaIdFromZNode(path.substring(prefixLen));
    }

    public int getMetaReplicaIdFromZNode(String znode) {
        return znode.equals(this.metaZNodePrefix) ? 0 : Integer.parseInt(znode.substring(this.metaZNodePrefix.length() + 1));
    }

    public boolean isMetaZNodePrefix(String znode) {
        return znode != null && znode.startsWith(this.metaZNodePrefix);
    }

    public boolean isMetaZNodePath(String path) {
        int prefixLen = this.baseZNode.length() + 1;
        return path.length() > prefixLen && this.isMetaZNodePrefix(path.substring(prefixLen));
    }

    public boolean isClientReadable(String path) {
        return path.equals(this.baseZNode) || this.isMetaZNodePath(path) || path.equals(this.masterAddressZNode) || path.equals(this.clusterIdZNode) || path.equals(this.rsZNode) || path.equals(this.tableZNode) || path.startsWith(this.tableZNode + "/");
    }

    public static String joinZNode(String prefix, String suffix) {
        return prefix + '/' + suffix;
    }
}

