/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.nio.charset.Charset;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"length"}, parameter="(String str, String charset)", descriptions={"- Return \"\" if 'str' is NULL;", "- Return the byte length of the 'str'.", "Note: charset defaults to matching with JVM."}, examples={"length(\u5e94\u9f99, utf-8) = 6", "length('hello world') = 11"})
public class LengthFunction
implements ValueParser {
    private final ValueParser stringParser;
    private ValueParser charSetNameParser;
    private final Charset DEFAULT_CHARSET = Charset.defaultCharset();

    public LengthFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        if (expressions.size() > 1) {
            this.charSetNameParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObject = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObject == null) {
            return null;
        }
        Charset charset = this.DEFAULT_CHARSET;
        if (this.charSetNameParser != null) {
            charset = Charset.forName(OperatorTools.parseString(this.charSetNameParser.parse(sourceData, rowIndex, context)));
        }
        String str = OperatorTools.parseString(stringObject);
        return str.getBytes(charset).length;
    }
}

