/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"radians"}, parameter="(Numeric x)", descriptions={"- Return \"\" if 'x' is NULL;", "- Return radians of 'x', Convert degrees to radians."}, examples={"radians(18.97) = 0.33108895910332425"})
public class RadiansFunction
implements ValueParser {
    private ValueParser degreeParser;

    public RadiansFunction(Function expr) {
        this.degreeParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object degreeObj = this.degreeParser.parse(sourceData, rowIndex, context);
        if (degreeObj == null) {
            return null;
        }
        return Math.toRadians(OperatorTools.parseBigDecimal(degreeObj).doubleValue());
    }
}

