/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.base;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.formats.metrics.FormatMetricGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultSerializationSchema<T>
implements SerializationSchema<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSerializationSchema.class);
    private final boolean ignoreErrors;
    private boolean errorOccurred = false;
    protected transient FormatMetricGroup formatMetricGroup;

    public DefaultSerializationSchema(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public void open(SerializationSchema.InitializationContext context) {
        try {
            MetricGroup metricGroup = context.getMetricGroup();
            Preconditions.checkArgument((boolean)(metricGroup instanceof FormatMetricGroup), (Object)("Expecting FormatMetricGroup, but got " + metricGroup.getClass().getName()));
            this.formatMetricGroup = (FormatMetricGroup)metricGroup;
        }
        catch (Exception ignore) {
            LOG.warn("FormatGroup initialization error, no format metric will be accumulated", ignore);
        }
    }

    public byte[] serialize(T data) {
        try {
            byte[] result = this.serializeInternal(data);
            this.errorOccurred = false;
            return result;
        }
        catch (Exception e) {
            this.errorOccurred = true;
            if (this.formatMetricGroup != null) {
                this.formatMetricGroup.getNumRecordsSerializeError().inc(1L);
            }
            if (this.ignoreErrors) {
                if (this.formatMetricGroup != null) {
                    this.formatMetricGroup.getNumRecordsSerializeErrorIgnored().inc(1L);
                }
                LOG.warn("Could not properly serialize the data {}", (Object)data, (Object)e);
                return null;
            }
            throw new RuntimeException("Failed to serialize data " + data, e);
        }
    }

    public boolean skipCurrentRecord(T element) {
        return this.ignoreErrors && this.errorOccurred;
    }

    protected abstract byte[] serializeInternal(T var1) throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSerializationSchema that = (DefaultSerializationSchema)o;
        return Objects.equals(this.ignoreErrors, that.ignoreErrors);
    }

    public int hashCode() {
        return Objects.hash(this.ignoreErrors);
    }
}

