/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.formats.common.Converter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.util.Preconditions;

class CsvBulkWriter<T, R, C>
implements BulkWriter<T> {
    private final FSDataOutputStream stream;
    private final Converter<T, R, C> converter;
    @Nullable
    private final C converterContext;
    private final ObjectWriter csvWriter;

    CsvBulkWriter(CsvMapper mapper, CsvSchema schema, Converter<T, R, C> converter, @Nullable C converterContext, FSDataOutputStream stream) {
        Preconditions.checkNotNull((Object)mapper);
        Preconditions.checkNotNull((Object)schema);
        this.converter = (Converter)Preconditions.checkNotNull(converter);
        this.stream = (FSDataOutputStream)Preconditions.checkNotNull((Object)stream);
        this.converterContext = converterContext;
        this.csvWriter = mapper.writer(schema);
        mapper.getFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }

    static <T, R, C> CsvBulkWriter<T, R, C> forSchema(CsvMapper mapper, CsvSchema schema, Converter<T, R, C> converter, @Nullable C converterContext, FSDataOutputStream stream) {
        return new CsvBulkWriter<T, R, C>(mapper, schema, converter, converterContext, stream);
    }

    static <T> CsvBulkWriter<T, T, Void> forPojo(Class<T> pojoClass, FSDataOutputStream stream) {
        Converter<Object, Object, Void> converter = (value, context) -> value;
        CsvMapper csvMapper = new CsvMapper();
        CsvSchema schema = csvMapper.schemaFor(pojoClass).withoutQuoteChar();
        return new CsvBulkWriter<Object, Object, Object>(csvMapper, schema, converter, null, stream);
    }

    public void addElement(T element) throws IOException {
        R r = this.converter.convert(element, this.converterContext);
        this.csvWriter.writeValue((OutputStream)this.stream, r);
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void finish() throws IOException {
        this.stream.sync();
    }
}

