/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common.provider;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.provider.CredentialsProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.ini4j.Wini;

public class ProfileCredentialsProvider
implements CredentialsProvider {
    private static Wini ini;

    @Override
    public Credential getCredentials() throws TencentCloudSDKException {
        Wini ini = ProfileCredentialsProvider.getIni();
        String secretId = ini.get((Object)"default", (Object)"secret_id");
        String secretKey = ini.get((Object)"default", (Object)"secret_key");
        if (secretId == null || secretKey == null) {
            throw new TencentCloudSDKException("Not found secretId or secretKey");
        }
        if (secretId.length() == 0) {
            throw new TencentCloudSDKException("SecretId cannot be empty");
        }
        if (secretKey.length() == 0) {
            throw new TencentCloudSDKException("SecretKey cannot be empty");
        }
        return new Credential(secretId, secretKey);
    }

    private static Wini getIni() throws TencentCloudSDKException {
        String fileName;
        if (Files.exists(Paths.get(System.getProperty("user.home") + "\\.tencentcloud\\credentials", new String[0]), new LinkOption[0])) {
            fileName = System.getProperty("user.home") + "\\.tencentcloud\\credentials";
        } else if (Files.exists(Paths.get("/etc/tencentcloud/credentials", new String[0]), new LinkOption[0])) {
            fileName = "/etc/tencentcloud/credentials";
        } else if (Files.exists(Paths.get(System.getProperty("user.home") + "/.tencentcloud/credentials", new String[0]), new LinkOption[0])) {
            fileName = System.getProperty("user.home") + "/.tencentcloud/credentials";
        } else {
            throw new TencentCloudSDKException("Not found file");
        }
        try {
            ini = new Wini(new File(fileName));
        }
        catch (IOException e) {
            throw new TencentCloudSDKException("IOException");
        }
        return ini;
    }
}

