/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common.provider;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.CommonClient;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.JsonResponseModel;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.provider.CredentialsProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;

public class OIDCRoleArnProvider
implements CredentialsProvider {
    public String Region;
    public String ProviderId;
    public String WebIdentityToken;
    public String RoleArn;
    public String RoleSessionName;
    public long DurationSeconds;
    private static final String Service = "sts";
    private static final String Version = "2018-08-13";
    private static final String Action = "AssumeRoleWithWebIdentity";
    private static final String DefaultSessionName = "tencentcloud-java-sdk-";
    private static final long DefaultDurationSeconds = 7200L;

    public OIDCRoleArnProvider(String region, String providerId, String webIdentityToken, String roleArn, String roleSessionName, long durationSeconds) {
        this.Region = region;
        this.ProviderId = providerId;
        this.WebIdentityToken = webIdentityToken;
        this.RoleArn = roleArn;
        this.RoleSessionName = roleSessionName;
        this.DurationSeconds = durationSeconds;
    }

    public OIDCRoleArnProvider() throws IOException, TencentCloudSDKException {
        this.Region = System.getenv("TKE_REGION");
        if (this.Region == null || this.Region.isEmpty()) {
            throw new TencentCloudSDKException("env TKE_REGION not exist");
        }
        this.ProviderId = System.getenv("TKE_PROVIDER_ID");
        if (this.ProviderId == null || this.ProviderId.isEmpty()) {
            throw new TencentCloudSDKException("env TKE_PROVIDER_ID not exist");
        }
        String tokenFile = System.getenv("TKE_WEB_IDENTITY_TOKEN_FILE");
        if (tokenFile == null || tokenFile.isEmpty()) {
            throw new TencentCloudSDKException("env TKE_WEB_IDENTITY_TOKEN_FILE not exist");
        }
        this.WebIdentityToken = new String(Files.readAllBytes(Paths.get(tokenFile, new String[0])));
        this.RoleArn = System.getenv("TKE_ROLE_ARN");
        if (this.RoleArn == null || this.RoleArn.isEmpty()) {
            throw new TencentCloudSDKException("env TKE_ROLE_ARN not exist");
        }
        this.ProviderId = System.getenv("TKE_PROVIDER_ID");
        if (this.ProviderId == null || this.ProviderId.isEmpty()) {
            throw new TencentCloudSDKException("env TKE_PROVIDER_ID not exist");
        }
        this.RoleSessionName = DefaultSessionName + System.currentTimeMillis() * 1000L;
        this.DurationSeconds = 7200L;
    }

    @Override
    public Credential getCredentials() throws TencentCloudSDKException {
        CommonClient client = new CommonClient(Service, Version, new Credential("", ""), this.Region);
        Request request = new Request();
        request.ProviderId = this.ProviderId;
        request.WebIdentityToken = this.WebIdentityToken;
        request.RoleArn = this.RoleArn;
        request.RoleSessionName = this.RoleSessionName;
        request.DurationSeconds = this.DurationSeconds;
        request.setSkipSign(true);
        String respStr = client.commonRequest(request, Action);
        JsonResponseModel response = (JsonResponseModel)client.gson.fromJson(respStr, new TypeToken<JsonResponseModel<Response>>(){}.getType());
        Response resp = (Response)response.response;
        return new Credential(resp.Credentials.TmpSecretId, resp.Credentials.TmpSecretKey, resp.Credentials.Token);
    }

    private static class Response {
        @Expose
        public Long ExpiredTime;
        @Expose
        public String Expiration;
        @Expose
        public Credentials Credentials;
        @Expose
        public String RequestId;

        private Response() {
        }

        private static class Credentials {
            @Expose
            public String Token;
            @Expose
            public String TmpSecretId;
            @Expose
            public String TmpSecretKey;

            private Credentials() {
            }
        }
    }

    private static class Request
    extends AbstractModel {
        @Expose
        public String ProviderId;
        @Expose
        public String WebIdentityToken;
        @Expose
        public String RoleArn;
        @Expose
        public String RoleSessionName;
        @Expose
        public Long DurationSeconds;

        private Request() {
        }

        @Override
        protected void toMap(HashMap<String, String> map, String prefix) {
        }
    }
}

