/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.time.Duration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.logical.CumulativeWindowSpec;
import org.apache.flink.table.planner.plan.logical.HoppingWindowSpec;
import org.apache.flink.table.planner.plan.logical.TimeAttributeWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.TumblingWindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.assigners.CumulativeWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.SlidingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.TumblingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;

@Internal
public final class WindowTableFunctionUtil {
    public static WindowAssigner<TimeWindow> createWindowAssigner(TimeAttributeWindowingStrategy windowingStrategy) {
        WindowSpec windowSpec = windowingStrategy.getWindow();
        boolean isProctime = windowingStrategy.isProctime();
        if (windowSpec instanceof TumblingWindowSpec) {
            TumblingWindowSpec tumblingWindowSpec = (TumblingWindowSpec)windowSpec;
            TumblingWindowAssigner windowAssigner = TumblingWindowAssigner.of((Duration)tumblingWindowSpec.getSize());
            if (isProctime) {
                windowAssigner = windowAssigner.withProcessingTime();
            }
            if (tumblingWindowSpec.getOffset() != null) {
                windowAssigner = windowAssigner.withOffset(tumblingWindowSpec.getOffset());
            }
            return windowAssigner;
        }
        if (windowSpec instanceof HoppingWindowSpec) {
            HoppingWindowSpec hoppingWindowSpec = (HoppingWindowSpec)windowSpec;
            SlidingWindowAssigner windowAssigner = SlidingWindowAssigner.of((Duration)hoppingWindowSpec.getSize(), (Duration)hoppingWindowSpec.getSlide());
            if (isProctime) {
                windowAssigner = windowAssigner.withProcessingTime();
            }
            if (hoppingWindowSpec.getOffset() != null) {
                windowAssigner = windowAssigner.withOffset(hoppingWindowSpec.getOffset());
            }
            return windowAssigner;
        }
        if (windowSpec instanceof CumulativeWindowSpec) {
            CumulativeWindowSpec cumulativeWindowSpec = (CumulativeWindowSpec)windowSpec;
            CumulativeWindowAssigner windowAssigner = CumulativeWindowAssigner.of((Duration)cumulativeWindowSpec.getMaxSize(), (Duration)cumulativeWindowSpec.getStep());
            if (isProctime) {
                windowAssigner = windowAssigner.withProcessingTime();
            }
            if (cumulativeWindowSpec.getOffset() != null) {
                windowAssigner = windowAssigner.withOffset(cumulativeWindowSpec.getOffset());
            }
            return windowAssigner;
        }
        throw new TableException(String.format("Unknown window spec: %s", windowSpec.getClass().getSimpleName()));
    }
}

