/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core;

import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.ProfileFetcher;
import org.apache.inlong.agent.core.HeartbeatManager;
import org.apache.inlong.agent.core.task.TaskManager;
import org.apache.inlong.common.pojo.agent.AgentConfigInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentManager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentManager.class);
    private final TaskManager taskManager;
    private final HeartbeatManager heartbeatManager;
    private final ProfileFetcher fetcher;
    private final AgentConfiguration conf = AgentConfiguration.getAgentConf();
    private final ExecutorService agentConfMonitor = Executors.newSingleThreadExecutor();
    private static AgentConfigInfo agentConfigInfo;

    public AgentManager() {
        this.taskManager = new TaskManager();
        this.fetcher = this.initFetcher(this);
        this.heartbeatManager = HeartbeatManager.getInstance(this);
    }

    public static AgentConfigInfo getAgentConfigInfo() {
        return agentConfigInfo;
    }

    public void subNewAgentConfigInfo(AgentConfigInfo info) {
        if (info == null) {
            return;
        }
        agentConfigInfo = info;
    }

    private ProfileFetcher initFetcher(AgentManager agentManager) {
        try {
            Constructor<?> constructor = Class.forName(this.conf.get("agent.fetcher.classname")).getDeclaredConstructor(AgentManager.class);
            constructor.setAccessible(true);
            return (ProfileFetcher)constructor.newInstance(new Object[]{agentManager});
        }
        catch (Exception ex) {
            LOGGER.warn("cannot find fetcher: ", (Throwable)ex);
            return null;
        }
    }

    private Runnable startHotConfReplace() {
        return new Runnable(){
            private long lastModifiedTime = 0L;

            @Override
            public void run() {
                Thread.currentThread().setName("agent-manager-hotConfReplace");
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(10000L);
                            long maxLastModifiedTime = AgentManager.this.conf.maxLastModifiedTime();
                            if (maxLastModifiedTime <= this.lastModifiedTime) continue;
                            AgentManager.this.conf.reloadFromLocalPropertiesFile();
                            this.lastModifiedTime = maxLastModifiedTime;
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Interrupted when flush agent conf.", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
    }

    public ProfileFetcher getFetcher() {
        return this.fetcher;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public HeartbeatManager getHeartbeatManager() {
        return this.heartbeatManager;
    }

    public void join() {
        super.join();
        this.taskManager.join();
    }

    public void start() throws Exception {
        LOGGER.info("starting agent manager");
        this.agentConfMonitor.submit(this.startHotConfReplace());
        LOGGER.info("starting task manager");
        this.taskManager.start();
        LOGGER.info("starting heartbeat manager");
        this.heartbeatManager.start();
        LOGGER.info("starting task position manager");
        LOGGER.info("starting read job from local");
        LOGGER.info("starting fetcher");
        if (this.fetcher != null) {
            this.fetcher.start();
        }
        LOGGER.info("starting agent manager end");
    }

    public void stop() throws Exception {
        if (this.fetcher != null) {
            this.fetcher.stop();
        }
        LOGGER.info("stopping agent manager");
        this.taskManager.stop();
        this.heartbeatManager.stop();
        this.agentConfMonitor.shutdown();
    }
}

