/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;

public class ComputationState {
    private final String currentStateName;
    private final DeweyNumber version;
    private final long startTimestamp;
    @Nullable
    private final NodeId previousBufferEntry;
    @Nullable
    private final EventId startEventID;

    private ComputationState(String currentState, @Nullable NodeId previousBufferEntry, DeweyNumber version, @Nullable EventId startEventID, long startTimestamp) {
        this.currentStateName = currentState;
        this.version = version;
        this.startTimestamp = startTimestamp;
        this.previousBufferEntry = previousBufferEntry;
        this.startEventID = startEventID;
    }

    public EventId getStartEventID() {
        return this.startEventID;
    }

    public NodeId getPreviousBufferEntry() {
        return this.previousBufferEntry;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public String getCurrentStateName() {
        return this.currentStateName;
    }

    public DeweyNumber getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComputationState) {
            ComputationState other = (ComputationState)obj;
            return Objects.equals(this.currentStateName, other.currentStateName) && Objects.equals(this.version, other.version) && this.startTimestamp == other.startTimestamp && Objects.equals(this.startEventID, other.startEventID) && Objects.equals(this.previousBufferEntry, other.previousBufferEntry);
        }
        return false;
    }

    public String toString() {
        return "ComputationState{currentStateName='" + this.currentStateName + '\'' + ", version=" + this.version + ", startTimestamp=" + this.startTimestamp + ", previousBufferEntry=" + this.previousBufferEntry + ", startEventID=" + this.startEventID + '}';
    }

    public int hashCode() {
        return Objects.hash(this.currentStateName, this.version, this.startTimestamp, this.startEventID, this.previousBufferEntry);
    }

    public static ComputationState createStartState(String state) {
        return ComputationState.createStartState(state, new DeweyNumber(1));
    }

    public static ComputationState createStartState(String state, DeweyNumber version) {
        return ComputationState.createState(state, null, version, -1L, null);
    }

    public static ComputationState createState(String currentState, NodeId previousEntry, DeweyNumber version, long startTimestamp, EventId startEventID) {
        return new ComputationState(currentState, previousEntry, version, startEventID, startTimestamp);
    }
}

