/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.compress.snappy.SnappyDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.HadoopShimsPre2_3;
import org.apache.orc.impl.ZeroCopyShims;

public class HadoopShimsPre2_6
implements HadoopShims {
    static HadoopShims.DirectDecompressor getDecompressor(HadoopShims.DirectCompressionType codec) {
        switch (codec) {
            case ZLIB: {
                return new ZlibDirectDecompressWrapper(new ZlibDecompressor.ZlibDirectDecompressor());
            }
            case ZLIB_NOHEADER: {
                return new ZlibDirectDecompressWrapper(new ZlibDecompressor.ZlibDirectDecompressor(ZlibDecompressor.CompressionHeader.NO_HEADER, 0));
            }
            case SNAPPY: {
                return new SnappyDirectDecompressWrapper(new SnappyDecompressor.SnappyDirectDecompressor());
            }
        }
        return null;
    }

    @Override
    public HadoopShims.DirectDecompressor getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        return HadoopShimsPre2_6.getDecompressor(codec);
    }

    @Override
    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        return ZeroCopyShims.getZeroCopyReader(in, pool);
    }

    @Override
    public boolean endVariableLengthBlock(OutputStream output) {
        return false;
    }

    @Override
    public HadoopShims.KeyProvider getKeyProvider(Configuration conf, Random random) {
        return new HadoopShimsPre2_3.NullKeyProvider();
    }

    static class ZlibDirectDecompressWrapper
    implements HadoopShims.DirectDecompressor {
        private final ZlibDecompressor.ZlibDirectDecompressor root;
        private boolean isFirstCall = true;

        ZlibDirectDecompressWrapper(ZlibDecompressor.ZlibDirectDecompressor root) {
            this.root = root;
        }

        @Override
        public void decompress(ByteBuffer input, ByteBuffer output) throws IOException {
            if (!this.isFirstCall) {
                this.root.reset();
            } else {
                this.isFirstCall = false;
            }
            this.root.decompress(input, output);
        }

        @Override
        public void reset() {
            this.root.reset();
        }

        @Override
        public void end() {
            this.root.end();
        }
    }

    static class SnappyDirectDecompressWrapper
    implements HadoopShims.DirectDecompressor {
        private final SnappyDecompressor.SnappyDirectDecompressor root;
        private boolean isFirstCall = true;

        SnappyDirectDecompressWrapper(SnappyDecompressor.SnappyDirectDecompressor root) {
            this.root = root;
        }

        @Override
        public void decompress(ByteBuffer input, ByteBuffer output) throws IOException {
            if (!this.isFirstCall) {
                this.root.reset();
            } else {
                this.isFirstCall = false;
            }
            this.root.decompress(input, output);
        }

        @Override
        public void reset() {
            this.root.reset();
        }

        @Override
        public void end() {
            this.root.end();
        }
    }
}

