/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.transform;

import io.swagger.annotations.ApiModel;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.stream.StreamTransform;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;

@ApiModel(value="StreamTransform with one pre stream node, such as filter, splitter, etc")
public class SingleDependencyTransform
extends StreamTransform {
    public SingleDependencyTransform(String transformName, TransformDefinition transformDefinition, String preNode) {
        Preconditions.expectNotNull((Object)transformDefinition, (String)"transform definition cannot be null");
        this.transformDefinition = transformDefinition;
        Preconditions.expectNotBlank((String)transformName, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"transform name cannot be null");
        this.transformName = transformName;
        Preconditions.expectNotBlank((String)preNode, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"pre nodes cannot be null");
        this.addPre(preNode);
    }

    public SingleDependencyTransform(String transformName, TransformDefinition transformDefinition, String preNode, String ... postNodes) {
        this(transformName, transformDefinition, preNode);
        if (postNodes != null) {
            for (String postNode : postNodes) {
                this.addPost(postNode);
            }
        }
    }

    public SingleDependencyTransform() {
    }
}

