/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.sdk.dataproxy.BaseMsgSenderFactory;
import org.apache.inlong.sdk.dataproxy.MsgSenderFactory;
import org.apache.inlong.sdk.dataproxy.exception.ProxySdkException;
import org.apache.inlong.sdk.dataproxy.network.PkgCacheQuota;
import org.apache.inlong.sdk.dataproxy.sender.BaseSender;
import org.apache.inlong.sdk.dataproxy.sender.http.HttpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.sender.http.InLongHttpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.tcp.InLongTcpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;

public class MsgSenderSingleFactory
implements MsgSenderFactory {
    private static final AtomicLong refCounter = new AtomicLong(0L);
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final AtomicLong singletonRefCounter = new AtomicLong(0L);
    private static BaseMsgSenderFactory baseMsgSenderFactory;

    public MsgSenderSingleFactory() {
        this(-1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsgSenderSingleFactory(int factoryPkgCntPermits, int factoryPkgSizeKbPermits) {
        AtomicLong atomicLong = singletonRefCounter;
        synchronized (atomicLong) {
            if (singletonRefCounter.incrementAndGet() == 1L) {
                baseMsgSenderFactory = new BaseMsgSenderFactory(this, "iSingleFct-" + ProxyUtils.getProcessPid() + "-" + refCounter.incrementAndGet(), factoryPkgCntPermits, factoryPkgSizeKbPermits);
                initialized.set(true);
            }
        }
        while (!initialized.get()) {
            ProxyUtils.sleepSomeTime(50L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownAll() {
        BaseMsgSenderFactory tmpFactory;
        AtomicLong atomicLong = singletonRefCounter;
        synchronized (atomicLong) {
            if (!initialized.get() || singletonRefCounter.decrementAndGet() > 0L) {
                return;
            }
            tmpFactory = baseMsgSenderFactory;
            baseMsgSenderFactory = null;
            initialized.set(false);
        }
        if (tmpFactory != null) {
            tmpFactory.close();
        }
    }

    @Override
    public void removeClient(BaseSender msgSender) {
        if (msgSender == null || msgSender.getSenderFactory() == null || msgSender.getSenderFactory() != this) {
            return;
        }
        if (baseMsgSenderFactory == null) {
            return;
        }
        baseMsgSenderFactory.removeClient(msgSender);
    }

    @Override
    public int getMsgSenderCount() {
        if (baseMsgSenderFactory == null) {
            return -1;
        }
        return baseMsgSenderFactory.getMsgSenderCount();
    }

    @Override
    public PkgCacheQuota getFactoryPkgCacheQuota() {
        if (baseMsgSenderFactory == null) {
            return null;
        }
        return baseMsgSenderFactory.getPkgCacheQuota();
    }

    @Override
    public InLongTcpMsgSender genTcpSenderByGroupId(TcpMsgSenderConfig configure) throws ProxySdkException {
        return this.genTcpSenderByGroupId(configure, null);
    }

    @Override
    public InLongTcpMsgSender genTcpSenderByGroupId(TcpMsgSenderConfig configure, ThreadFactory selfDefineFactory) throws ProxySdkException {
        if (!initialized.get()) {
            throw new ProxySdkException("Please initialize the factory first!");
        }
        return baseMsgSenderFactory.genTcpSenderByGroupId(configure, selfDefineFactory);
    }

    @Override
    public InLongTcpMsgSender genTcpSenderByClusterId(TcpMsgSenderConfig configure) throws ProxySdkException {
        return this.genTcpSenderByClusterId(configure, null);
    }

    @Override
    public InLongTcpMsgSender genTcpSenderByClusterId(TcpMsgSenderConfig configure, ThreadFactory selfDefineFactory) throws ProxySdkException {
        if (!initialized.get()) {
            throw new ProxySdkException("Please initialize the factory first!");
        }
        return baseMsgSenderFactory.genTcpSenderByClusterId(configure, selfDefineFactory);
    }

    @Override
    public InLongHttpMsgSender genHttpSenderByGroupId(HttpMsgSenderConfig configure) throws ProxySdkException {
        if (!initialized.get()) {
            throw new ProxySdkException("Please initialize the factory first!");
        }
        return baseMsgSenderFactory.genHttpSenderByGroupId(configure);
    }

    @Override
    public InLongHttpMsgSender genHttpSenderByClusterId(HttpMsgSenderConfig configure) throws ProxySdkException {
        if (!initialized.get()) {
            throw new ProxySdkException("Please initialize the factory first!");
        }
        return baseMsgSenderFactory.genHttpSenderByClusterId(configure);
    }
}

