/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.AsynchronousNonBlocking;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.config.AsynchronousNonBlockingConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class AsynchronousNonBlockingConfigImpl
implements AsynchronousNonBlockingConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final boolean onMethod;
    private final String description;
    private final String configKey;
    private final AsynchronousNonBlocking instance;

    private AsynchronousNonBlockingConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(AsynchronousNonBlocking.class);
        this.description = method.method.toString();
        this.configKey = this.onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.asynchronousNonBlocking;
    }

    public static AsynchronousNonBlockingConfigImpl create(FaultToleranceMethod method) {
        if (method.asynchronousNonBlocking == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled((String)"asynchronous-non-blocking.enabled", (String)"AsynchronousNonBlocking/enabled", (MethodDescriptor)method.method)) {
            return null;
        }
        return new AsynchronousNonBlockingConfigImpl(method);
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return AsynchronousNonBlocking.class;
    }

    public void materialize() {
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @AsynchronousNonBlocking on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @AsynchronousNonBlocking." + member + " on " + this.description + ": " + reason);
    }
}

