/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Duration;
import com.google.re2j.Pattern;
import io.grpc.Status;
import io.grpc.xds.AutoValue_VirtualHost;
import io.grpc.xds.AutoValue_VirtualHost_Route;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteAction;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteAction_ClusterWeight;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteAction_HashPolicy;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteAction_RetryPolicy;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteMatch;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteMatch_PathMatcher;
import io.grpc.xds.ClusterSpecifierPlugin;
import io.grpc.xds.Filter;
import io.grpc.xds.internal.Matchers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
abstract class VirtualHost {
    VirtualHost() {
    }

    abstract String name();

    abstract ImmutableList<String> domains();

    abstract ImmutableList<Route> routes();

    abstract ImmutableMap<String, Filter.FilterConfig> filterConfigOverrides();

    public static VirtualHost create(String name, List<String> domains, List<Route> routes, Map<String, Filter.FilterConfig> filterConfigOverrides) {
        return new AutoValue_VirtualHost(name, (ImmutableList<String>)ImmutableList.copyOf(domains), (ImmutableList<Route>)ImmutableList.copyOf(routes), (ImmutableMap<String, Filter.FilterConfig>)ImmutableMap.copyOf(filterConfigOverrides));
    }

    @AutoValue
    static abstract class Route {
        Route() {
        }

        abstract RouteMatch routeMatch();

        @Nullable
        abstract RouteAction routeAction();

        abstract ImmutableMap<String, Filter.FilterConfig> filterConfigOverrides();

        static Route forAction(RouteMatch routeMatch, RouteAction routeAction, Map<String, Filter.FilterConfig> filterConfigOverrides) {
            return Route.create(routeMatch, routeAction, filterConfigOverrides);
        }

        static Route forNonForwardingAction(RouteMatch routeMatch, Map<String, Filter.FilterConfig> filterConfigOverrides) {
            return Route.create(routeMatch, null, filterConfigOverrides);
        }

        private static Route create(RouteMatch routeMatch, @Nullable RouteAction routeAction, Map<String, Filter.FilterConfig> filterConfigOverrides) {
            return new AutoValue_VirtualHost_Route(routeMatch, routeAction, (ImmutableMap<String, Filter.FilterConfig>)ImmutableMap.copyOf(filterConfigOverrides));
        }

        @AutoValue
        static abstract class RouteAction {
            RouteAction() {
            }

            abstract ImmutableList<HashPolicy> hashPolicies();

            @Nullable
            abstract Long timeoutNano();

            @Nullable
            abstract String cluster();

            @Nullable
            abstract ImmutableList<ClusterWeight> weightedClusters();

            @Nullable
            abstract ClusterSpecifierPlugin.NamedPluginConfig namedClusterSpecifierPluginConfig();

            @Nullable
            abstract RetryPolicy retryPolicy();

            abstract boolean autoHostRewrite();

            static RouteAction forCluster(String cluster, List<HashPolicy> hashPolicies, @Nullable Long timeoutNano, @Nullable RetryPolicy retryPolicy, boolean autoHostRewrite) {
                Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
                return RouteAction.create(hashPolicies, timeoutNano, cluster, null, null, retryPolicy, autoHostRewrite);
            }

            static RouteAction forWeightedClusters(List<ClusterWeight> weightedClusters, List<HashPolicy> hashPolicies, @Nullable Long timeoutNano, @Nullable RetryPolicy retryPolicy, boolean autoHostRewrite) {
                Preconditions.checkNotNull(weightedClusters, (Object)"weightedClusters");
                Preconditions.checkArgument((!weightedClusters.isEmpty() ? 1 : 0) != 0, (Object)"empty cluster list");
                return RouteAction.create(hashPolicies, timeoutNano, null, weightedClusters, null, retryPolicy, autoHostRewrite);
            }

            static RouteAction forClusterSpecifierPlugin(ClusterSpecifierPlugin.NamedPluginConfig namedConfig, List<HashPolicy> hashPolicies, @Nullable Long timeoutNano, @Nullable RetryPolicy retryPolicy, boolean autoHostRewrite) {
                Preconditions.checkNotNull((Object)namedConfig, (Object)"namedConfig");
                return RouteAction.create(hashPolicies, timeoutNano, null, null, namedConfig, retryPolicy, autoHostRewrite);
            }

            private static RouteAction create(List<HashPolicy> hashPolicies, @Nullable Long timeoutNano, @Nullable String cluster, @Nullable List<ClusterWeight> weightedClusters, @Nullable ClusterSpecifierPlugin.NamedPluginConfig namedConfig, @Nullable RetryPolicy retryPolicy, boolean autoHostRewrite) {
                return new AutoValue_VirtualHost_Route_RouteAction((ImmutableList<HashPolicy>)ImmutableList.copyOf(hashPolicies), timeoutNano, cluster, (ImmutableList<ClusterWeight>)(weightedClusters == null ? null : ImmutableList.copyOf(weightedClusters)), namedConfig, retryPolicy, autoHostRewrite);
            }

            @AutoValue
            static abstract class RetryPolicy {
                RetryPolicy() {
                }

                abstract int maxAttempts();

                abstract ImmutableList<Status.Code> retryableStatusCodes();

                abstract Duration initialBackoff();

                abstract Duration maxBackoff();

                @Nullable
                abstract Duration perAttemptRecvTimeout();

                static RetryPolicy create(int maxAttempts, List<Status.Code> retryableStatusCodes, Duration initialBackoff, Duration maxBackoff, @Nullable Duration perAttemptRecvTimeout) {
                    return new AutoValue_VirtualHost_Route_RouteAction_RetryPolicy(maxAttempts, (ImmutableList<Status.Code>)ImmutableList.copyOf(retryableStatusCodes), initialBackoff, maxBackoff, perAttemptRecvTimeout);
                }
            }

            @AutoValue
            static abstract class HashPolicy {
                HashPolicy() {
                }

                abstract Type type();

                abstract boolean isTerminal();

                @Nullable
                abstract String headerName();

                @Nullable
                abstract Pattern regEx();

                @Nullable
                abstract String regExSubstitution();

                static HashPolicy forHeader(boolean isTerminal, String headerName, @Nullable Pattern regEx, @Nullable String regExSubstitution) {
                    Preconditions.checkNotNull((Object)headerName, (Object)"headerName");
                    return HashPolicy.create(Type.HEADER, isTerminal, headerName, regEx, regExSubstitution);
                }

                static HashPolicy forChannelId(boolean isTerminal) {
                    return HashPolicy.create(Type.CHANNEL_ID, isTerminal, null, null, null);
                }

                private static HashPolicy create(Type type, boolean isTerminal, @Nullable String headerName, @Nullable Pattern regEx, @Nullable String regExSubstitution) {
                    return new AutoValue_VirtualHost_Route_RouteAction_HashPolicy(type, isTerminal, headerName, regEx, regExSubstitution);
                }

                static enum Type {
                    HEADER,
                    CHANNEL_ID;

                }
            }

            @AutoValue
            static abstract class ClusterWeight {
                ClusterWeight() {
                }

                abstract String name();

                abstract int weight();

                abstract ImmutableMap<String, Filter.FilterConfig> filterConfigOverrides();

                static ClusterWeight create(String name, int weight, Map<String, Filter.FilterConfig> filterConfigOverrides) {
                    return new AutoValue_VirtualHost_Route_RouteAction_ClusterWeight(name, weight, (ImmutableMap<String, Filter.FilterConfig>)ImmutableMap.copyOf(filterConfigOverrides));
                }
            }
        }

        @AutoValue
        static abstract class RouteMatch {
            RouteMatch() {
            }

            abstract PathMatcher pathMatcher();

            abstract ImmutableList<Matchers.HeaderMatcher> headerMatchers();

            @Nullable
            abstract Matchers.FractionMatcher fractionMatcher();

            @VisibleForTesting
            static RouteMatch withPathExactOnly(String path) {
                return RouteMatch.create(PathMatcher.fromPath(path, true), Collections.emptyList(), null);
            }

            static RouteMatch create(PathMatcher pathMatcher, List<Matchers.HeaderMatcher> headerMatchers, @Nullable Matchers.FractionMatcher fractionMatcher) {
                return new AutoValue_VirtualHost_Route_RouteMatch(pathMatcher, (ImmutableList<Matchers.HeaderMatcher>)ImmutableList.copyOf(headerMatchers), fractionMatcher);
            }

            @AutoValue
            static abstract class PathMatcher {
                PathMatcher() {
                }

                @Nullable
                abstract String path();

                @Nullable
                abstract String prefix();

                @Nullable
                abstract Pattern regEx();

                abstract boolean caseSensitive();

                static PathMatcher fromPath(String path, boolean caseSensitive) {
                    Preconditions.checkNotNull((Object)path, (Object)"path");
                    return PathMatcher.create(path, null, null, caseSensitive);
                }

                static PathMatcher fromPrefix(String prefix, boolean caseSensitive) {
                    Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
                    return PathMatcher.create(null, prefix, null, caseSensitive);
                }

                static PathMatcher fromRegEx(Pattern regEx) {
                    Preconditions.checkNotNull((Object)regEx, (Object)"regEx");
                    return PathMatcher.create(null, null, regEx, false);
                }

                private static PathMatcher create(@Nullable String path, @Nullable String prefix, @Nullable Pattern regEx, boolean caseSensitive) {
                    return new AutoValue_VirtualHost_Route_RouteMatch_PathMatcher(path, prefix, regEx, caseSensitive);
                }
            }
        }
    }
}

