/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.transactional;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.entity.AsyncTaskType;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisChangeTrackingVersions;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.entity.PolarisPrivilege;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.entity.PrincipalRoleEntity;
import org.apache.polaris.core.persistence.BaseMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisObjectMapperUtil;
import org.apache.polaris.core.persistence.PolicyMappingAlreadyExistsException;
import org.apache.polaris.core.persistence.RetryOnConcurrencyException;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.ChangeTrackingResult;
import org.apache.polaris.core.persistence.dao.entity.CreateCatalogResult;
import org.apache.polaris.core.persistence.dao.entity.CreatePrincipalResult;
import org.apache.polaris.core.persistence.dao.entity.DropEntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntitiesResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntityWithPath;
import org.apache.polaris.core.persistence.dao.entity.ListEntitiesResult;
import org.apache.polaris.core.persistence.dao.entity.LoadGrantsResult;
import org.apache.polaris.core.persistence.dao.entity.LoadPolicyMappingsResult;
import org.apache.polaris.core.persistence.dao.entity.PolicyAttachmentResult;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import org.apache.polaris.core.persistence.dao.entity.PrivilegeResult;
import org.apache.polaris.core.persistence.dao.entity.ResolvedEntityResult;
import org.apache.polaris.core.persistence.dao.entity.ScopedCredentialsResult;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.transactional.PolarisEntityResolver;
import org.apache.polaris.core.persistence.transactional.TransactionalPersistence;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;
import org.apache.polaris.core.policy.PolicyEntity;
import org.apache.polaris.core.policy.PolicyMappingUtil;
import org.apache.polaris.core.policy.PolicyType;
import org.apache.polaris.core.storage.AccessConfig;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalMetaStoreManagerImpl
extends BaseMetaStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalMetaStoreManagerImpl.class);
    private final Clock clock;

    public TransactionalMetaStoreManagerImpl(Clock clock, PolarisDiagnostics diagnostics) {
        super(diagnostics);
        this.clock = clock;
    }

    protected void persistNewEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisBaseEntity entity) {
        entity = this.prepareToPersistNewEntity(callCtx, ms, entity);
        ms.writeEntityInCurrentTxn(callCtx, entity, true, null);
    }

    @Nonnull
    private PolarisBaseEntity persistEntityAfterChange(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisBaseEntity entity, boolean nameOrParentChanged, @Nonnull PolarisBaseEntity originalEntity) {
        entity = this.prepareToPersistEntityAfterChange(callCtx, ms, entity, nameOrParentChanged, originalEntity);
        ms.writeEntityInCurrentTxn(callCtx, entity, nameOrParentChanged, originalEntity);
        return entity;
    }

    private void dropEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisBaseEntity entity) {
        this.getDiagnostics().checkNotNull(entity, "unexpected_null_dpo");
        this.getDiagnostics().checkNotNull(entity.getName(), "unexpected_null_name");
        this.getDiagnostics().check(entity.getDropTimestamp() == 0L, "already_dropped");
        List<PolarisGrantRecord> grantsOnGrantee = entity.getType().isGrantee() ? ms.loadAllGrantRecordsOnGranteeInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId()) : List.of();
        List<PolarisGrantRecord> grantsOnSecurable = ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId());
        ms.deleteAllEntityGrantRecordsInCurrentTxn(callCtx, entity, grantsOnGrantee, grantsOnSecurable);
        HashSet entityIdsGrantChanged = new HashSet();
        grantsOnGrantee.forEach(gr -> entityIdsGrantChanged.add(new PolarisEntityId(gr.getSecurableCatalogId(), gr.getSecurableId())));
        grantsOnSecurable.forEach(gr -> entityIdsGrantChanged.add(new PolarisEntityId(gr.getGranteeCatalogId(), gr.getGranteeId())));
        List<PolarisBaseEntity> entities = ms.lookupEntitiesInCurrentTxn(callCtx, new ArrayList<PolarisEntityId>(entityIdsGrantChanged));
        for (PolarisBaseEntity originalEntity : entities) {
            PolarisBaseEntity entityGrantChanged = originalEntity.withGrantRecordsVersion(originalEntity.getGrantRecordsVersion() + 1);
            ms.writeEntityInCurrentTxn(callCtx, entityGrantChanged, false, originalEntity);
        }
        if (entity.getType() == PolarisEntityType.POLICY || PolicyMappingUtil.isValidTargetEntityType(entity.getType(), entity.getSubType())) {
            try {
                List<PolarisPolicyMappingRecord> mappingOnPolicy = entity.getType() == PolarisEntityType.POLICY ? ms.loadAllTargetsOnPolicyInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId(), PolicyEntity.of(entity).getPolicyTypeCode()) : List.of();
                List<PolarisPolicyMappingRecord> mappingOnTarget = entity.getType() == PolarisEntityType.POLICY ? List.of() : ms.loadAllPoliciesOnTargetInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId());
                ms.deleteAllEntityPolicyMappingRecordsInCurrentTxn(callCtx, entity, mappingOnTarget, mappingOnPolicy);
            }
            catch (UnsupportedOperationException mappingOnPolicy) {
                // empty catch block
            }
        }
        ms.deleteEntityInCurrentTxn(callCtx, entity);
        if (entity.getType() == PolarisEntityType.PRINCIPAL) {
            PrincipalEntity principalEntity = PrincipalEntity.of(entity);
            String clientId = principalEntity.getClientId();
            ms.deletePrincipalSecretsInCurrentTxn(callCtx, clientId, entity.getId());
        }
    }

    @Nonnull
    private PolarisGrantRecord persistNewGrantRecord(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore securable, @Nonnull PolarisEntityCore grantee, @Nonnull PolarisPrivilege priv) {
        this.getDiagnostics().checkNotNull(securable, "unexpected_null_securable");
        this.getDiagnostics().checkNotNull(grantee, "unexpected_null_grantee");
        this.getDiagnostics().checkNotNull(priv, "unexpected_null_priv");
        this.getDiagnostics().check(grantee.getType().isGrantee(), "entity_must_be_grantee", "entity={}", grantee);
        PolarisGrantRecord grantRecord = new PolarisGrantRecord(securable.getCatalogId(), securable.getId(), grantee.getCatalogId(), grantee.getId(), priv.getCode());
        ms.writeToGrantRecordsInCurrentTxn(callCtx, grantRecord);
        PolarisBaseEntity granteeEntity = ms.lookupEntityInCurrentTxn(callCtx, grantee.getCatalogId(), grantee.getId(), grantee.getTypeCode());
        this.getDiagnostics().checkNotNull(granteeEntity, "grantee_not_found", "grantee={}", grantee);
        PolarisBaseEntity updatedGranteeEntity = granteeEntity.withGrantRecordsVersion(granteeEntity.getGrantRecordsVersion() + 1);
        ms.writeEntityInCurrentTxn(callCtx, updatedGranteeEntity, false, granteeEntity);
        PolarisBaseEntity securableEntity = ms.lookupEntityInCurrentTxn(callCtx, securable.getCatalogId(), securable.getId(), securable.getTypeCode());
        this.getDiagnostics().checkNotNull(securableEntity, "securable_not_found", "securable={}", securable);
        PolarisBaseEntity updatedSecurableEntity = new PolarisBaseEntity.Builder(securableEntity).grantRecordsVersion(securableEntity.getGrantRecordsVersion() + 1).build();
        ms.writeEntityInCurrentTxn(callCtx, updatedSecurableEntity, false, securableEntity);
        return grantRecord;
    }

    private void revokeGrantRecord(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore securable, @Nonnull PolarisEntityCore grantee, @Nonnull PolarisGrantRecord grantRecord) {
        this.getDiagnostics().check(securable.getCatalogId() == grantRecord.getSecurableCatalogId() && securable.getId() == grantRecord.getSecurableId(), "securable_mismatch", "securable={} grantRec={}", securable, grantRecord);
        this.getDiagnostics().check(grantee.getCatalogId() == grantRecord.getGranteeCatalogId() && grantee.getId() == grantRecord.getGranteeId(), "grantee_mismatch", "grantee={} grantRec={}", grantee, grantRecord);
        this.getDiagnostics().check(grantee.getType().isGrantee(), "not_a_grantee", "grantee={}", grantee);
        ms.deleteFromGrantRecordsInCurrentTxn(callCtx, grantRecord);
        PolarisBaseEntity refreshGrantee = ms.lookupEntityInCurrentTxn(callCtx, grantee.getCatalogId(), grantee.getId(), grantee.getTypeCode());
        this.getDiagnostics().checkNotNull(refreshGrantee, "missing_grantee", "grantRecord={} grantee={}", grantRecord, grantee);
        PolarisBaseEntity updatedRefreshGrantee = refreshGrantee.withGrantRecordsVersion(refreshGrantee.getGrantRecordsVersion() + 1);
        ms.writeEntityInCurrentTxn(callCtx, updatedRefreshGrantee, false, refreshGrantee);
        PolarisBaseEntity refreshSecurable = ms.lookupEntityInCurrentTxn(callCtx, securable.getCatalogId(), securable.getId(), securable.getTypeCode());
        this.getDiagnostics().checkNotNull(refreshSecurable, "missing_securable", "grantRecord={} securable={}", grantRecord, securable);
        PolarisBaseEntity updatedRefreshSecurable = refreshSecurable.withGrantRecordsVersion(refreshSecurable.getGrantRecordsVersion() + 1);
        ms.writeEntityInCurrentTxn(callCtx, updatedRefreshSecurable, false, refreshSecurable);
    }

    @Nonnull
    private CreateCatalogResult createCatalog(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisBaseEntity catalog, @Nullable PolarisStorageIntegration<?> integration, @Nonnull List<PolarisEntityCore> principalRoles) {
        this.getDiagnostics().checkNotNull(catalog, "unexpected_null_catalog");
        PolarisBaseEntity refreshCatalog = ms.lookupEntityInCurrentTxn(callCtx, catalog.getCatalogId(), catalog.getId(), catalog.getTypeCode());
        if (refreshCatalog != null) {
            this.getDiagnostics().check(refreshCatalog.getTypeCode() == PolarisEntityType.CATALOG.getCode(), "not_a_catalog", "catalog={}", catalog);
            PolarisBaseEntity catalogAdminRole = ms.lookupEntityByNameInCurrentTxn(callCtx, refreshCatalog.getId(), refreshCatalog.getId(), PolarisEntityType.CATALOG_ROLE.getCode(), PolarisEntityConstants.getNameOfCatalogAdminRole());
            this.getDiagnostics().checkNotNull(catalogAdminRole, "catalog_admin_role_not_found", "catalog={}", refreshCatalog);
            return new CreateCatalogResult(refreshCatalog, catalogAdminRole);
        }
        if (ms.lookupEntityIdAndSubTypeByNameInCurrentTxn(callCtx, PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.CATALOG.getCode(), catalog.getName()) != null) {
            return new CreateCatalogResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, null);
        }
        ms.persistStorageIntegrationIfNeededInCurrentTxn(callCtx, catalog, integration);
        this.persistNewEntity(callCtx, ms, catalog);
        long adminRoleId = ms.generateNewIdInCurrentTxn(callCtx);
        PolarisBaseEntity adminRole = new PolarisBaseEntity(catalog.getId(), adminRoleId, PolarisEntityType.CATALOG_ROLE, PolarisEntitySubType.NULL_SUBTYPE, catalog.getId(), PolarisEntityConstants.getNameOfCatalogAdminRole());
        this.persistNewEntity(callCtx, ms, adminRole);
        this.persistNewGrantRecord(callCtx, ms, catalog, adminRole, PolarisPrivilege.CATALOG_MANAGE_ACCESS);
        this.persistNewGrantRecord(callCtx, ms, catalog, adminRole, PolarisPrivilege.CATALOG_MANAGE_METADATA);
        if (principalRoles.isEmpty()) {
            PolarisBaseEntity serviceAdminRole = ms.lookupEntityByNameInCurrentTxn(callCtx, PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.PRINCIPAL_ROLE.getCode(), PolarisEntityConstants.getNameOfPrincipalServiceAdminRole());
            this.getDiagnostics().checkNotNull(serviceAdminRole, "missing_service_admin_role");
            this.persistNewGrantRecord(callCtx, ms, adminRole, serviceAdminRole, PolarisPrivilege.CATALOG_ROLE_USAGE);
        } else {
            for (PolarisEntityCore principalRole : principalRoles) {
                this.getDiagnostics().checkNotNull(principalRole, "null principal role");
                this.getDiagnostics().check(principalRole.getTypeCode() == PolarisEntityType.PRINCIPAL_ROLE.getCode(), "not_principal_role", "type={}", new Object[]{principalRole.getType()});
                this.persistNewGrantRecord(callCtx, ms, adminRole, principalRole, PolarisPrivilege.CATALOG_ROLE_USAGE);
            }
        }
        return new CreateCatalogResult(catalog, adminRole);
    }

    private void bootstrapPolarisService(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms) {
        PolarisBaseEntity rootContainer = new PolarisBaseEntity(PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.ROOT, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootEntityId(), PolarisEntityConstants.getRootContainerName());
        this.persistNewEntity(callCtx, ms, rootContainer);
        long rootPrincipalId = ms.generateNewIdInCurrentTxn(callCtx);
        PrincipalEntity rootPrincipal = ((PrincipalEntity.Builder)((PrincipalEntity.Builder)((PrincipalEntity.Builder)new PrincipalEntity.Builder().setId(rootPrincipalId)).setName(PolarisEntityConstants.getRootPrincipalName())).setCreateTimestamp(System.currentTimeMillis())).build();
        this.createPrincipal(callCtx, ms, rootPrincipal);
        long serviceAdminPrincipalRoleId = ms.generateNewIdInCurrentTxn(callCtx);
        PrincipalRoleEntity serviceAdminPrincipalRole = ((PrincipalRoleEntity.Builder)((PrincipalRoleEntity.Builder)((PrincipalRoleEntity.Builder)new PrincipalRoleEntity.Builder().setId(serviceAdminPrincipalRoleId)).setName(PolarisEntityConstants.getNameOfPrincipalServiceAdminRole())).setCreateTimestamp(System.currentTimeMillis())).build();
        this.persistNewEntity(callCtx, ms, serviceAdminPrincipalRole);
        this.persistNewGrantRecord(callCtx, ms, serviceAdminPrincipalRole, rootPrincipal, PolarisPrivilege.PRINCIPAL_ROLE_USAGE);
        this.persistNewGrantRecord(callCtx, ms, rootContainer, serviceAdminPrincipalRole, PolarisPrivilege.SERVICE_MANAGE_ACCESS);
    }

    @Override
    @Nonnull
    public BaseResult bootstrapPolarisService(@Nonnull PolarisCallContext callCtx) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        ms.runActionInTransaction(callCtx, () -> this.bootstrapPolarisService(callCtx, ms));
        return new BaseResult(BaseResult.ReturnStatus.SUCCESS);
    }

    @Override
    @Nonnull
    public BaseResult purge(@Nonnull PolarisCallContext callCtx) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        LOGGER.warn("Deleting all metadata in the metastore...");
        ms.runActionInTransaction(callCtx, () -> ms.deleteAllInCurrentTxn(callCtx));
        LOGGER.warn("Finished deleting all metadata in the metastore");
        return new BaseResult(BaseResult.ReturnStatus.SUCCESS);
    }

    @Nonnull
    private EntityResult readEntityByName(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull String name) {
        PolarisEntityResolver resolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, catalogPath);
        if (resolver.isFailure()) {
            return new EntityResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null);
        }
        PolarisBaseEntity entity = ms.lookupEntityByNameInCurrentTxn(callCtx, resolver.getCatalogIdOrNull(), resolver.getParentId(), entityType.getCode(), name);
        if (entity != null && entitySubType != PolarisEntitySubType.ANY_SUBTYPE && entity.getSubTypeCode() != entitySubType.getCode()) {
            entity = null;
        }
        return entity == null ? new EntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null) : new EntityResult(entity);
    }

    @Override
    @Nonnull
    public EntityResult readEntityByName(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull String name) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.readEntityByName(callCtx, ms, catalogPath, entityType, entitySubType, name));
    }

    @Nonnull
    private ListEntitiesResult listEntities(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        PolarisEntityResolver resolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, catalogPath);
        if (resolver.isFailure()) {
            return new ListEntitiesResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null);
        }
        Page<EntityNameLookupRecord> resultPage = ms.listEntitiesInCurrentTxn(callCtx, resolver.getCatalogIdOrNull(), resolver.getParentId(), entityType, entitySubType, pageToken);
        return ListEntitiesResult.fromPage(resultPage);
    }

    @Override
    @Nonnull
    public ListEntitiesResult listEntities(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.listEntities(callCtx, ms, catalogPath, entityType, entitySubType, pageToken));
    }

    @Nonnull
    private Page<PolarisBaseEntity> loadEntities(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        PolarisEntityResolver resolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, catalogPath);
        if (resolver.isFailure()) {
            throw new IllegalArgumentException("Failed to resolve catalogPath: " + String.valueOf(catalogPath));
        }
        return ms.loadEntitiesInCurrentTxn(callCtx, resolver.getCatalogIdOrNull(), resolver.getParentId(), entityType, entitySubType, entity -> true, Function.identity(), pageToken);
    }

    @Override
    @Nonnull
    public Page<PolarisBaseEntity> loadEntities(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.loadEntities(callCtx, ms, catalogPath, entityType, entitySubType, pageToken));
    }

    @Nonnull
    private CreatePrincipalResult createPrincipal(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PrincipalEntity principal) {
        this.getDiagnostics().checkNotNull(principal, "unexpected_null_principal");
        PrincipalEntity refreshPrincipal = PrincipalEntity.of(ms.lookupEntityInCurrentTxn(callCtx, principal.getCatalogId(), principal.getId(), principal.getTypeCode()));
        if (refreshPrincipal != null) {
            String clientId = refreshPrincipal.getClientId();
            this.getDiagnostics().checkNotNull(clientId, "null_client_id", "principal={}", refreshPrincipal);
            this.getDiagnostics().check(!clientId.isEmpty(), "empty_client_id", "principal={}", refreshPrincipal);
            PolarisPrincipalSecrets principalSecrets = ms.loadPrincipalSecretsInCurrentTxn(callCtx, clientId);
            this.getDiagnostics().checkNotNull(principalSecrets, "missing_principal_secrets", "clientId={} principal={}", clientId, refreshPrincipal);
            return new CreatePrincipalResult(refreshPrincipal, principalSecrets);
        }
        if (ms.lookupEntityIdAndSubTypeByNameInCurrentTxn(callCtx, PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.PRINCIPAL.getCode(), principal.getName()) != null) {
            return new CreatePrincipalResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, null);
        }
        PolarisPrincipalSecrets principalSecrets = ms.generateNewPrincipalSecretsInCurrentTxn(callCtx, principal.getName(), principal.getId());
        PrincipalEntity updatedPrincipal = new PrincipalEntity.Builder(principal).setClientId(principalSecrets.getPrincipalClientId()).build();
        this.persistNewEntity(callCtx, ms, updatedPrincipal);
        return new CreatePrincipalResult(updatedPrincipal, principalSecrets);
    }

    @Override
    @Nonnull
    public CreatePrincipalResult createPrincipal(@Nonnull PolarisCallContext callCtx, @Nonnull PrincipalEntity principal) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.createPrincipal(callCtx, ms, principal));
    }

    @Nullable
    private PolarisPrincipalSecrets loadPrincipalSecrets(@Nonnull PolarisCallContext callCtx, TransactionalPersistence ms, @Nonnull String clientId) {
        return ms.loadPrincipalSecretsInCurrentTxn(callCtx, clientId);
    }

    @Override
    @Nonnull
    public PrincipalSecretsResult loadPrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        PolarisPrincipalSecrets secrets = ms.runInTransaction(callCtx, () -> this.loadPrincipalSecrets(callCtx, ms, clientId));
        return secrets == null ? new PrincipalSecretsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null) : new PrincipalSecretsResult(secrets);
    }

    @Override
    @Nonnull
    public void deletePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        ms.deletePrincipalSecrets(callCtx, clientId, principalId);
    }

    @Nullable
    private PolarisPrincipalSecrets rotatePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull String clientId, long principalId, boolean reset, @Nonnull String oldSecretHash) {
        EntityResult loadEntityResult = this.loadEntity(callCtx, ms, PolarisEntityConstants.getNullId(), principalId, PolarisEntityType.PRINCIPAL.getCode());
        if (loadEntityResult.getReturnStatus() != BaseResult.ReturnStatus.SUCCESS) {
            return null;
        }
        PolarisBaseEntity principal = loadEntityResult.getEntity();
        PolarisBaseEntity.Builder principalBuilder = new PolarisBaseEntity.Builder(principal);
        Map<String, String> internalProps = principal.getInternalPropertiesAsMap();
        boolean doReset = reset || internalProps.get("CREDENTIAL_ROTATION_REQUIRED") != null;
        PolarisPrincipalSecrets secrets = ms.rotatePrincipalSecretsInCurrentTxn(callCtx, clientId, principalId, doReset, oldSecretHash);
        if (reset && !internalProps.containsKey("CREDENTIAL_ROTATION_REQUIRED")) {
            internalProps.put("CREDENTIAL_ROTATION_REQUIRED", "true");
            principalBuilder.internalPropertiesAsMap(internalProps);
            principalBuilder.entityVersion(principal.getEntityVersion() + 1);
            ms.writeEntityInCurrentTxn(callCtx, principalBuilder.build(), true, principal);
        } else if (internalProps.containsKey("CREDENTIAL_ROTATION_REQUIRED")) {
            internalProps.remove("CREDENTIAL_ROTATION_REQUIRED");
            principalBuilder.internalPropertiesAsMap(internalProps);
            principalBuilder.entityVersion(principal.getEntityVersion() + 1);
            ms.writeEntityInCurrentTxn(callCtx, principalBuilder.build(), true, principal);
        }
        return secrets;
    }

    @Override
    @Nonnull
    public PrincipalSecretsResult rotatePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId, boolean reset, @Nonnull String oldSecretHash) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        PolarisPrincipalSecrets secrets = ms.runInTransaction(callCtx, () -> this.rotatePrincipalSecrets(callCtx, ms, clientId, principalId, reset, oldSecretHash));
        return secrets == null ? new PrincipalSecretsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null) : new PrincipalSecretsResult(secrets);
    }

    @Nullable
    private PolarisPrincipalSecrets resetPrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull String clientId, long principalId, String customClientId, String customClientSecret) {
        PolarisPrincipalSecrets secrets = ms.storePrincipalSecrets(callCtx, principalId, customClientId, customClientSecret);
        return secrets;
    }

    @Override
    @Nonnull
    public PrincipalSecretsResult resetPrincipalSecrets(@Nonnull PolarisCallContext callCtx, long principalId, @Nonnull String resolvedClientId, String customClientSecret) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        EntityResult loadEntityResult = this.loadEntity(callCtx, PolarisEntityConstants.getNullId(), principalId, PolarisEntityType.PRINCIPAL);
        if (loadEntityResult.getReturnStatus() != BaseResult.ReturnStatus.SUCCESS) {
            return new PrincipalSecretsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        PolarisPrincipalSecrets secrets = ms.runInTransaction(callCtx, () -> this.resetPrincipalSecrets(callCtx, ms, resolvedClientId, principalId, resolvedClientId, customClientSecret));
        return secrets == null ? new PrincipalSecretsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null) : new PrincipalSecretsResult(secrets);
    }

    @Override
    @Nonnull
    public CreateCatalogResult createCatalog(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity catalog, @Nonnull List<PolarisEntityCore> principalRoles) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        Map<String, String> internalProp = catalog.getInternalPropertiesAsMap();
        String integrationIdentifierOrId = internalProp.get(PolarisEntityConstants.getStorageIntegrationIdentifierPropertyName());
        String storageConfigInfoStr = internalProp.get(PolarisEntityConstants.getStorageConfigInfoPropertyName());
        PolarisStorageIntegration integration = storageConfigInfoStr != null && integrationIdentifierOrId == null ? ms.createStorageIntegrationInCurrentTxn(callCtx, catalog.getCatalogId(), catalog.getId(), PolarisStorageConfigurationInfo.deserialize(storageConfigInfoStr)) : null;
        return ms.runInTransaction(callCtx, () -> this.createCatalog(callCtx, ms, catalog, integration, principalRoles));
    }

    @Nonnull
    private EntityResult createEntityIfNotExists(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        this.getDiagnostics().checkNotNull(entity, "unexpected_null_entity");
        this.getDiagnostics().checkNotNull(entity.getName(), "unexpected_null_entity_name");
        PolarisBaseEntity entityFound = ms.lookupEntityInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId(), entity.getTypeCode());
        if (entityFound != null) {
            return new EntityResult(entityFound);
        }
        PolarisEntityResolver resolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, catalogPath);
        if (resolver.isFailure()) {
            return new EntityResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null);
        }
        EntityNameLookupRecord entityActiveRecord = ms.lookupEntityIdAndSubTypeByNameInCurrentTxn(callCtx, entity.getCatalogId(), entity.getParentId(), entity.getType().getCode(), entity.getName());
        if (entityActiveRecord != null) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, entityActiveRecord.getSubTypeCode());
        }
        this.persistNewEntity(callCtx, ms, entity);
        return new EntityResult(entity);
    }

    @Override
    @Nonnull
    public EntityResult createEntityIfNotExists(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.createEntityIfNotExists(callCtx, ms, catalogPath, entity));
    }

    @Override
    @Nonnull
    public EntitiesResult createEntitiesIfNotExist(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull List<? extends PolarisBaseEntity> entities) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> {
            ArrayList<PolarisBaseEntity> createdEntities = new ArrayList<PolarisBaseEntity>(entities.size());
            for (PolarisBaseEntity entity : entities) {
                EntityResult entityCreateResult = this.createEntityIfNotExists(callCtx, ms, catalogPath, entity);
                if (entityCreateResult.getReturnStatus() != BaseResult.ReturnStatus.SUCCESS) {
                    ms.rollback();
                    return new EntitiesResult(entityCreateResult.getReturnStatus(), entityCreateResult.getExtraInformation());
                }
                createdEntities.add(entityCreateResult.getEntity());
            }
            return new EntitiesResult(Page.fromItems(createdEntities));
        });
    }

    @Nonnull
    private EntityResult updateEntityPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        this.getDiagnostics().checkNotNull(entity, "unexpected_null_entity");
        PolarisEntityResolver resolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, catalogPath, entity);
        if (resolver.isFailure()) {
            return new EntityResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null);
        }
        PolarisBaseEntity entityRefreshed = ms.lookupEntityInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId(), entity.getTypeCode());
        this.getDiagnostics().checkNotNull(entityRefreshed, "unexpected_entity_not_found", "entity={}", entity);
        if (entityRefreshed.getEntityVersion() != entity.getEntityVersion()) {
            return new EntityResult(BaseResult.ReturnStatus.TARGET_ENTITY_CONCURRENTLY_MODIFIED, null);
        }
        PolarisBaseEntity updatedEntity = new PolarisBaseEntity.Builder(entityRefreshed).internalProperties(entity.getInternalProperties()).properties(entity.getProperties()).build();
        PolarisBaseEntity persistedEntity = this.persistEntityAfterChange(callCtx, ms, updatedEntity, false, entityRefreshed);
        return new EntityResult(persistedEntity);
    }

    @Override
    @Nonnull
    public EntityResult updateEntityPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.updateEntityPropertiesIfNotChanged(callCtx, ms, catalogPath, entity));
    }

    @Nonnull
    private EntitiesResult updateEntitiesPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull List<EntityWithPath> entities) {
        this.getDiagnostics().checkNotNull(entities, "unexpected_null_entities");
        ArrayList<PolarisBaseEntity> updatedEntities = new ArrayList<PolarisBaseEntity>(entities.size());
        for (EntityWithPath entityWithPath : entities) {
            EntityResult updatedEntityResult = this.updateEntityPropertiesIfNotChanged(callCtx, ms, entityWithPath.getCatalogPath(), entityWithPath.getEntity());
            if (updatedEntityResult.getReturnStatus() != BaseResult.ReturnStatus.SUCCESS) {
                ms.rollback();
                return new EntitiesResult(updatedEntityResult.getReturnStatus(), updatedEntityResult.getExtraInformation());
            }
            updatedEntities.add(updatedEntityResult.getEntity());
        }
        return new EntitiesResult(Page.fromItems(updatedEntities));
    }

    @Override
    @Nonnull
    public EntitiesResult updateEntitiesPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nonnull List<EntityWithPath> entities) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.updateEntitiesPropertiesIfNotChanged(callCtx, ms, entities));
    }

    @Nonnull
    private EntityResult renameEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore entityToRename, @Nullable List<PolarisEntityCore> newCatalogPath, @Nonnull PolarisBaseEntity renamedEntity) {
        PolarisEntityResolver resolver;
        this.getDiagnostics().checkNotNull(entityToRename, "unexpected_null_entityToRename");
        this.getDiagnostics().checkNotNull(renamedEntity, "unexpected_null_renamedEntity");
        this.getDiagnostics().check(newCatalogPath == null || catalogPath != null, "newCatalogPath_specified_without_catalogPath");
        if (newCatalogPath == null) {
            newCatalogPath = catalogPath;
        }
        if ((resolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, catalogPath, entityToRename)).isFailure()) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisBaseEntity refreshEntityToRename = ms.lookupEntityInCurrentTxn(callCtx, entityToRename.getCatalogId(), entityToRename.getId(), entityToRename.getTypeCode());
        if (refreshEntityToRename == null) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (refreshEntityToRename.getEntityVersion() != renamedEntity.getEntityVersion()) {
            return new EntityResult(BaseResult.ReturnStatus.TARGET_ENTITY_CONCURRENTLY_MODIFIED, null);
        }
        if (refreshEntityToRename.cannotBeDroppedOrRenamed()) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RENAMED, null);
        }
        if (newCatalogPath != null && (resolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, newCatalogPath)).isFailure()) {
            return new EntityResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null);
        }
        EntityNameLookupRecord entityActiveRecord = ms.lookupEntityIdAndSubTypeByNameInCurrentTxn(callCtx, resolver.getCatalogIdOrNull(), resolver.getParentId(), refreshEntityToRename.getTypeCode(), renamedEntity.getName());
        if (entityActiveRecord != null) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, entityActiveRecord.getSubTypeCode());
        }
        PolarisBaseEntity.Builder updatedEntityBuilder = new PolarisBaseEntity.Builder(refreshEntityToRename);
        updatedEntityBuilder.name(renamedEntity.getName());
        updatedEntityBuilder.properties(renamedEntity.getProperties());
        updatedEntityBuilder.internalProperties(renamedEntity.getInternalProperties());
        if (newCatalogPath != null) {
            updatedEntityBuilder.parentId(resolver.getParentId());
        }
        PolarisBaseEntity renamedEntityToReturn = this.persistEntityAfterChange(callCtx, ms, updatedEntityBuilder.build(), true, refreshEntityToRename);
        return new EntityResult(renamedEntityToReturn);
    }

    @Override
    @Nonnull
    public EntityResult renameEntity(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entityToRename, @Nullable List<PolarisEntityCore> newCatalogPath, @Nonnull PolarisEntity renamedEntity) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.renameEntity(callCtx, ms, catalogPath, entityToRename, newCatalogPath, renamedEntity));
    }

    @Nonnull
    private DropEntityResult dropEntityIfExists(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entityToDrop, @Nullable Map<String, String> cleanupProperties, boolean cleanup) {
        this.getDiagnostics().checkNotNull(entityToDrop, "unexpected_null_entity");
        PolarisEntityResolver resolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, catalogPath, entityToDrop);
        if (resolver.isFailure()) {
            return new DropEntityResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null);
        }
        PolarisBaseEntity refreshEntityToDrop = ms.lookupEntityInCurrentTxn(callCtx, entityToDrop.getCatalogId(), entityToDrop.getId(), entityToDrop.getTypeCode());
        if (refreshEntityToDrop == null) {
            return new DropEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (refreshEntityToDrop.cannotBeDroppedOrRenamed()) {
            return new DropEntityResult(BaseResult.ReturnStatus.ENTITY_UNDROPPABLE, null);
        }
        if (refreshEntityToDrop.getType() == PolarisEntityType.CATALOG) {
            long catalogId = refreshEntityToDrop.getId();
            CatalogEntity catalogEntityToDrop = CatalogEntity.of(refreshEntityToDrop);
            if (!(catalogEntityToDrop.isPassthroughFacade() && callCtx.getRealmConfig().getConfig(FeatureConfiguration.ALLOW_DROPPING_NON_EMPTY_PASSTHROUGH_FACADE_CATALOG, catalogEntityToDrop).booleanValue() || !ms.hasChildrenInCurrentTxn(callCtx, PolarisEntityType.NAMESPACE, catalogId, catalogId))) {
                return new DropEntityResult(BaseResult.ReturnStatus.NAMESPACE_NOT_EMPTY, catalogEntityToDrop.isPassthroughFacade() ? String.format("Set %s to true to drop non-empty passthrough facade catalogs", FeatureConfiguration.ALLOW_DROPPING_NON_EMPTY_PASSTHROUGH_FACADE_CATALOG.key()) : null);
            }
            List catalogRoles = ms.loadEntitiesInCurrentTxn(callCtx, catalogId, catalogId, PolarisEntityType.CATALOG_ROLE, PolarisEntitySubType.ANY_SUBTYPE, entity -> true, Function.identity(), PageToken.fromLimit(2)).items();
            if (catalogRoles.size() > 1) {
                return new DropEntityResult(BaseResult.ReturnStatus.CATALOG_NOT_EMPTY, null);
            }
            if (!catalogRoles.isEmpty()) {
                this.dropEntity(callCtx, ms, (PolarisBaseEntity)catalogRoles.get(0));
            }
        } else if (refreshEntityToDrop.getType() == PolarisEntityType.NAMESPACE) {
            if (ms.hasChildrenInCurrentTxn(callCtx, null, refreshEntityToDrop.getCatalogId(), refreshEntityToDrop.getId())) {
                return new DropEntityResult(BaseResult.ReturnStatus.NAMESPACE_NOT_EMPTY, null);
            }
        } else if (refreshEntityToDrop.getType() == PolarisEntityType.POLICY && !cleanup) {
            try {
                List<PolarisPolicyMappingRecord> records = ms.loadAllTargetsOnPolicyInCurrentTxn(callCtx, refreshEntityToDrop.getCatalogId(), refreshEntityToDrop.getId(), PolicyEntity.of(refreshEntityToDrop).getPolicyTypeCode());
                if (!records.isEmpty()) {
                    return new DropEntityResult(BaseResult.ReturnStatus.POLICY_HAS_MAPPINGS, null);
                }
            }
            catch (UnsupportedOperationException records) {
                // empty catch block
            }
        }
        this.dropEntity(callCtx, ms, refreshEntityToDrop);
        if (cleanup && refreshEntityToDrop.getType() != PolarisEntityType.POLICY) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("taskType", String.valueOf(AsyncTaskType.ENTITY_CLEANUP_SCHEDULER.typeCode()));
            properties.put("data", PolarisObjectMapperUtil.serialize(refreshEntityToDrop));
            PolarisBaseEntity.Builder taskEntityBuilder = ((PolarisBaseEntity.Builder)((PolarisBaseEntity.Builder)((PolarisBaseEntity.Builder)((PolarisBaseEntity.Builder)new PolarisBaseEntity.Builder().id(ms.generateNewIdInCurrentTxn(callCtx))).catalogId(0L)).name("entityCleanup_" + entityToDrop.getId())).typeCode(PolarisEntityType.TASK.getCode())).subTypeCode(PolarisEntitySubType.NULL_SUBTYPE.getCode()).createTimestamp(this.clock.millis()).propertiesAsMap(properties);
            if (cleanupProperties != null) {
                taskEntityBuilder.internalPropertiesAsMap(cleanupProperties);
            }
            PolarisBaseEntity taskEntity = taskEntityBuilder.build();
            this.createEntityIfNotExists(callCtx, ms, null, taskEntity);
            return new DropEntityResult(taskEntity.getId());
        }
        return new DropEntityResult();
    }

    @Override
    @Nonnull
    public DropEntityResult dropEntityIfExists(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entityToDrop, @Nullable Map<String, String> cleanupProperties, boolean cleanup) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.dropEntityIfExists(callCtx, ms, catalogPath, entityToDrop, cleanupProperties, cleanup));
    }

    @Nonnull
    private PolarisEntityResolver resolveRoleToGranteeUsageGrant(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        this.getDiagnostics().checkNotNull(grantee, "unexpected_null_grantee");
        this.getDiagnostics().check(grantee.getType().isGrantee(), "not_a_grantee", "grantee={}", grantee);
        this.getDiagnostics().checkNotNull(role, "unexpected_null_role");
        boolean isCatalogRole = role.getTypeCode() == PolarisEntityType.CATALOG_ROLE.getCode();
        boolean isPrincipalRole = role.getTypeCode() == PolarisEntityType.PRINCIPAL_ROLE.getCode();
        this.getDiagnostics().check(isCatalogRole || isPrincipalRole, "not_a_role");
        this.getDiagnostics().check(catalog == null && isPrincipalRole || catalog != null && isCatalogRole, "catalog_mismatch", "catalog={} role={}", catalog, role);
        ArrayList<PolarisEntityCore> otherTopLevelEntities = new ArrayList<PolarisEntityCore>(2);
        otherTopLevelEntities.add(role);
        otherTopLevelEntities.add(grantee);
        return new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, catalog != null ? List.of(catalog) : null, null, otherTopLevelEntities);
    }

    private PolarisEntityResolver resolveSecurableToRoleGrant(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable) {
        this.getDiagnostics().checkNotNull(grantee, "unexpected_null_grantee");
        this.getDiagnostics().check(grantee.getType().isGrantee(), "not_grantee_type", "grantee={}", grantee);
        this.getDiagnostics().checkNotNull(securable, "unexpected_null_securable");
        if (securable.getCatalogId() > 0L) {
            this.getDiagnostics().checkNotNull(catalogPath, "unexpected_null_catalogPath");
        }
        return new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, catalogPath, securable, List.of(grantee));
    }

    @Nonnull
    private PrivilegeResult grantUsageOnRoleToGrantee(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        PolarisEntityResolver resolver = this.resolveRoleToGranteeUsageGrant(callCtx, ms, catalog, role, grantee);
        if (resolver.isFailure()) {
            return new PrivilegeResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisPrivilege usagePriv = grantee.getType() == PolarisEntityType.PRINCIPAL_ROLE ? PolarisPrivilege.CATALOG_ROLE_USAGE : PolarisPrivilege.PRINCIPAL_ROLE_USAGE;
        this.getDiagnostics().check(grantee.getType().isGrantee(), "not_a_grantee", "grantee={}", grantee);
        PolarisGrantRecord grantRecord = this.persistNewGrantRecord(callCtx, ms, role, grantee, usagePriv);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public PrivilegeResult grantUsageOnRoleToGrantee(@Nonnull PolarisCallContext callCtx, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.grantUsageOnRoleToGrantee(callCtx, ms, catalog, role, grantee));
    }

    @Nonnull
    private PrivilegeResult revokeUsageOnRoleFromGrantee(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        PolarisEntityResolver resolver = this.resolveRoleToGranteeUsageGrant(callCtx, ms, catalog, role, grantee);
        if (resolver.isFailure()) {
            return new PrivilegeResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisPrivilege usagePriv = grantee.getType() == PolarisEntityType.PRINCIPAL_ROLE ? PolarisPrivilege.CATALOG_ROLE_USAGE : PolarisPrivilege.PRINCIPAL_ROLE_USAGE;
        PolarisGrantRecord grantRecord = ms.lookupGrantRecordInCurrentTxn(callCtx, role.getCatalogId(), role.getId(), grantee.getCatalogId(), grantee.getId(), usagePriv.getCode());
        if (grantRecord == null) {
            return new PrivilegeResult(BaseResult.ReturnStatus.GRANT_NOT_FOUND, null);
        }
        this.revokeGrantRecord(callCtx, ms, role, grantee, grantRecord);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public PrivilegeResult revokeUsageOnRoleFromGrantee(@Nonnull PolarisCallContext callCtx, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.revokeUsageOnRoleFromGrantee(callCtx, ms, catalog, role, grantee));
    }

    @Nonnull
    private PrivilegeResult grantPrivilegeOnSecurableToRole(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege priv) {
        PolarisEntityResolver resolver = this.resolveSecurableToRoleGrant(callCtx, ms, grantee, catalogPath, securable);
        if (resolver.isFailure()) {
            return new PrivilegeResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisGrantRecord grantRecord = this.persistNewGrantRecord(callCtx, ms, securable, grantee, priv);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public PrivilegeResult grantPrivilegeOnSecurableToRole(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege privilege) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.grantPrivilegeOnSecurableToRole(callCtx, ms, grantee, catalogPath, securable, privilege));
    }

    @Nonnull
    private PrivilegeResult revokePrivilegeOnSecurableFromRole(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege priv) {
        PolarisEntityResolver resolver = this.resolveSecurableToRoleGrant(callCtx, ms, grantee, catalogPath, securable);
        if (resolver.isFailure()) {
            return new PrivilegeResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisGrantRecord grantRecord = ms.lookupGrantRecordInCurrentTxn(callCtx, securable.getCatalogId(), securable.getId(), grantee.getCatalogId(), grantee.getId(), priv.getCode());
        if (grantRecord == null) {
            return new PrivilegeResult(BaseResult.ReturnStatus.GRANT_NOT_FOUND, null);
        }
        this.revokeGrantRecord(callCtx, ms, securable, grantee, grantRecord);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public PrivilegeResult revokePrivilegeOnSecurableFromRole(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege privilege) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.revokePrivilegeOnSecurableFromRole(callCtx, ms, grantee, catalogPath, securable, privilege));
    }

    @Nonnull
    private LoadGrantsResult loadGrantsOnSecurable(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, long securableCatalogId, long securableId) {
        int grantsVersion = ms.lookupEntityGrantRecordsVersionInCurrentTxn(callCtx, securableCatalogId, securableId);
        if (grantsVersion == 0) {
            return new LoadGrantsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisGrantRecord> returnGrantRecords = ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, securableCatalogId, securableId);
        List<PolarisEntityId> entityIds = returnGrantRecords.stream().map(grantRecord -> new PolarisEntityId(grantRecord.getGranteeCatalogId(), grantRecord.getGranteeId())).distinct().collect(Collectors.toList());
        List<PolarisBaseEntity> entities = ms.lookupEntitiesInCurrentTxn(callCtx, entityIds);
        return new LoadGrantsResult(grantsVersion, returnGrantRecords, entities.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public LoadGrantsResult loadGrantsOnSecurable(@Nonnull PolarisCallContext callCtx, PolarisEntityCore securable) {
        return this.loadGrantsOnSecurable(callCtx, securable.getCatalogId(), securable.getId());
    }

    @Nonnull
    public LoadGrantsResult loadGrantsOnSecurable(@Nonnull PolarisCallContext callCtx, long securableCatalogId, long securableId) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.loadGrantsOnSecurable(callCtx, ms, securableCatalogId, securableId));
    }

    @Nonnull
    public LoadGrantsResult loadGrantsToGrantee(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, long granteeCatalogId, long granteeId) {
        int grantsVersion = ms.lookupEntityGrantRecordsVersionInCurrentTxn(callCtx, granteeCatalogId, granteeId);
        if (grantsVersion == 0) {
            return new LoadGrantsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisGrantRecord> returnGrantRecords = ms.loadAllGrantRecordsOnGranteeInCurrentTxn(callCtx, granteeCatalogId, granteeId);
        List<PolarisEntityId> entityIds = returnGrantRecords.stream().map(grantRecord -> new PolarisEntityId(grantRecord.getSecurableCatalogId(), grantRecord.getSecurableId())).distinct().collect(Collectors.toList());
        List<PolarisBaseEntity> entities = ms.lookupEntitiesInCurrentTxn(callCtx, entityIds);
        return new LoadGrantsResult(grantsVersion, returnGrantRecords, entities.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public LoadGrantsResult loadGrantsToGrantee(@Nonnull PolarisCallContext callCtx, PolarisEntityCore grantee) {
        return this.loadGrantsToGrantee(callCtx, grantee.getCatalogId(), grantee.getId());
    }

    @Nonnull
    public LoadGrantsResult loadGrantsToGrantee(@Nonnull PolarisCallContext callCtx, long granteeCatalogId, long granteeId) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.loadGrantsToGrantee(callCtx, ms, granteeCatalogId, granteeId));
    }

    @Nonnull
    private ChangeTrackingResult loadEntitiesChangeTracking(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull List<PolarisEntityId> entityIds) {
        List<PolarisChangeTrackingVersions> changeTracking = ms.lookupEntityVersionsInCurrentTxn(callCtx, entityIds);
        return new ChangeTrackingResult(changeTracking);
    }

    @Override
    @Nonnull
    public ChangeTrackingResult loadEntitiesChangeTracking(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityId> entityIds) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.loadEntitiesChangeTracking(callCtx, ms, entityIds));
    }

    @Nonnull
    private EntityResult loadEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, long entityCatalogId, long entityId, int entityTypeCode) {
        PolarisBaseEntity entity = ms.lookupEntityInCurrentTxn(callCtx, entityCatalogId, entityId, entityTypeCode);
        return entity != null ? new EntityResult(entity) : new EntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
    }

    @Override
    @Nonnull
    public EntityResult loadEntity(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long entityId, @Nonnull PolarisEntityType entityType) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.loadEntity(callCtx, ms, entityCatalogId, entityId, entityType.getCode()));
    }

    @Nonnull
    private EntitiesResult loadTasks(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, String executorId, PageToken pageToken) {
        Page availableTasks = ms.loadEntitiesInCurrentTxn(callCtx, PolarisEntityConstants.getRootEntityId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.TASK, PolarisEntitySubType.ANY_SUBTYPE, entity -> {
            PolarisObjectMapperUtil.TaskExecutionState taskState = PolarisObjectMapperUtil.parseTaskState(entity);
            long taskAgeTimeout = callCtx.getRealmConfig().getConfig("POLARIS_TASK_TIMEOUT_MILLIS", 300000L);
            return taskState == null || taskState.executor == null || this.clock.millis() - taskState.lastAttemptStartTime > taskAgeTimeout;
        }, Function.identity(), pageToken);
        List loadedTasks = availableTasks.items().stream().map(task -> {
            PolarisBaseEntity.Builder updatedTask = new PolarisBaseEntity.Builder((PolarisBaseEntity)task);
            Map<String, String> properties = task.getPropertiesAsMap();
            properties.put("lastAttemptExecutorId", executorId);
            properties.put("lastAttemptStartTime", String.valueOf(this.clock.millis()));
            properties.put("attemptCount", String.valueOf(Integer.parseInt(properties.getOrDefault("attemptCount", "0")) + 1));
            updatedTask.propertiesAsMap(properties);
            EntityResult result = this.updateEntityPropertiesIfNotChanged(callCtx, ms, null, updatedTask.build());
            if (result.getReturnStatus() == BaseResult.ReturnStatus.SUCCESS) {
                return result.getEntity();
            }
            ms.rollback();
            throw new RetryOnConcurrencyException("Failed to lease available task with status %s, info: %s", new Object[]{result.getReturnStatus(), result.getExtraInformation()});
        }).collect(Collectors.toList());
        return EntitiesResult.fromPage(Page.fromItems(loadedTasks));
    }

    @Override
    @Nonnull
    public EntitiesResult loadTasks(@Nonnull PolarisCallContext callCtx, String executorId, PageToken pageToken) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.loadTasks(callCtx, ms, executorId, pageToken));
    }

    @Override
    @Nonnull
    public ScopedCredentialsResult getSubscopedCredsForEntity(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, PolarisEntityType entityType, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations, Optional<String> refreshCredentialsEndpoint) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        this.getDiagnostics().check(!allowedReadLocations.isEmpty() || !allowedWriteLocations.isEmpty(), "allowed_locations_to_subscope_is_required");
        EntityResult reloadedEntity = this.loadEntity(callCtx, catalogId, entityId, entityType);
        if (reloadedEntity.getReturnStatus() != BaseResult.ReturnStatus.SUCCESS) {
            return new ScopedCredentialsResult(reloadedEntity.getReturnStatus(), reloadedEntity.getExtraInformation());
        }
        PolarisStorageIntegration storageIntegration = ms.loadPolarisStorageIntegrationInCurrentTxn(callCtx, reloadedEntity.getEntity());
        this.getDiagnostics().checkNotNull(storageIntegration, "storage_integration_not_exists", "catalogId={}, entityId={}", catalogId, entityId);
        try {
            AccessConfig accessConfig = storageIntegration.getSubscopedCreds(callCtx.getRealmConfig(), allowListOperation, allowedReadLocations, allowedWriteLocations, refreshCredentialsEndpoint);
            return new ScopedCredentialsResult(accessConfig);
        }
        catch (Exception ex) {
            return new ScopedCredentialsResult(BaseResult.ReturnStatus.SUBSCOPE_CREDS_ERROR, ex.getMessage());
        }
    }

    @Nonnull
    private ResolvedEntityResult loadResolvedEntityById(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, long entityCatalogId, long entityId, int typeCode) {
        List<PolarisGrantRecord> grantRecords;
        PolarisBaseEntity entity = ms.lookupEntityInCurrentTxn(callCtx, entityCatalogId, entityId, typeCode);
        if (entity == null) {
            return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (entity.getType().isGrantee()) {
            grantRecords = new ArrayList<PolarisGrantRecord>(ms.loadAllGrantRecordsOnGranteeInCurrentTxn(callCtx, entityCatalogId, entityId));
            grantRecords.addAll(ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entityId));
        } else {
            grantRecords = ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entityId);
        }
        return new ResolvedEntityResult(entity, entity.getGrantRecordsVersion(), grantRecords);
    }

    @Override
    @Nonnull
    public ResolvedEntityResult loadResolvedEntityById(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long entityId, PolarisEntityType entityType) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.loadResolvedEntityById(callCtx, ms, entityCatalogId, entityId, entityType.getCode()));
    }

    @Nonnull
    private ResolvedEntityResult loadResolvedEntityByName(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, long entityCatalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull String entityName) {
        List<PolarisGrantRecord> grantRecords;
        PolarisBaseEntity entity = ms.lookupEntityByNameInCurrentTxn(callCtx, entityCatalogId, parentId, entityType.getCode(), entityName);
        if (entity == null) {
            return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (entity.getType().isGrantee()) {
            grantRecords = new ArrayList<PolarisGrantRecord>(ms.loadAllGrantRecordsOnGranteeInCurrentTxn(callCtx, entityCatalogId, entity.getId()));
            grantRecords.addAll(ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entity.getId()));
        } else {
            grantRecords = ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entity.getId());
        }
        return new ResolvedEntityResult(entity, entity.getGrantRecordsVersion(), grantRecords);
    }

    @Override
    @Nonnull
    public ResolvedEntityResult loadResolvedEntityByName(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull String entityName) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        ResolvedEntityResult result = ms.runInReadTransaction(callCtx, () -> this.loadResolvedEntityByName(callCtx, ms, entityCatalogId, parentId, entityType, entityName));
        if (PolarisEntityConstants.getRootContainerName().equals(entityName) && entityType == PolarisEntityType.ROOT && !result.isSuccess()) {
            ms.runActionInTransaction(callCtx, () -> {
                PolarisBaseEntity serviceAdminRole;
                PolarisBaseEntity rootContainer = new PolarisBaseEntity(PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.ROOT, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootEntityId(), PolarisEntityConstants.getRootContainerName());
                EntityResult backfillResult = this.createEntityIfNotExists(callCtx, ms, null, rootContainer);
                if (backfillResult.isSuccess() && (serviceAdminRole = ms.lookupEntityByNameInCurrentTxn(callCtx, 0L, 0L, PolarisEntityType.PRINCIPAL_ROLE.getCode(), PolarisEntityConstants.getNameOfPrincipalServiceAdminRole())) != null) {
                    this.persistNewGrantRecord(callCtx, ms, rootContainer, serviceAdminRole, PolarisPrivilege.SERVICE_MANAGE_ACCESS);
                }
            });
            result = ms.runInReadTransaction(callCtx, () -> this.loadResolvedEntityByName(callCtx, ms, entityCatalogId, parentId, entityType, entityName));
        }
        return result;
    }

    @Nonnull
    private ResolvedEntityResult refreshResolvedEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, int entityVersion, int entityGrantRecordsVersion, @Nonnull PolarisEntityType entityType, long entityCatalogId, long entityId) {
        List<PolarisGrantRecord> grantRecords;
        PolarisBaseEntity entity;
        PolarisChangeTrackingVersions entityVersions = ms.lookupEntityVersionsInCurrentTxn(callCtx, List.of(new PolarisEntityId(entityCatalogId, entityId))).get(0);
        if (entityVersions == null) {
            return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (entityVersion != entityVersions.getEntityVersion()) {
            entity = ms.lookupEntityInCurrentTxn(callCtx, entityCatalogId, entityId, entityType.getCode());
            if (entity == null) {
                return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
            }
        } else {
            entity = null;
        }
        if (entityVersions.getGrantRecordsVersion() != entityGrantRecordsVersion) {
            if (entityType.isGrantee()) {
                grantRecords = new ArrayList<PolarisGrantRecord>(ms.loadAllGrantRecordsOnGranteeInCurrentTxn(callCtx, entityCatalogId, entityId));
                grantRecords.addAll(ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entityId));
            } else {
                grantRecords = ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entityId);
            }
        } else {
            grantRecords = null;
        }
        return new ResolvedEntityResult(entity, entityVersions.getGrantRecordsVersion(), grantRecords);
    }

    @Override
    @Nonnull
    public ResolvedEntityResult refreshResolvedEntity(@Nonnull PolarisCallContext callCtx, int entityVersion, int entityGrantRecordsVersion, @Nonnull PolarisEntityType entityType, long entityCatalogId, long entityId) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.refreshResolvedEntity(callCtx, ms, entityVersion, entityGrantRecordsVersion, entityType, entityCatalogId, entityId));
    }

    @Override
    public <T extends PolarisEntity> Optional<Optional<String>> hasOverlappingSiblings(@Nonnull PolarisCallContext callContext, T entity) {
        TransactionalPersistence ms = (TransactionalPersistence)callContext.getMetaStore();
        return ms.runInTransaction(callContext, () -> callContext.getMetaStore().hasOverlappingSiblings(callContext, entity));
    }

    @Override
    @Nonnull
    public PolicyAttachmentResult attachPolicyToEntity(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityCore> targetCatalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy, Map<String, String> parameters) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.doAttachPolicyToEntity(callCtx, ms, targetCatalogPath, target, policyCatalogPath, policy, parameters));
    }

    @Nonnull
    private PolicyAttachmentResult doAttachPolicyToEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull List<PolarisEntityCore> targetCatalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy, Map<String, String> parameters) {
        PolarisEntityResolver targetResolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, targetCatalogPath, target);
        PolarisEntityResolver policyResolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, policyCatalogPath, policy);
        if (targetResolver.isFailure() || policyResolver.isFailure()) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        return this.persistNewPolicyMappingRecord(callCtx, ms, target, policy, parameters);
    }

    @Override
    @Nonnull
    public PolicyAttachmentResult detachPolicyFromEntity(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityCore> targetCatalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.doDetachPolicyFromEntity(callCtx, ms, targetCatalogPath, target, policyCatalogPath, policy));
    }

    private PolicyAttachmentResult doDetachPolicyFromEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull List<PolarisEntityCore> targetCatalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy) {
        PolarisEntityResolver targetResolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, targetCatalogPath, target);
        PolarisEntityResolver policyResolver = new PolarisEntityResolver(this.getDiagnostics(), callCtx, ms, policyCatalogPath, policy);
        if (targetResolver.isFailure() || policyResolver.isFailure()) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisPolicyMappingRecord mappingRecord = ms.lookupPolicyMappingRecordInCurrentTxn(callCtx, target.getCatalogId(), target.getId(), policy.getPolicyTypeCode(), policy.getCatalogId(), policy.getId());
        if (mappingRecord == null) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.POLICY_MAPPING_NOT_FOUND, null);
        }
        ms.deleteFromPolicyMappingRecordsInCurrentTxn(callCtx, mappingRecord);
        return new PolicyAttachmentResult(mappingRecord);
    }

    @Override
    @Nonnull
    public LoadPolicyMappingsResult loadPoliciesOnEntity(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore target) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.doLoadPoliciesOnEntity(callCtx, ms, target));
    }

    private LoadPolicyMappingsResult doLoadPoliciesOnEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore target) {
        PolarisBaseEntity entity = ms.lookupEntityInCurrentTxn(callCtx, target.getCatalogId(), target.getId(), target.getTypeCode());
        if (entity == null) {
            return new LoadPolicyMappingsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisPolicyMappingRecord> policyMappingRecords = ms.loadAllPoliciesOnTargetInCurrentTxn(callCtx, target.getCatalogId(), target.getId());
        List<PolarisBaseEntity> policyEntities = this.loadPoliciesFromMappingRecords(callCtx, ms, policyMappingRecords);
        return new LoadPolicyMappingsResult(policyMappingRecords, policyEntities);
    }

    @Override
    @Nonnull
    public LoadPolicyMappingsResult loadPoliciesOnEntityByType(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore target, @Nonnull PolicyType policyType) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.doLoadPoliciesOnEntityByType(callCtx, ms, target, policyType));
    }

    private LoadPolicyMappingsResult doLoadPoliciesOnEntityByType(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore target, @Nonnull PolicyType policyType) {
        PolarisBaseEntity entity = ms.lookupEntityInCurrentTxn(callCtx, target.getCatalogId(), target.getId(), target.getTypeCode());
        if (entity == null) {
            return new LoadPolicyMappingsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisPolicyMappingRecord> policyMappingRecords = ms.loadPoliciesOnTargetByTypeInCurrentTxn(callCtx, target.getCatalogId(), target.getId(), policyType.getCode());
        List<PolarisBaseEntity> policyEntities = this.loadPoliciesFromMappingRecords(callCtx, ms, policyMappingRecords);
        return new LoadPolicyMappingsResult(policyMappingRecords, policyEntities);
    }

    @Nonnull
    private PolicyAttachmentResult persistNewPolicyMappingRecord(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore target, @Nonnull PolicyEntity policy, Map<String, String> parameters) {
        this.getDiagnostics().checkNotNull(target, "unexpected_null_target");
        this.getDiagnostics().checkNotNull(policy, "unexpected_null_policy");
        PolarisPolicyMappingRecord mappingRecord = new PolarisPolicyMappingRecord(target.getCatalogId(), target.getId(), policy.getCatalogId(), policy.getId(), policy.getPolicyTypeCode(), parameters);
        try {
            ms.checkConditionsForWriteToPolicyMappingRecordsInCurrentTxn(callCtx, mappingRecord);
            ms.writeToPolicyMappingRecordsInCurrentTxn(callCtx, mappingRecord);
        }
        catch (IllegalArgumentException e) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.UNEXPECTED_ERROR_SIGNALED, "Unknown policy type");
        }
        catch (PolicyMappingAlreadyExistsException e) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.POLICY_MAPPING_OF_SAME_TYPE_ALREADY_EXISTS, e.getExistingRecord().getPolicyTypeCode());
        }
        return new PolicyAttachmentResult(mappingRecord);
    }

    private List<PolarisBaseEntity> loadPoliciesFromMappingRecords(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull List<PolarisPolicyMappingRecord> policyMappingRecords) {
        List<PolarisEntityId> policyEntityIds = policyMappingRecords.stream().map(policyMappingRecord -> new PolarisEntityId(policyMappingRecord.getPolicyCatalogId(), policyMappingRecord.getPolicyId())).distinct().collect(Collectors.toList());
        return ms.lookupEntitiesInCurrentTxn(callCtx, policyEntityIds);
    }
}

