/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.function.Supplier;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class Preconditions {
    private static final Logger LOG = LoggerFactory.getLogger(Preconditions.class);
    private static final String VALIDATE_IS_NOT_NULL_EX_MESSAGE = "The argument object is NULL";
    private static final String CHECK_ARGUMENT_EX_MESSAGE = "The argument expression is false";
    private static final String CHECK_STATE_EX_MESSAGE = "The state expression is false";

    private Preconditions() {
    }

    public static <T> T checkNotNull(T obj) {
        return Preconditions.checkNotNull(obj, VALIDATE_IS_NOT_NULL_EX_MESSAGE);
    }

    public static <T> T checkNotNull(T obj, Object errorMessage) {
        if (obj == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, String message, Object ... values2) {
        if (obj == null) {
            String msg;
            try {
                msg = String.format(message, values2);
            }
            catch (Exception e) {
                LOG.debug("Error formatting message", (Throwable)e);
                msg = VALIDATE_IS_NOT_NULL_EX_MESSAGE;
            }
            throw new NullPointerException(msg);
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, Supplier<String> msgSupplier) {
        if (obj == null) {
            String msg;
            try {
                msg = msgSupplier.get();
            }
            catch (Exception e) {
                LOG.debug("Error formatting message", (Throwable)e);
                msg = VALIDATE_IS_NOT_NULL_EX_MESSAGE;
            }
            throw new NullPointerException(msg);
        }
        return obj;
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMsg, Object ... errorMsgArgs) {
        if (!expression) {
            String msg;
            try {
                msg = String.format(errorMsg, errorMsgArgs);
            }
            catch (Exception e) {
                LOG.debug("Error formatting message", (Throwable)e);
                msg = CHECK_ARGUMENT_EX_MESSAGE;
            }
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkArgument(boolean expression, Supplier<String> msgSupplier) {
        if (!expression) {
            String msg;
            try {
                msg = msgSupplier.get();
            }
            catch (Exception e) {
                LOG.debug("Error formatting message", (Throwable)e);
                msg = CHECK_ARGUMENT_EX_MESSAGE;
            }
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, String errorMsg, Object ... errorMsgArgs) {
        if (!expression) {
            String msg;
            try {
                msg = String.format(errorMsg, errorMsgArgs);
            }
            catch (Exception e) {
                LOG.debug("Error formatting message", (Throwable)e);
                msg = CHECK_STATE_EX_MESSAGE;
            }
            throw new IllegalStateException(msg);
        }
    }

    public static void checkState(boolean expression, Supplier<String> msgSupplier) {
        if (!expression) {
            String msg;
            try {
                msg = msgSupplier.get();
            }
            catch (Exception e) {
                LOG.debug("Error formatting message", (Throwable)e);
                msg = CHECK_STATE_EX_MESSAGE;
            }
            throw new IllegalStateException(msg);
        }
    }

    static String getDefaultNullMSG() {
        return VALIDATE_IS_NOT_NULL_EX_MESSAGE;
    }

    static String getDefaultCheckArgumentMSG() {
        return CHECK_ARGUMENT_EX_MESSAGE;
    }

    static String getDefaultCheckStateMSG() {
        return CHECK_STATE_EX_MESSAGE;
    }
}

