/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.types.VariantType;
import org.apache.paimon.utils.Preconditions;

public final class DataTypeJsonParser {
    private static final char CHAR_BEGIN_SUBTYPE = '<';
    private static final char CHAR_END_SUBTYPE = '>';
    private static final char CHAR_BEGIN_PARAMETER = '(';
    private static final char CHAR_END_PARAMETER = ')';
    private static final char CHAR_LIST_SEPARATOR = ',';
    private static final char CHAR_STRING = '\'';
    private static final char CHAR_IDENTIFIER = '`';
    private static final char CHAR_DOT = '.';
    private static final Set<String> KEYWORDS = Stream.of(Keyword.values()).map(k -> k.toString().toUpperCase()).collect(Collectors.toSet());

    public static DataField parseDataField(JsonNode json) {
        return DataTypeJsonParser.parseDataField(json, null);
    }

    private static DataField parseDataField(JsonNode json, AtomicInteger fieldId) {
        int id;
        JsonNode idNode = json.get("id");
        if (idNode != null) {
            Preconditions.checkState(fieldId == null || fieldId.get() == -1, "Partial field id is not allowed.");
            id = idNode.asInt();
        } else {
            id = fieldId.incrementAndGet();
        }
        String name = json.get("name").asText();
        DataType type = DataTypeJsonParser.parseDataType(json.get("type"), fieldId);
        JsonNode descriptionNode = json.get("description");
        String description = null;
        if (descriptionNode != null) {
            description = descriptionNode.asText();
        }
        JsonNode defaultValueNode = json.get("defaultValue");
        String defaultValue = null;
        if (defaultValueNode != null) {
            defaultValue = defaultValueNode.asText();
        }
        return new DataField(id, name, type, description, defaultValue);
    }

    public static DataType parseDataType(JsonNode json) {
        return DataTypeJsonParser.parseDataType(json, new AtomicInteger(-1));
    }

    public static DataType parseDataType(JsonNode json, AtomicInteger fieldId) {
        if (json.isTextual()) {
            return DataTypeJsonParser.parseAtomicTypeSQLString(json.asText());
        }
        if (json.isObject()) {
            String typeString = json.get("type").asText();
            if (typeString.startsWith("ARRAY")) {
                DataType element = DataTypeJsonParser.parseDataType(json.get("element"), fieldId);
                return new ArrayType(!typeString.contains("NOT NULL"), element);
            }
            if (typeString.startsWith("MULTISET")) {
                DataType element = DataTypeJsonParser.parseDataType(json.get("element"), fieldId);
                return new MultisetType(!typeString.contains("NOT NULL"), element);
            }
            if (typeString.startsWith("MAP")) {
                DataType key = DataTypeJsonParser.parseDataType(json.get("key"), fieldId);
                DataType value = DataTypeJsonParser.parseDataType(json.get("value"), fieldId);
                return new MapType(!typeString.contains("NOT NULL"), key, value);
            }
            if (typeString.startsWith("ROW")) {
                JsonNode fieldArray = json.get("fields");
                Iterator<JsonNode> iterator2 = fieldArray.elements();
                ArrayList<DataField> fields = new ArrayList<DataField>(fieldArray.size());
                while (iterator2.hasNext()) {
                    fields.add(DataTypeJsonParser.parseDataField(iterator2.next(), fieldId));
                }
                return new RowType(!typeString.contains("NOT NULL"), fields);
            }
        }
        throw new IllegalArgumentException("Can not parse: " + json);
    }

    public static DataType parseAtomicTypeSQLString(String string) {
        List<Token> tokens = DataTypeJsonParser.tokenize(string);
        TokenParser converter = new TokenParser(string, tokens);
        return converter.parseTokens();
    }

    private static boolean isDelimiter(char character) {
        return Character.isWhitespace(character) || character == '<' || character == '>' || character == '(' || character == ')' || character == ',' || character == '.';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static List<Token> tokenize(String chars) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringBuilder builder = new StringBuilder();
        block10: for (int cursor = 0; cursor < chars.length(); ++cursor) {
            char curChar = chars.charAt(cursor);
            switch (curChar) {
                case '<': {
                    tokens.add(new Token(TokenType.BEGIN_SUBTYPE, cursor, Character.toString('<')));
                    continue block10;
                }
                case '>': {
                    tokens.add(new Token(TokenType.END_SUBTYPE, cursor, Character.toString('>')));
                    continue block10;
                }
                case '(': {
                    tokens.add(new Token(TokenType.BEGIN_PARAMETER, cursor, Character.toString('(')));
                    continue block10;
                }
                case ')': {
                    tokens.add(new Token(TokenType.END_PARAMETER, cursor, Character.toString(')')));
                    continue block10;
                }
                case ',': {
                    tokens.add(new Token(TokenType.LIST_SEPARATOR, cursor, Character.toString(',')));
                    continue block10;
                }
                case '.': {
                    tokens.add(new Token(TokenType.IDENTIFIER_SEPARATOR, cursor, Character.toString('.')));
                    continue block10;
                }
                case '\'': {
                    builder.setLength(0);
                    cursor = DataTypeJsonParser.consumeEscaped(builder, chars, cursor, '\'');
                    tokens.add(new Token(TokenType.LITERAL_STRING, cursor, builder.toString()));
                    continue block10;
                }
                case '`': {
                    builder.setLength(0);
                    cursor = DataTypeJsonParser.consumeEscaped(builder, chars, cursor, '`');
                    tokens.add(new Token(TokenType.IDENTIFIER, cursor, builder.toString()));
                    continue block10;
                }
                default: {
                    if (Character.isWhitespace(curChar)) continue block10;
                    if (DataTypeJsonParser.isDigit(curChar)) {
                        builder.setLength(0);
                        cursor = DataTypeJsonParser.consumeInt(builder, chars, cursor);
                        tokens.add(new Token(TokenType.LITERAL_INT, cursor, builder.toString()));
                        continue block10;
                    }
                    builder.setLength(0);
                    cursor = DataTypeJsonParser.consumeIdentifier(builder, chars, cursor);
                    String token = builder.toString();
                    String normalizedToken = token.toUpperCase();
                    if (KEYWORDS.contains(normalizedToken)) {
                        tokens.add(new Token(TokenType.KEYWORD, cursor, normalizedToken));
                        continue block10;
                    }
                    tokens.add(new Token(TokenType.IDENTIFIER, cursor, token));
                }
            }
        }
        return tokens;
    }

    private static int consumeEscaped(StringBuilder builder, String chars, int cursor, char delimiter) {
        ++cursor;
        while (chars.length() > cursor) {
            char curChar = chars.charAt(cursor);
            if (curChar == delimiter && cursor + 1 < chars.length() && chars.charAt(cursor + 1) == delimiter) {
                ++cursor;
                builder.append(curChar);
            } else {
                if (curChar == delimiter) break;
                builder.append(curChar);
            }
            ++cursor;
        }
        return cursor;
    }

    private static int consumeInt(StringBuilder builder, String chars, int cursor) {
        while (chars.length() > cursor && DataTypeJsonParser.isDigit(chars.charAt(cursor))) {
            builder.append(chars.charAt(cursor));
            ++cursor;
        }
        return cursor - 1;
    }

    private static int consumeIdentifier(StringBuilder builder, String chars, int cursor) {
        while (cursor < chars.length() && !DataTypeJsonParser.isDelimiter(chars.charAt(cursor))) {
            builder.append(chars.charAt(cursor));
            ++cursor;
        }
        return cursor - 1;
    }

    private static class TokenParser {
        private final String inputString;
        private final List<Token> tokens;
        private int lastValidToken;
        private int currentToken;

        public TokenParser(String inputString, List<Token> tokens) {
            this.inputString = inputString;
            this.tokens = tokens;
            this.lastValidToken = -1;
            this.currentToken = -1;
        }

        private DataType parseTokens() {
            DataType type = this.parseTypeWithNullability();
            if (this.hasRemainingTokens()) {
                this.nextToken();
                throw this.parsingError("Unexpected token: " + this.token().value);
            }
            return type;
        }

        private int lastCursor() {
            if (this.lastValidToken < 0) {
                return 0;
            }
            return this.tokens.get((int)this.lastValidToken).cursorPosition + 1;
        }

        private IllegalArgumentException parsingError(String cause, @Nullable Throwable t) {
            return new IllegalArgumentException(String.format("Could not parse type at position %d: %s\n Input type string: %s", this.lastCursor(), cause, this.inputString), t);
        }

        private IllegalArgumentException parsingError(String cause) {
            return this.parsingError(cause, null);
        }

        private boolean hasRemainingTokens() {
            return this.currentToken + 1 < this.tokens.size();
        }

        private Token token() {
            return this.tokens.get(this.currentToken);
        }

        private int tokenAsInt() {
            try {
                return Integer.parseInt(this.token().value);
            }
            catch (NumberFormatException e) {
                throw this.parsingError("Invalid integer value.", e);
            }
        }

        private Keyword tokenAsKeyword() {
            return Keyword.valueOf(this.token().value);
        }

        private void nextToken() {
            ++this.currentToken;
            if (this.currentToken >= this.tokens.size()) {
                throw this.parsingError("Unexpected end.");
            }
            this.lastValidToken = this.currentToken - 1;
        }

        private void nextToken(TokenType type) {
            this.nextToken();
            Token token = this.token();
            if (token.type != type) {
                throw this.parsingError("<" + type.name() + "> expected but was <" + (Object)((Object)token.type) + ">.");
            }
        }

        private void nextToken(Keyword keyword) {
            this.nextToken(TokenType.KEYWORD);
            Token token = this.token();
            if (!keyword.equals((Object)Keyword.valueOf(token.value))) {
                throw this.parsingError("Keyword '" + (Object)((Object)keyword) + "' expected but was '" + token.value + "'.");
            }
        }

        private boolean hasNextToken(TokenType ... types) {
            if (this.currentToken + types.length + 1 > this.tokens.size()) {
                return false;
            }
            for (int i = 0; i < types.length; ++i) {
                Token lookAhead = this.tokens.get(this.currentToken + i + 1);
                if (lookAhead.type == types[i]) continue;
                return false;
            }
            return true;
        }

        private boolean hasNextToken(Keyword ... keywords) {
            if (this.currentToken + keywords.length + 1 > this.tokens.size()) {
                return false;
            }
            for (int i = 0; i < keywords.length; ++i) {
                Token lookAhead = this.tokens.get(this.currentToken + i + 1);
                if (lookAhead.type == TokenType.KEYWORD && keywords[i] == Keyword.valueOf(lookAhead.value)) continue;
                return false;
            }
            return true;
        }

        private boolean parseNullability() {
            if (this.hasNextToken(Keyword.NOT, Keyword.NULL)) {
                this.nextToken(Keyword.NOT);
                this.nextToken(Keyword.NULL);
                return false;
            }
            if (this.hasNextToken(Keyword.NULL)) {
                this.nextToken(Keyword.NULL);
                return true;
            }
            return true;
        }

        private DataType parseTypeWithNullability() {
            DataType dataType = this.parseTypeByKeyword().copy(this.parseNullability());
            if (this.hasNextToken(Keyword.ARRAY)) {
                this.nextToken(Keyword.ARRAY);
                return new ArrayType(dataType).copy(this.parseNullability());
            }
            if (this.hasNextToken(Keyword.MULTISET)) {
                this.nextToken(Keyword.MULTISET);
                return new MultisetType(dataType).copy(this.parseNullability());
            }
            return dataType;
        }

        private DataType parseTypeByKeyword() {
            this.nextToken(TokenType.KEYWORD);
            switch (this.tokenAsKeyword()) {
                case CHAR: {
                    return this.parseCharType();
                }
                case VARCHAR: {
                    return this.parseVarCharType();
                }
                case STRING: {
                    return VarCharType.STRING_TYPE;
                }
                case BOOLEAN: {
                    return new BooleanType();
                }
                case BINARY: {
                    return this.parseBinaryType();
                }
                case VARBINARY: {
                    return this.parseVarBinaryType();
                }
                case BYTES: {
                    return new VarBinaryType(Integer.MAX_VALUE);
                }
                case DECIMAL: 
                case NUMERIC: 
                case DEC: {
                    return this.parseDecimalType();
                }
                case TINYINT: {
                    return new TinyIntType();
                }
                case SMALLINT: {
                    return new SmallIntType();
                }
                case INT: 
                case INTEGER: {
                    return new IntType();
                }
                case BIGINT: {
                    return new BigIntType();
                }
                case FLOAT: {
                    return new FloatType();
                }
                case DOUBLE: {
                    return this.parseDoubleType();
                }
                case DATE: {
                    return new DateType();
                }
                case TIME: {
                    return this.parseTimeType();
                }
                case TIMESTAMP: {
                    return this.parseTimestampType();
                }
                case TIMESTAMP_LTZ: {
                    return this.parseTimestampLtzType();
                }
                case VARIANT: {
                    return new VariantType();
                }
            }
            throw this.parsingError("Unsupported type: " + this.token().value);
        }

        private int parseStringType() {
            if (this.hasNextToken(TokenType.BEGIN_PARAMETER)) {
                this.nextToken(TokenType.BEGIN_PARAMETER);
                this.nextToken(TokenType.LITERAL_INT);
                int length = this.tokenAsInt();
                this.nextToken(TokenType.END_PARAMETER);
                return length;
            }
            return -1;
        }

        private DataType parseCharType() {
            int length = this.parseStringType();
            if (length < 0) {
                return new CharType();
            }
            return new CharType(length);
        }

        private DataType parseVarCharType() {
            int length = this.parseStringType();
            if (length < 0) {
                return new VarCharType();
            }
            return new VarCharType(length);
        }

        private DataType parseBinaryType() {
            int length = this.parseStringType();
            if (length < 0) {
                return new BinaryType();
            }
            return new BinaryType(length);
        }

        private DataType parseVarBinaryType() {
            int length = this.parseStringType();
            if (length < 0) {
                return new VarBinaryType();
            }
            return new VarBinaryType(length);
        }

        private DataType parseDecimalType() {
            int precision = 10;
            int scale = 0;
            if (this.hasNextToken(TokenType.BEGIN_PARAMETER)) {
                this.nextToken(TokenType.BEGIN_PARAMETER);
                this.nextToken(TokenType.LITERAL_INT);
                precision = this.tokenAsInt();
                if (this.hasNextToken(TokenType.LIST_SEPARATOR)) {
                    this.nextToken(TokenType.LIST_SEPARATOR);
                    this.nextToken(TokenType.LITERAL_INT);
                    scale = this.tokenAsInt();
                }
                this.nextToken(TokenType.END_PARAMETER);
            }
            return new DecimalType(precision, scale);
        }

        private DataType parseDoubleType() {
            if (this.hasNextToken(Keyword.PRECISION)) {
                this.nextToken(Keyword.PRECISION);
            }
            return new DoubleType();
        }

        private DataType parseTimeType() {
            int precision = this.parseOptionalPrecision(0);
            if (this.hasNextToken(Keyword.WITHOUT)) {
                this.nextToken(Keyword.WITHOUT);
                this.nextToken(Keyword.TIME);
                this.nextToken(Keyword.ZONE);
            }
            return new TimeType(precision);
        }

        private DataType parseTimestampType() {
            int precision = this.parseOptionalPrecision(6);
            if (this.hasNextToken(Keyword.WITHOUT)) {
                this.nextToken(Keyword.WITHOUT);
                this.nextToken(Keyword.TIME);
                this.nextToken(Keyword.ZONE);
            } else if (this.hasNextToken(Keyword.WITH)) {
                this.nextToken(Keyword.WITH);
                if (this.hasNextToken(Keyword.LOCAL)) {
                    this.nextToken(Keyword.LOCAL);
                    this.nextToken(Keyword.TIME);
                    this.nextToken(Keyword.ZONE);
                    return new LocalZonedTimestampType(precision);
                }
            }
            return new TimestampType(precision);
        }

        private DataType parseTimestampLtzType() {
            int precision = this.parseOptionalPrecision(6);
            return new LocalZonedTimestampType(precision);
        }

        private int parseOptionalPrecision(int defaultPrecision) {
            int precision = defaultPrecision;
            if (this.hasNextToken(TokenType.BEGIN_PARAMETER)) {
                this.nextToken(TokenType.BEGIN_PARAMETER);
                this.nextToken(TokenType.LITERAL_INT);
                precision = this.tokenAsInt();
                this.nextToken(TokenType.END_PARAMETER);
            }
            return precision;
        }
    }

    private static class Token {
        public final TokenType type;
        public final int cursorPosition;
        public final String value;

        public Token(TokenType type, int cursorPosition, String value) {
            this.type = type;
            this.cursorPosition = cursorPosition;
            this.value = value;
        }
    }

    private static enum Keyword {
        CHAR,
        VARCHAR,
        STRING,
        BOOLEAN,
        BINARY,
        VARBINARY,
        BYTES,
        DECIMAL,
        NUMERIC,
        DEC,
        TINYINT,
        SMALLINT,
        INT,
        INTEGER,
        BIGINT,
        FLOAT,
        DOUBLE,
        PRECISION,
        DATE,
        TIME,
        WITH,
        WITHOUT,
        LOCAL,
        ZONE,
        TIMESTAMP,
        TIMESTAMP_LTZ,
        INTERVAL,
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        TO,
        ARRAY,
        MULTISET,
        MAP,
        ROW,
        NULL,
        RAW,
        LEGACY,
        VARIANT,
        NOT;

    }

    private static enum TokenType {
        BEGIN_SUBTYPE,
        END_SUBTYPE,
        BEGIN_PARAMETER,
        END_PARAMETER,
        LIST_SEPARATOR,
        LITERAL_STRING,
        LITERAL_INT,
        KEYWORD,
        IDENTIFIER,
        IDENTIFIER_SEPARATOR;

    }
}

