/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.consumer.Consumer;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.TableQueryAuth;
import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.CompactedStartingScanner;
import org.apache.paimon.table.source.snapshot.ContinuousCompactorStartingScanner;
import org.apache.paimon.table.source.snapshot.ContinuousFromSnapshotFullStartingScanner;
import org.apache.paimon.table.source.snapshot.ContinuousFromSnapshotStartingScanner;
import org.apache.paimon.table.source.snapshot.ContinuousFromTimestampStartingScanner;
import org.apache.paimon.table.source.snapshot.ContinuousLatestStartingScanner;
import org.apache.paimon.table.source.snapshot.EmptyResultStartingScanner;
import org.apache.paimon.table.source.snapshot.FileCreationTimeStartingScanner;
import org.apache.paimon.table.source.snapshot.FullCompactedStartingScanner;
import org.apache.paimon.table.source.snapshot.FullStartingScanner;
import org.apache.paimon.table.source.snapshot.IncrementalDeltaStartingScanner;
import org.apache.paimon.table.source.snapshot.IncrementalDiffStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.table.source.snapshot.StaticFromSnapshotStartingScanner;
import org.apache.paimon.table.source.snapshot.StaticFromTagStartingScanner;
import org.apache.paimon.table.source.snapshot.StaticFromTimestampStartingScanner;
import org.apache.paimon.table.source.snapshot.StaticFromWatermarkStartingScanner;
import org.apache.paimon.table.source.snapshot.TimeTravelUtil;
import org.apache.paimon.tag.Tag;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDataTableScan
implements DataTableScan {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataTableScan.class);
    private final TableSchema schema;
    private final CoreOptions options;
    protected final SnapshotReader snapshotReader;
    private final TableQueryAuth queryAuth;
    @Nullable
    private RowType readType;
    @Nullable
    private Predicate predicate;

    protected AbstractDataTableScan(TableSchema schema, CoreOptions options, SnapshotReader snapshotReader, TableQueryAuth queryAuth) {
        this.schema = schema;
        this.options = options;
        this.snapshotReader = snapshotReader;
        this.queryAuth = queryAuth;
    }

    @Override
    public InnerTableScan withFilter(Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public AbstractDataTableScan withBucket(int bucket) {
        this.snapshotReader.withBucket(bucket);
        return this;
    }

    @Override
    public AbstractDataTableScan withBucketFilter(Filter<Integer> bucketFilter) {
        this.snapshotReader.withBucketFilter(bucketFilter);
        return this;
    }

    @Override
    public InnerTableScan withReadType(@Nullable RowType readType) {
        this.readType = readType;
        return this;
    }

    @Override
    public AbstractDataTableScan withPartitionFilter(Map<String, String> partitionSpec) {
        this.snapshotReader.withPartitionFilter(partitionSpec);
        return this;
    }

    @Override
    public AbstractDataTableScan withPartitionFilter(List<BinaryRow> partitions) {
        this.snapshotReader.withPartitionFilter(partitions);
        return this;
    }

    @Override
    public AbstractDataTableScan withPartitionsFilter(List<Map<String, String>> partitions) {
        this.snapshotReader.withPartitionsFilter(partitions);
        return this;
    }

    @Override
    public AbstractDataTableScan withLevelFilter(Filter<Integer> levelFilter) {
        this.snapshotReader.withLevelFilter(levelFilter);
        return this;
    }

    @Override
    public AbstractDataTableScan withMetricRegistry(MetricRegistry metricsRegistry) {
        this.snapshotReader.withMetricRegistry(metricsRegistry);
        return this;
    }

    protected void authQuery() {
        if (!this.options.queryAuthEnabled()) {
            return;
        }
        this.queryAuth.auth(this.readType == null ? null : this.readType.getFieldNames());
    }

    @Override
    public AbstractDataTableScan dropStats() {
        this.snapshotReader.dropStats();
        return this;
    }

    public CoreOptions options() {
        return this.options;
    }

    protected StartingScanner createStartingScanner(boolean isStreaming) {
        ConsumerManager consumerManager;
        Optional<Consumer> consumer;
        SnapshotManager snapshotManager = this.snapshotReader.snapshotManager();
        ChangelogManager changelogManager = this.snapshotReader.changelogManager();
        CoreOptions.StreamScanMode type = this.options.toConfiguration().get(CoreOptions.STREAM_SCAN_MODE);
        switch (type) {
            case COMPACT_BUCKET_TABLE: {
                Preconditions.checkArgument(isStreaming, "Set 'streaming-compact' in batch mode. This is unexpected.");
                return new ContinuousCompactorStartingScanner(snapshotManager);
            }
            case FILE_MONITOR: {
                return new FullStartingScanner(snapshotManager);
            }
        }
        String consumerId = this.options.consumerId();
        if (isStreaming && consumerId != null && !this.options.consumerIgnoreProgress() && (consumer = (consumerManager = this.snapshotReader.consumerManager()).consumer(consumerId)).isPresent()) {
            return new ContinuousFromSnapshotStartingScanner(snapshotManager, changelogManager, consumer.get().nextSnapshot(), this.options.changelogLifecycleDecoupled());
        }
        CoreOptions.StartupMode startupMode = this.options.startupMode();
        switch (startupMode) {
            case LATEST_FULL: {
                return new FullStartingScanner(snapshotManager);
            }
            case LATEST: {
                return isStreaming ? new ContinuousLatestStartingScanner(snapshotManager) : new FullStartingScanner(snapshotManager);
            }
            case COMPACTED_FULL: {
                if (this.options.changelogProducer() == CoreOptions.ChangelogProducer.FULL_COMPACTION || this.options.toConfiguration().contains(CoreOptions.FULL_COMPACTION_DELTA_COMMITS)) {
                    int deltaCommits = this.options.toConfiguration().getOptional(CoreOptions.FULL_COMPACTION_DELTA_COMMITS).orElse(1);
                    return new FullCompactedStartingScanner(snapshotManager, deltaCommits);
                }
                return new CompactedStartingScanner(snapshotManager);
            }
            case FROM_TIMESTAMP: {
                String timestampStr = this.options.scanTimestamp();
                Long startupMillis = this.options.scanTimestampMills();
                if (startupMillis == null && timestampStr != null) {
                    startupMillis = DateTimeUtils.parseTimestampData(timestampStr, 3, TimeZone.getDefault()).getMillisecond();
                }
                return isStreaming ? new ContinuousFromTimestampStartingScanner(snapshotManager, changelogManager, startupMillis, this.options.changelogLifecycleDecoupled()) : new StaticFromTimestampStartingScanner(snapshotManager, startupMillis);
            }
            case FROM_FILE_CREATION_TIME: {
                Long fileCreationTimeMills = this.options.scanFileCreationTimeMills();
                return new FileCreationTimeStartingScanner(snapshotManager, fileCreationTimeMills);
            }
            case FROM_CREATION_TIMESTAMP: {
                Long creationTimeMills = this.options.scanCreationTimeMills();
                return AbstractDataTableScan.createCreationTimestampStartingScanner(snapshotManager, changelogManager, creationTimeMills, this.options.changelogLifecycleDecoupled(), isStreaming);
            }
            case FROM_SNAPSHOT: {
                if (this.options.scanSnapshotId() != null) {
                    return isStreaming ? new ContinuousFromSnapshotStartingScanner(snapshotManager, changelogManager, this.options.scanSnapshotId(), this.options.changelogLifecycleDecoupled()) : new StaticFromSnapshotStartingScanner(snapshotManager, this.options.scanSnapshotId());
                }
                if (this.options.scanWatermark() != null) {
                    Preconditions.checkArgument(!isStreaming, "Cannot scan from watermark in streaming mode.");
                    return new StaticFromWatermarkStartingScanner(snapshotManager, this.options().scanWatermark());
                }
                if (this.options.scanTagName() != null) {
                    Preconditions.checkArgument(!isStreaming, "Cannot scan from tag in streaming mode.");
                    return new StaticFromTagStartingScanner(snapshotManager, this.options().scanTagName());
                }
                throw new UnsupportedOperationException("Unknown snapshot read mode");
            }
            case FROM_SNAPSHOT_FULL: {
                Long scanSnapshotId = this.options.scanSnapshotId();
                Preconditions.checkNotNull(scanSnapshotId, "scan.snapshot-id must be set when startupMode is FROM_SNAPSHOT_FULL.");
                return isStreaming ? new ContinuousFromSnapshotFullStartingScanner(snapshotManager, scanSnapshotId) : new StaticFromSnapshotStartingScanner(snapshotManager, scanSnapshotId);
            }
            case INCREMENTAL: {
                Preconditions.checkArgument(!isStreaming, "Cannot read incremental in streaming mode.");
                return this.createIncrementalStartingScanner(snapshotManager);
            }
        }
        throw new UnsupportedOperationException("Unknown startup mode " + startupMode.name());
    }

    public static StartingScanner createCreationTimestampStartingScanner(SnapshotManager snapshotManager, ChangelogManager changelogManager, long creationMillis, boolean changelogDecoupled, boolean isStreaming) {
        Long startingSnapshotPrevId = TimeTravelUtil.earlierThanTimeMills(snapshotManager, changelogManager, creationMillis, changelogDecoupled, true);
        Optional<Long> startingSnapshotId = Optional.ofNullable(startingSnapshotPrevId).map(id -> id + 1L).filter(id -> snapshotManager.snapshotExists((long)id) || changelogManager.longLivedChangelogExists((long)id));
        AbstractStartingScanner scanner = startingSnapshotId.isPresent() ? (isStreaming ? new ContinuousFromSnapshotStartingScanner(snapshotManager, changelogManager, startingSnapshotId.get(), changelogDecoupled) : new StaticFromSnapshotStartingScanner(snapshotManager, startingSnapshotId.get())) : new FileCreationTimeStartingScanner(snapshotManager, creationMillis);
        return scanner;
    }

    private StartingScanner createIncrementalStartingScanner(SnapshotManager snapshotManager) {
        Options conf = this.options.toConfiguration();
        if (conf.contains(CoreOptions.INCREMENTAL_BETWEEN)) {
            long endId;
            long startId;
            Pair<String, String> incrementalBetween = this.options.incrementalBetween();
            TagManager tagManager = new TagManager(snapshotManager.fileIO(), snapshotManager.tablePath(), snapshotManager.branch());
            Optional<Tag> startTag = tagManager.get(incrementalBetween.getLeft());
            Optional<Tag> endTag = tagManager.get(incrementalBetween.getRight());
            if (startTag.isPresent() && endTag.isPresent()) {
                return IncrementalDiffStartingScanner.betweenTags(startTag.get(), endTag.get(), snapshotManager, incrementalBetween);
            }
            try {
                startId = Long.parseLong(incrementalBetween.getLeft());
                endId = Long.parseLong(incrementalBetween.getRight());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Didn't find two tags for start '%s' and end '%s', and they are not two snapshot Ids. Please set two tags or two snapshot Ids.", incrementalBetween.getLeft(), incrementalBetween.getRight()));
            }
            Preconditions.checkArgument(endId >= startId, "Ending snapshotId should >= starting snapshotId %s.", endId, startId);
            if (snapshotManager.earliestSnapshot() == null) {
                LOG.warn("There is currently no snapshot. Waiting for snapshot generation.");
                return new EmptyResultStartingScanner(snapshotManager);
            }
            if (startId == endId) {
                return new EmptyResultStartingScanner(snapshotManager);
            }
            CoreOptions.IncrementalBetweenScanMode scanMode = this.options.incrementalBetweenScanMode();
            return scanMode == CoreOptions.IncrementalBetweenScanMode.DIFF ? IncrementalDiffStartingScanner.betweenSnapshotIds(startId, endId, snapshotManager) : IncrementalDeltaStartingScanner.betweenSnapshotIds(startId, endId, snapshotManager, this.toSnapshotScanMode(scanMode));
        }
        if (conf.contains(CoreOptions.INCREMENTAL_BETWEEN_TIMESTAMP)) {
            Pair<Long, Long> incrementalBetween;
            String incrementalBetweenStr = this.options.incrementalBetweenTimestamp();
            String[] split = incrementalBetweenStr.split(",");
            if (split.length != 2) {
                throw new IllegalArgumentException("The incremental-between-timestamp must specific start(exclusive) and end timestamp. But is: " + incrementalBetweenStr);
            }
            try {
                incrementalBetween = Pair.of(Long.parseLong(split[0]), Long.parseLong(split[1]));
            }
            catch (NumberFormatException nfe) {
                try {
                    long startTimestamp = DateTimeUtils.parseTimestampData(split[0], 3, TimeZone.getDefault()).getMillisecond();
                    long endTimestamp = DateTimeUtils.parseTimestampData(split[1], 3, TimeZone.getDefault()).getMillisecond();
                    incrementalBetween = Pair.of(startTimestamp, endTimestamp);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("The incremental-between-timestamp must specific start(exclusive) and end timestamp. But is: " + incrementalBetweenStr);
                }
            }
            Snapshot earliestSnapshot = snapshotManager.earliestSnapshot();
            Snapshot latestSnapshot = snapshotManager.latestSnapshot();
            if (earliestSnapshot == null || latestSnapshot == null) {
                return new EmptyResultStartingScanner(snapshotManager);
            }
            long startTimestamp = incrementalBetween.getLeft();
            long endTimestamp = incrementalBetween.getRight();
            Preconditions.checkArgument(endTimestamp >= startTimestamp, "Ending timestamp %s should be >= starting timestamp %s.", endTimestamp, startTimestamp);
            if (startTimestamp == endTimestamp || startTimestamp > latestSnapshot.timeMillis() || endTimestamp < earliestSnapshot.timeMillis()) {
                return new EmptyResultStartingScanner(snapshotManager);
            }
            CoreOptions.IncrementalBetweenScanMode scanMode = this.options.incrementalBetweenScanMode();
            return scanMode == CoreOptions.IncrementalBetweenScanMode.DIFF ? IncrementalDiffStartingScanner.betweenTimestamps(startTimestamp, endTimestamp, snapshotManager) : IncrementalDeltaStartingScanner.betweenTimestamps(startTimestamp, endTimestamp, snapshotManager, this.toSnapshotScanMode(scanMode));
        }
        if (conf.contains(CoreOptions.INCREMENTAL_TO_AUTO_TAG)) {
            String endTag = this.options.incrementalToAutoTag();
            return IncrementalDiffStartingScanner.toEndAutoTag(snapshotManager, endTag, this.options);
        }
        throw new UnsupportedOperationException("Unknown incremental read mode.");
    }

    private ScanMode toSnapshotScanMode(CoreOptions.IncrementalBetweenScanMode scanMode) {
        switch (scanMode) {
            case AUTO: {
                return this.options.changelogProducer() == CoreOptions.ChangelogProducer.NONE ? ScanMode.DELTA : ScanMode.CHANGELOG;
            }
            case DELTA: {
                return ScanMode.DELTA;
            }
            case CHANGELOG: {
                return ScanMode.CHANGELOG;
            }
        }
        throw new UnsupportedOperationException("Unsupported incremental scan mode " + scanMode.name());
    }
}

