/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.hadoop.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.compress.DirectDecompressor;
import org.apache.paimon.shade.io.airlift.compress.lz4.Lz4Decompressor;
import org.apache.paimon.shade.org.apache.parquet.hadoop.codec.NonBlockedDecompressor;

public class Lz4RawDecompressor
extends NonBlockedDecompressor
implements DirectDecompressor {
    private Lz4Decompressor decompressor = new Lz4Decompressor();

    @Override
    protected int maxUncompressedLength(ByteBuffer compressed, int maxUncompressedLength) throws IOException {
        return maxUncompressedLength;
    }

    @Override
    protected int uncompress(ByteBuffer compressed, ByteBuffer uncompressed) throws IOException {
        this.decompressor.decompress(compressed, uncompressed);
        int uncompressedSize = uncompressed.position();
        uncompressed.limit(uncompressedSize);
        uncompressed.rewind();
        return uncompressedSize;
    }

    public void decompress(ByteBuffer compressed, ByteBuffer uncompressed) throws IOException {
        this.uncompress(compressed, uncompressed);
    }
}

