/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.options;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.StructuredOptionsSplitter;
import org.apache.paimon.utils.TimeUtils;

public class OptionsUtils {
    public static final String PAIMON_PREFIX = "paimon.";

    public static <T> T convertValue(Object rawValue, Class<?> clazz) {
        if (Integer.class.equals(clazz)) {
            return (T)OptionsUtils.convertToInt(rawValue);
        }
        if (Long.class.equals(clazz)) {
            return (T)OptionsUtils.convertToLong(rawValue);
        }
        if (Boolean.class.equals(clazz)) {
            return (T)OptionsUtils.convertToBoolean(rawValue);
        }
        if (Float.class.equals(clazz)) {
            return (T)OptionsUtils.convertToFloat(rawValue);
        }
        if (Double.class.equals(clazz)) {
            return (T)OptionsUtils.convertToDouble(rawValue);
        }
        if (String.class.equals(clazz)) {
            return (T)OptionsUtils.convertToString(rawValue);
        }
        if (clazz.isEnum()) {
            return (T)OptionsUtils.convertToEnum(rawValue, clazz);
        }
        if (clazz == Duration.class) {
            return (T)OptionsUtils.convertToDuration(rawValue);
        }
        if (clazz == MemorySize.class) {
            return (T)OptionsUtils.convertToMemorySize(rawValue);
        }
        if (clazz == Map.class) {
            return (T)OptionsUtils.convertToProperties(rawValue);
        }
        throw new IllegalArgumentException("Unsupported type: " + clazz);
    }

    static Map<String, String> convertToProperties(Object o) {
        if (o instanceof Map) {
            return (Map)o;
        }
        List<String> listOfRawProperties = StructuredOptionsSplitter.splitEscaped(o.toString(), ',');
        return listOfRawProperties.stream().map(s -> StructuredOptionsSplitter.splitEscaped(s, ':')).peek(pair -> {
            if (pair.size() != 2) {
                throw new IllegalArgumentException("Map item is not a key-value pair (missing ':'?)");
            }
        }).collect(Collectors.toMap(a -> (String)a.get(0), a -> (String)a.get(1)));
    }

    public static <E extends Enum<?>> E convertToEnum(Object o, Class<E> clazz) {
        if (o.getClass().equals(clazz)) {
            return (E)((Enum)o);
        }
        return (E)Arrays.stream(clazz.getEnumConstants()).filter(e -> e.toString().toUpperCase(Locale.ROOT).equals(o.toString().toUpperCase(Locale.ROOT))).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Could not parse value for enum %s. Expected one of: [%s]", clazz, Arrays.toString(clazz.getEnumConstants()))));
    }

    static Duration convertToDuration(Object o) {
        if (o.getClass() == Duration.class) {
            return (Duration)o;
        }
        return TimeUtils.parseDuration(o.toString());
    }

    static MemorySize convertToMemorySize(Object o) {
        if (o.getClass() == MemorySize.class) {
            return (MemorySize)o;
        }
        return MemorySize.parse(o.toString());
    }

    static String convertToString(Object o) {
        if (o.getClass() == String.class) {
            return (String)o;
        }
        if (o.getClass() == Duration.class) {
            Duration duration = (Duration)o;
            return TimeUtils.formatWithHighestUnit(duration);
        }
        if (o instanceof List) {
            return ((List)o).stream().map(e -> StructuredOptionsSplitter.escapeWithSingleQuote(OptionsUtils.convertToString(e), ";")).collect(Collectors.joining(";"));
        }
        if (o instanceof Map) {
            return ((Map)o).entrySet().stream().map(e -> {
                String escapedKey = StructuredOptionsSplitter.escapeWithSingleQuote(e.getKey().toString(), ":");
                String escapedValue = StructuredOptionsSplitter.escapeWithSingleQuote(e.getValue().toString(), ":");
                return StructuredOptionsSplitter.escapeWithSingleQuote(escapedKey + ":" + escapedValue, ",");
            }).collect(Collectors.joining(","));
        }
        return o.toString();
    }

    static Integer convertToInt(Object o) {
        if (o.getClass() == Integer.class) {
            return (Integer)o;
        }
        if (o.getClass() == Long.class) {
            long value = (Long)o;
            if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                return (int)value;
            }
            throw new IllegalArgumentException(String.format("Configuration value %s overflows/underflows the integer type.", value));
        }
        return Integer.parseInt(o.toString());
    }

    static Long convertToLong(Object o) {
        if (o.getClass() == Long.class) {
            return (Long)o;
        }
        if (o.getClass() == Integer.class) {
            return ((Integer)o).longValue();
        }
        return Long.parseLong(o.toString());
    }

    static Boolean convertToBoolean(Object o) {
        if (o.getClass() == Boolean.class) {
            return (Boolean)o;
        }
        switch (o.toString().toUpperCase()) {
            case "TRUE": {
                return true;
            }
            case "FALSE": {
                return false;
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized option for boolean: %s. Expected either true or false(case insensitive)", o));
    }

    static Float convertToFloat(Object o) {
        if (o.getClass() == Float.class) {
            return (Float)o;
        }
        if (o.getClass() == Double.class) {
            double value = (Double)o;
            if (value == 0.0 || value >= (double)1.4E-45f && value <= 3.4028234663852886E38 || value >= -3.4028234663852886E38 && value <= (double)-1.4E-45f) {
                return Float.valueOf((float)value);
            }
            throw new IllegalArgumentException(String.format("Configuration value %s overflows/underflows the float type.", value));
        }
        return Float.valueOf(Float.parseFloat(o.toString()));
    }

    static Double convertToDouble(Object o) {
        if (o.getClass() == Double.class) {
            return (Double)o;
        }
        if (o.getClass() == Float.class) {
            return ((Float)o).doubleValue();
        }
        return Double.parseDouble(o.toString());
    }

    public static boolean canBePrefixMap(ConfigOption<?> configOption) {
        return configOption.getClazz() == Map.class;
    }

    public static boolean filterPrefixMapKey(String key, String candidate) {
        String prefixKey = key + ".";
        return candidate.startsWith(prefixKey);
    }

    static Map<String, String> convertToPropertiesPrefixed(Map<String, String> confData, String key) {
        return OptionsUtils.convertToPropertiesPrefixKey(confData, key + ".");
    }

    public static Map<String, String> convertToPropertiesPrefixKey(Map<String, String> confData, String prefixKey) {
        return confData.keySet().stream().filter(k -> k.startsWith(prefixKey)).collect(Collectors.toMap(k -> k.substring(prefixKey.length()), k -> OptionsUtils.convertToString(confData.get(k))));
    }

    public static Map<String, String> convertToPropertiesPrefixKey(Iterable<Map.Entry<String, String>> confData, String prefixKey, Predicate<String> valuePredicate) {
        HashMap<String, String> properties = new HashMap<String, String>();
        confData.forEach(entry -> {
            if (((String)entry.getKey()).startsWith(prefixKey) && valuePredicate.test((String)entry.getValue())) {
                properties.put(((String)entry.getKey()).substring(prefixKey.length()), (String)entry.getValue());
            }
        });
        return properties;
    }

    public static Map<String, String> convertToDynamicTableProperties(Map<String, String> confData, String globalOptionKeyPrefix, Pattern tableOptionKeyPattern, int keyGroup) {
        HashMap<String, String> globalOptions = new HashMap<String, String>();
        HashMap tableOptions = new HashMap();
        confData.keySet().stream().filter(k -> k.startsWith(globalOptionKeyPrefix)).forEach(k -> {
            Matcher matcher = tableOptionKeyPattern.matcher((CharSequence)k);
            if (matcher.find()) {
                tableOptions.put(matcher.group(keyGroup), OptionsUtils.convertToString(confData.get(k)));
            } else {
                globalOptions.put(k.substring(globalOptionKeyPrefix.length()), OptionsUtils.convertToString(confData.get(k)));
            }
        });
        globalOptions.putAll(tableOptions);
        return globalOptions;
    }

    static boolean containsPrefixMap(Map<String, String> confData, String key) {
        return confData.keySet().stream().anyMatch(candidate -> OptionsUtils.filterPrefixMapKey(key, candidate));
    }

    static boolean removePrefixMap(Map<String, String> confData, String key) {
        List<String> prefixKeys = confData.keySet().stream().filter(candidate -> OptionsUtils.filterPrefixMapKey(key, candidate)).collect(Collectors.toList());
        prefixKeys.forEach(confData::remove);
        return !prefixKeys.isEmpty();
    }

    private OptionsUtils() {
    }
}

