/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.compact.CompactTask;
import org.apache.paimon.compact.CompactUnit;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.CompactRewriter;
import org.apache.paimon.operation.metrics.CompactionMetrics;

public class FileRewriteCompactTask
extends CompactTask {
    private final CompactRewriter rewriter;
    private final int outputLevel;
    private final List<DataFileMeta> files;
    private final boolean dropDelete;

    public FileRewriteCompactTask(CompactRewriter rewriter, CompactUnit unit, boolean dropDelete, @Nullable CompactionMetrics.Reporter metricsReporter) {
        super(metricsReporter);
        this.rewriter = rewriter;
        this.outputLevel = unit.outputLevel();
        this.files = unit.files();
        this.dropDelete = dropDelete;
    }

    @Override
    protected CompactResult doCompact() throws Exception {
        CompactResult result = new CompactResult();
        for (DataFileMeta file : this.files) {
            this.rewriteFile(file, result);
        }
        return result;
    }

    private void rewriteFile(DataFileMeta file, CompactResult toUpdate) throws Exception {
        List<List<SortedRun>> candidate = Collections.singletonList(Collections.singletonList(SortedRun.fromSingle(file)));
        toUpdate.merge(this.rewriter.rewrite(this.outputLevel, this.dropDelete, candidate));
    }
}

