/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.rocksdb;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.lookup.StateFactory;
import org.apache.paimon.lookup.rocksdb.RocksDBListState;
import org.apache.paimon.lookup.rocksdb.RocksDBOptions;
import org.apache.paimon.lookup.rocksdb.RocksDBSetState;
import org.apache.paimon.lookup.rocksdb.RocksDBValueState;
import org.apache.paimon.options.Options;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.TtlDB;

public class RocksDBStateFactory
implements StateFactory {
    public static final String MERGE_OPERATOR_NAME = "stringappendtest";
    private final org.rocksdb.Options options;
    private final String path;
    private final ColumnFamilyOptions columnFamilyOptions;
    private RocksDB db;

    public RocksDBStateFactory(String path, Options conf, @Nullable Duration ttlSecs) throws IOException {
        DBOptions dbOptions = RocksDBOptions.createDBOptions(new DBOptions().setUseFsync(false).setStatsDumpPeriodSec(0).setCreateIfMissing(true), conf);
        this.path = path;
        this.columnFamilyOptions = RocksDBOptions.createColumnOptions(new ColumnFamilyOptions(), conf).setMergeOperatorName(MERGE_OPERATOR_NAME);
        this.options = new org.rocksdb.Options(dbOptions, this.columnFamilyOptions);
        try {
            this.db = ttlSecs == null ? RocksDB.open((org.rocksdb.Options)this.options, (String)path) : TtlDB.open((org.rocksdb.Options)this.options, (String)path, (int)((int)ttlSecs.getSeconds()), (boolean)false);
        }
        catch (RocksDBException e) {
            throw new IOException("Error while opening RocksDB instance.", e);
        }
    }

    public RocksDB db() {
        return this.db;
    }

    public org.rocksdb.Options options() {
        return this.options;
    }

    public String path() {
        return this.path;
    }

    public <K, V> RocksDBValueState<K, V> valueState(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) throws IOException {
        return new RocksDBValueState<K, V>(this, this.createColumnFamily(name), keySerializer, valueSerializer, lruCacheSize);
    }

    public <K, V> RocksDBSetState<K, V> setState(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) throws IOException {
        return new RocksDBSetState<K, V>(this, this.createColumnFamily(name), keySerializer, valueSerializer, lruCacheSize);
    }

    public <K, V> RocksDBListState<K, V> listState(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) throws IOException {
        return new RocksDBListState<K, V>(this, this.createColumnFamily(name), keySerializer, valueSerializer, lruCacheSize);
    }

    @Override
    public boolean preferBulkLoad() {
        return true;
    }

    private ColumnFamilyHandle createColumnFamily(String name) throws IOException {
        try {
            return this.db.createColumnFamily(new ColumnFamilyDescriptor(name.getBytes(StandardCharsets.UTF_8), this.columnFamilyOptions));
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }
}

